/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.css.CssTree;
import com.google.caja.plugin.CssRewriter;
import com.google.caja.plugin.CssValidator;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.util.Pipeline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidateCssStage
implements Pipeline.Stage<Jobs> {
    private final CssSchema cssSchema;
    private final HtmlSchema htmlSchema;

    public ValidateCssStage(CssSchema cssSchema, HtmlSchema htmlSchema) {
        if (null == cssSchema) {
            throw new NullPointerException();
        }
        if (null == htmlSchema) {
            throw new NullPointerException();
        }
        this.cssSchema = cssSchema;
        this.htmlSchema = htmlSchema;
    }

    @Override
    public boolean apply(Jobs jobs) {
        CssValidator v = new CssValidator(this.cssSchema, this.htmlSchema, jobs.getMessageQueue());
        CssRewriter rw = new CssRewriter(jobs.getPluginMeta().getPluginEnvironment(), jobs.getMessageQueue());
        v.withInvalidNodeMessageLevel(MessageLevel.WARNING);
        rw.withInvalidNodeMessageLevel(MessageLevel.WARNING);
        for (Job job : jobs.getJobsByType(Job.JobType.CSS, new Job.JobType[0])) {
            ValidateCssStage.validate(v, rw, job.getRoot().cast(CssTree.class));
        }
        v.withInvalidNodeMessageLevel(MessageLevel.ERROR);
        rw.withInvalidNodeMessageLevel(MessageLevel.ERROR);
        return jobs.hasNoFatalErrors();
    }

    private static final void validate(CssValidator v, CssRewriter rw, AncestorChain<CssTree> css) {
        v.validateCss(css);
        rw.rewrite(css);
    }
}

