/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.render.AbstractRenderer;
import com.google.caja.render.TokenClassification;
import java.util.ArrayList;
import java.util.List;

public final class CssPrettyPrinter
extends AbstractRenderer {
    private List<Integer> indentStack = new ArrayList<Integer>();
    private int charInLine;
    private char pendingSpace = '\u0000';

    public CssPrettyPrinter(TokenConsumer out) {
        super(out);
    }

    public void mark(FilePosition pos) {
        this.out.mark(pos);
    }

    public void consume(String text) {
        TokenClassification tClass = TokenClassification.classify(text);
        if (tClass == null) {
            return;
        }
        switch (tClass) {
            case LINEBREAK: {
                if (this.pendingSpace == '\n') {
                    this.newLine();
                }
                this.pendingSpace = (char)10;
                return;
            }
            case SPACE: {
                if (this.pendingSpace != '\n') {
                    this.pendingSpace = (char)32;
                }
                return;
            }
            case COMMENT: {
                this.emit(text);
                return;
            }
        }
        int spaceBefore = this.pendingSpace;
        this.pendingSpace = '\u0000';
        int spaceAfter = 0;
        Integer nextIndent = null;
        if (text.length() == 1) {
            char ch0 = text.charAt(0);
            switch (ch0) {
                case '{': {
                    if (spaceBefore != 10) {
                        spaceBefore = 32;
                    }
                    nextIndent = this.getIndentation() + 2;
                    spaceAfter = 10;
                    break;
                }
                case '}': {
                    spaceBefore = 10;
                    spaceAfter = 10;
                    this.popIndentStack();
                    break;
                }
                case ',': {
                    spaceBefore = 0;
                    spaceAfter = 32;
                    break;
                }
                case ';': {
                    spaceBefore = 0;
                    spaceAfter = this.indentStack.isEmpty() ? 32 : 10;
                }
            }
        }
        switch (spaceBefore) {
            case 10: {
                this.newLine();
                break;
            }
            case 32: {
                this.space();
            }
        }
        this.indent();
        this.emit(text);
        if (nextIndent != null) {
            this.pushIndent(nextIndent);
        }
        this.pendingSpace = (char)spaceAfter;
    }

    private int getIndentation() {
        return this.indentStack.isEmpty() ? 0 : this.indentStack.get(this.indentStack.size() - 1);
    }

    private void pushIndent(int indent) {
        this.indentStack.add(indent);
    }

    private void popIndentStack() {
        if (!this.indentStack.isEmpty()) {
            this.indentStack.remove(this.indentStack.size() - 1);
        }
    }

    private void indent() {
        int indent;
        if (this.charInLine != 0) {
            return;
        }
        this.charInLine += indent;
        String spaces = "                ";
        for (indent = this.getIndentation(); indent >= spaces.length(); indent -= spaces.length()) {
            this.out.consume(spaces);
        }
        if (indent != 0) {
            this.out.consume(spaces.substring(0, indent));
        }
    }

    private void newLine() {
        if (this.charInLine == 0) {
            return;
        }
        this.charInLine = 0;
        this.out.consume("\n");
    }

    private void space() {
        if (this.charInLine != 0) {
            this.out.consume(" ");
            ++this.charInLine;
        }
    }

    private void emit(String s) {
        int n;
        this.out.consume(s);
        int i = n = s.length();
        while (--i >= 0) {
            char ch = s.charAt(i);
            if (ch != '\r' && ch != '\n') continue;
            this.charInLine = n - i;
            break;
        }
        this.charInLine += n;
    }
}

