/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetProducer {
    private static final int DEFAULT_MAX_WIDTH = 80;
    private static final int DEFAULT_TAB_WIDTH = 8;
    private final Map<InputSource, ? extends CharSequence> originalSource;
    protected final MessageContext mc;
    protected final int maxWidth;
    protected final int tabWidth;

    public SnippetProducer(Map<InputSource, ? extends CharSequence> originalSource, MessageContext mc) {
        this(originalSource, mc, 80, 8);
    }

    public SnippetProducer(Map<InputSource, ? extends CharSequence> originalSource, MessageContext mc, int maxWidth) {
        this(originalSource, mc, maxWidth, 8);
    }

    public SnippetProducer(Map<InputSource, ? extends CharSequence> originalSource, MessageContext mc, int maxWidth, int tabWidth) {
        this.originalSource = originalSource;
        this.mc = mc;
        this.maxWidth = maxWidth;
        this.tabWidth = tabWidth;
    }

    public final String getSnippet(Message msg) {
        StringBuilder snippet = new StringBuilder();
        for (MessagePart mp : msg.getMessageParts()) {
            if (!(mp instanceof FilePosition)) continue;
            FilePosition pos = (FilePosition)mp;
            int len = snippet.length();
            if (len != 0) {
                snippet.append('\n');
            }
            int snippetStart = snippet.length();
            try {
                this.appendSnippet(pos, snippet);
            }
            catch (IOException ex) {
                throw new RuntimeException("StringBuilders shouldn't throw IOExceptions", ex);
            }
            if (snippet.length() != snippetStart) continue;
            snippet.setLength(len);
        }
        return snippet.toString();
    }

    public final void appendSnippet(FilePosition pos, Appendable out) throws IOException {
        InputSource src = pos.source();
        CharSequence sourceCode = this.originalSource.get(src);
        if (sourceCode == null) {
            return;
        }
        int lineNo = pos.startLineNo();
        int start = pos.startCharInLine() - 1;
        CharSequence line = SnippetProducer.fetchLine(sourceCode, lineNo);
        if (line != null && (line.length() == 0 || SnippetProducer.isLinebreak(line.charAt(0))) && lineNo + 1 <= pos.endLineNo()) {
            start = 0;
            line = SnippetProducer.fetchLine(sourceCode, ++lineNo);
        }
        if (line == null) {
            return;
        }
        start = Math.min(line.length(), start);
        int end = Math.max(Math.min(pos.endLineNo() == lineNo ? pos.endCharInLine() - 1 : Integer.MAX_VALUE, line.length()), start);
        if (0 < this.maxWidth && this.maxWidth < line.length()) {
            end = Math.min(end, start + this.maxWidth);
            int left = Math.max(0, end - this.maxWidth);
            int right = Math.min(line.length(), left + this.maxWidth);
            line = line.subSequence(left, right);
            start -= left;
            end -= left;
        }
        this.formatSnippet(FilePosition.instance(src, lineNo, 1, line.length() + 1), line, start, end, out);
    }

    protected void formatSnippet(FilePosition pos, CharSequence line, int start, int end, Appendable out) throws IOException {
        StringBuilder posBuf = new StringBuilder();
        this.formatFilePosition(pos, posBuf);
        posBuf.append(": ");
        int filePosLength = posBuf.length();
        int nSpaces = start + filePosLength;
        int nCarets = end - start;
        out.append(posBuf);
        int nExtraSpaces = this.expandTabs(line, 0, start, 0, out);
        int nExtraCarets = this.expandTabs(line, start, end, nExtraSpaces, out);
        this.expandTabs(line, end, line.length(), nExtraSpaces + nExtraCarets, out);
        if (line.length() == 0 || !SnippetProducer.isLinebreak(line.charAt(line.length() - 1))) {
            out.append("\n");
        }
        SnippetProducer.repeat("                ", nSpaces + nExtraSpaces, out);
        SnippetProducer.repeat("^^^^^^^^^^^^^^^^", Math.max(nCarets + nExtraCarets, 1), out);
    }

    protected void formatFilePosition(FilePosition pos, Appendable out) throws IOException {
        pos.source().format(this.mc, out);
        out.append(":");
        out.append(String.valueOf(pos.startLineNo()));
    }

    private static void repeat(String pattern, int count, Appendable out) throws IOException {
        while (count >= pattern.length()) {
            out.append(pattern);
            count -= pattern.length();
        }
        if (count > 0) {
            out.append(pattern, 0, count);
        }
    }

    private static CharSequence fetchLine(CharSequence seq, int lineNo) {
        int pos = 0;
        int i = lineNo;
        while (--i >= 1) {
            pos = SnippetProducer.posPastNextLinebreak(seq, pos);
        }
        int start = pos;
        int end = SnippetProducer.posPastNextLinebreak(seq, pos);
        if (start < end) {
            return seq.subSequence(start, end);
        }
        return null;
    }

    private static int indexOf(CharSequence seq, char ch, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            if (seq.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    private int expandTabs(CharSequence seq, int start, int end, int nExpanded, Appendable out) throws IOException {
        String SPACES = "        ";
        int tabIdx = SnippetProducer.indexOf(seq, '\t', start, end);
        if (tabIdx < 0) {
            out.append(seq, start, end);
            return 0;
        }
        int nExtra = 0;
        int done = start;
        do {
            int nSpaces;
            out.append(seq, done, tabIdx);
            int nBefore = nExtra + tabIdx + nExpanded;
            nExtra += nSpaces - 1;
            for (nSpaces = this.tabWidth - nBefore % this.tabWidth; nSpaces >= "        ".length(); nSpaces -= "        ".length()) {
                out.append("        ");
            }
            out.append("        ", 0, nSpaces);
        } while ((tabIdx = SnippetProducer.indexOf(seq, '\t', done = tabIdx + 1, end)) >= 0);
        out.append(seq, done, end);
        return nExtra;
    }

    private static int posPastNextLinebreak(CharSequence seq, int pos) {
        int len = seq.length();
        while (pos < len) {
            char ch = seq.charAt(pos);
            if (ch == '\n') {
                return pos + 1;
            }
            if (ch == '\r') {
                return pos + (pos + 1 < len && '\n' == seq.charAt(pos + 1) ? 2 : 1);
            }
            ++pos;
        }
        return len;
    }

    private static boolean isLinebreak(char ch) {
        return ch == '\r' || ch == '\n';
    }
}

