/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Abbreviator {
    private final Map<String, String> itemToAbbrev = new HashMap<String, String>();
    private final String sep;

    public Abbreviator(Set<String> items, String sep) {
        this.sep = sep;
        HashMap<String, String> abbrevToUri = new HashMap<String, String>();
        for (String string : items) {
            this.insert(abbrevToUri, string, "");
        }
        for (Map.Entry entry : abbrevToUri.entrySet()) {
            if (entry.getValue() == null) continue;
            this.itemToAbbrev.put((String)entry.getValue(), (String)entry.getKey());
        }
    }

    public String unambiguousAbbreviationFor(String item) {
        String abbrev = this.itemToAbbrev.get(item);
        return abbrev != null ? abbrev : item;
    }

    private void insert(Map<String, String> abbrevToUri, String item, String abbrev) {
        if (!abbrevToUri.containsKey(abbrev = this.expand(item, abbrev))) {
            abbrevToUri.put(abbrev, item);
        } else {
            String other = abbrevToUri.get(abbrev);
            if (!item.equals(other)) {
                if (!abbrev.equals(other)) {
                    abbrevToUri.put(abbrev, null);
                    if (other != null) {
                        this.insert(abbrevToUri, other, abbrev);
                    }
                }
                this.insert(abbrevToUri, item, abbrev);
            }
        }
    }

    private String expand(String item, String abbrev) {
        int seplen = this.sep.length();
        int suffixStart = item.length() - (abbrev.length() + 1);
        int slash = item.lastIndexOf(this.sep, suffixStart - seplen);
        return slash >= 0 ? item.substring(slash + seplen) : item;
    }
}

