/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sets {
    public static <E> Set<E> newHashSet() {
        return new HashSet();
    }

    public static <E> Set<E> newHashSet(Collection<? extends E> els) {
        return new HashSet<E>(els);
    }

    public static <E> Set<E> newHashSet(Iterable<? extends E> els) {
        HashSet<E> s = new HashSet<E>();
        for (E el : els) {
            s.add(el);
        }
        return s;
    }

    public static <E> Set<E> newHashSet(E ... els) {
        HashSet<E> s = new HashSet<E>(els.length);
        for (E el : els) {
            s.add(el);
        }
        return s;
    }

    public static <E> Set<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <E> Set<E> newLinkedHashSet(Collection<? extends E> els) {
        return new LinkedHashSet<E>(els);
    }

    public static <E> Set<E> newLinkedHashSet(Iterable<? extends E> els) {
        LinkedHashSet<E> s = new LinkedHashSet<E>();
        for (E el : els) {
            s.add(el);
        }
        return s;
    }

    public static <E> Set<E> newLinkedHashSet(E ... els) {
        LinkedHashSet<E> s = new LinkedHashSet<E>(els.length);
        for (E el : els) {
            s.add(el);
        }
        return s;
    }

    public static <E> Set<E> newIdentityHashSet() {
        return new LinkedHashSet();
    }

    public static <E> Set<E> newIdentityHashSet(Set<? extends E> set) {
        return new LinkedHashSet<E>(set);
    }

    public static <E extends Comparable<? super E>> SortedSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static <E extends Comparable<? super E>> SortedSet<E> newTreeSet(Collection<? extends E> els) {
        return new TreeSet<E>(els);
    }

    public static <E extends Comparable<? super E>> SortedSet<E> newTreeSet(Iterable<? extends E> els) {
        TreeSet<Comparable> s = new TreeSet<Comparable>();
        for (Comparable el : els) {
            s.add(el);
        }
        return s;
    }

    public static <E extends Comparable<? super E>> Set<E> newTreeSet(E ... els) {
        TreeSet<E> s = new TreeSet<E>();
        for (E el : els) {
            s.add(el);
        }
        return s;
    }

    public static <E> SortedSet<E> newTreeSet(Comparator<? super E> cmp) {
        return new TreeSet<E>(cmp);
    }

    public static <E> SortedSet<E> newTreeSet(Comparator<? super E> cmp, Collection<? extends E> els) {
        TreeSet<? extends E> s = new TreeSet<E>(cmp);
        s.addAll(els);
        return s;
    }

    public static <E> SortedSet<E> newTreeSet(Comparator<? super E> cmp, Iterable<? extends E> els) {
        TreeSet<E> s = new TreeSet<E>(cmp);
        for (E el : els) {
            s.add(el);
        }
        return s;
    }

    public static <E extends Comparable<E>> Set<E> newTreeSet(Comparator<? super E> cmp, E ... els) {
        TreeSet<E> s = new TreeSet<E>(cmp);
        for (E el : els) {
            s.add(el);
        }
        return s;
    }

    public static <E> Set<E> immutableSet(E ... elements) {
        return Collections.unmodifiableSet(Sets.newLinkedHashSet(elements));
    }

    public static <E> Set<E> immutableSet(Iterable<E> elements) {
        return Collections.unmodifiableSet(Sets.newLinkedHashSet(elements));
    }

    public static <E extends Comparable<E>> Set<E> immutableSortedSet(E ... elements) {
        return Collections.unmodifiableSet(Sets.newTreeSet(elements));
    }

    public static <E extends Comparable<E>> Set<E> immutableSortedSet(Iterable<E> elements) {
        return Collections.unmodifiableSet(Sets.newTreeSet(elements));
    }

    public static <T> Set<T> union(Collection<? extends T> a, Collection<? extends T> b) {
        Set<T> u = Sets.newLinkedHashSet(a);
        u.addAll(b);
        return u;
    }

    public static <T> Set<T> intersection(Collection<? extends T> a, Collection<? extends T> b) {
        if (b.size() > a.size()) {
            Collection<T> t = a;
            a = b;
            b = t;
        }
        Set<T> i = Sets.newLinkedHashSet(b);
        i.retainAll(a);
        return i;
    }

    public static <T> Set<T> difference(Collection<? extends T> pos, Collection<? extends T> neg) {
        Set<T> d = Sets.newLinkedHashSet(pos);
        d.removeAll(neg);
        return d;
    }

    private Sets() {
    }
}

