/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.expression;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.Expression;

public class IteratorExpression
implements Expression {
    private Expression expression;

    public IteratorExpression(Expression expression) {
        this.expression = expression;
    }

    public Object evaluate(Context context) {
        Class<?> type;
        Object value = this.expression.evaluate(context);
        if (value instanceof Iterator) {
            return (Iterator)value;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.iterator();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.entrySet().iterator();
        }
        if (value instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)value);
        }
        if (value != null && (type = value.getClass()).isArray()) {
            return new ArrayIterator(value);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public void update(Context context, String newValue) {
    }

    public String toString() {
        return "IteratorExpression [expression=" + this.expression + "]";
    }

    private static final class EnumerationIterator
    implements Iterator {
        private Collection collection;
        private Enumeration enumeration;
        private Object last;

        public EnumerationIterator() {
            this(null, null);
        }

        public EnumerationIterator(Enumeration enumeration) {
            this(enumeration, null);
        }

        public EnumerationIterator(Enumeration enumeration, Collection collection) {
            this.enumeration = enumeration;
            this.collection = collection;
            this.last = null;
        }

        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        public Object next() {
            this.last = this.enumeration.nextElement();
            return this.last;
        }

        public void remove() {
            if (this.collection != null) {
                if (this.last == null) {
                    throw new IllegalStateException("next() must have been called for remove() to function");
                }
            } else {
                throw new UnsupportedOperationException("No Collection associated with this Iterator");
            }
            this.collection.remove(this.last);
        }

        public Enumeration getEnumeration() {
            return this.enumeration;
        }

        public void setEnumeration(Enumeration enumeration) {
            this.enumeration = enumeration;
        }
    }

    private static final class ArrayIterator
    implements Iterator {
        protected Object array;
        protected int startIndex = 0;
        protected int endIndex = 0;
        protected int index = 0;

        public ArrayIterator() {
        }

        public ArrayIterator(Object array) {
            this.setArray(array);
        }

        public ArrayIterator(Object array, int startIndex) {
            this.setArray(array);
            this.checkBound(startIndex, "start");
            this.startIndex = startIndex;
            this.index = startIndex;
        }

        public ArrayIterator(Object array, int startIndex, int endIndex) {
            this.setArray(array);
            this.checkBound(startIndex, "start");
            this.checkBound(endIndex, "end");
            if (endIndex < startIndex) {
                throw new IllegalArgumentException("End index must not be less than start index.");
            }
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.index = startIndex;
        }

        protected void checkBound(int bound, String type) {
            if (bound > this.endIndex) {
                throw new ArrayIndexOutOfBoundsException("Attempt to make an ArrayIterator that " + type + "s beyond the end of the array. ");
            }
            if (bound < 0) {
                throw new ArrayIndexOutOfBoundsException("Attempt to make an ArrayIterator that " + type + "s before the start of the array. ");
            }
        }

        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return Array.get(this.array, this.index++);
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() method is not supported");
        }

        public Object getArray() {
            return this.array;
        }

        public void setArray(Object array) {
            this.endIndex = Array.getLength(array);
            this.startIndex = 0;
            this.array = array;
            this.index = 0;
        }

        public void reset() {
            this.index = this.startIndex;
        }
    }
}

