/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.ancillary.opt.ConstantPooler;
import com.google.caja.ancillary.opt.Fact;
import com.google.caja.ancillary.opt.LocalVarRenamer;
import com.google.caja.ancillary.opt.ParseTreeKB;
import com.google.caja.ancillary.opt.StatementSimplifier;
import com.google.caja.ancillary.opt.VarCollector;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;

public class JsOptimizer {
    private final List<Statement> compUnits = Lists.newArrayList();
    private ParseTreeKB optimizer;
    private boolean rename;
    private final MessageQueue mq;

    public JsOptimizer(MessageQueue mq) {
        this.mq = mq;
    }

    public JsOptimizer addInput(Statement stmt) {
        this.compUnits.add(stmt);
        return this;
    }

    public JsOptimizer setEnvJson(ObjectConstructor envJson) {
        if (this.optimizer == null) {
            this.optimizer = new ParseTreeKB();
        }
        List<? extends Expression> parts = envJson.children();
        int n = parts.size();
        for (int i = 0; i < n; i += 2) {
            StringLiteral sl = (StringLiteral)parts.get(i);
            Literal value = (Literal)parts.get(i + 1).fold();
            String rawExpr = sl.getValue();
            rawExpr = " " + rawExpr.substring(1, rawExpr.length() - 1) + " ";
            CharProducer valueCp = CharProducer.Factory.fromJsString(CharProducer.Factory.fromString((CharSequence)rawExpr, sl.getFilePosition()));
            try {
                Expression expr = JsOptimizer.parser(valueCp, this.mq).parseExpression(true);
                this.optimizer.addFact(expr, Fact.is(value));
                continue;
            }
            catch (ParseException ex) {
                ex.toMessageQueue(this.mq);
            }
        }
        return this;
    }

    public JsOptimizer setRename(boolean rename) {
        this.rename = rename;
        return this;
    }

    public Statement optimize() {
        SimpleMessageQueue optMq = new SimpleMessageQueue();
        Block block = new Block(FilePosition.UNKNOWN, this.compUnits);
        VarCollector.optimize(block);
        if (this.optimizer != null) {
            block = this.optimizer.optimize(block, optMq);
        }
        if (this.rename) {
            block = ConstantPooler.optimize(block);
            block = new LocalVarRenamer(optMq).optimize(block);
        }
        return (Statement)StatementSimplifier.optimize(block, this.mq);
    }

    private static Parser parser(CharProducer cp, MessageQueue errs) {
        JsLexer lexer = new JsLexer(cp);
        JsTokenQueue tq = new JsTokenQueue(lexer, cp.getCurrentPosition().source());
        return new Parser(tq, errs);
    }

    public static void main(String ... args) throws IOException {
        SimpleMessageQueue mq = new SimpleMessageQueue();
        MessageContext mc = new MessageContext();
        JsOptimizer opt = new JsOptimizer(mq);
        opt.setRename(true);
        try {
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                String arg = args[i];
                if ("--norename".equals(arg)) {
                    opt.setRename(false);
                    continue;
                }
                if (arg.startsWith("--envjson=")) {
                    String jsonfile = arg.substring(arg.indexOf(61) + 1);
                    opt.setEnvJson((ObjectConstructor)JsOptimizer.jsExpr(JsOptimizer.fromFile(jsonfile), mq));
                    continue;
                }
                if ("--".equals(arg)) {
                    ++i;
                }
                while (i < n) {
                    CharProducer cp = JsOptimizer.fromFile(args[i]);
                    mc.addInputSource(cp.getCurrentPosition().source());
                    opt.addInput(JsOptimizer.js(cp, mq));
                    ++i;
                }
            }
        }
        catch (ParseException ex) {
            ex.toMessageQueue(mq);
        }
        Statement out = opt.optimize();
        for (Message msg : mq.getMessages()) {
            msg.format(mc, System.err);
            System.err.println();
        }
        JsMinimalPrinter printer = new JsMinimalPrinter(new Concatenator(System.out, null));
        RenderContext rc = new RenderContext(printer).withRawObjKeys(true);
        if (out instanceof Block) {
            ((Block)out).renderBody(rc);
        } else {
            out.render(rc);
        }
        printer.noMoreTokens();
    }

    private static Block js(CharProducer cp, MessageQueue mq) throws ParseException {
        return JsOptimizer.jsParser(cp, mq).parse();
    }

    private static Expression jsExpr(CharProducer cp, MessageQueue mq) throws ParseException {
        Parser p = JsOptimizer.jsParser(cp, mq);
        Expression e = p.parseExpression(true);
        p.getTokenQueue().expectEmpty();
        return e;
    }

    private static Parser jsParser(CharProducer cp, MessageQueue mq) {
        JsLexer lexer = new JsLexer(cp, false);
        JsTokenQueue tq = new JsTokenQueue(lexer, cp.getCurrentPosition().source());
        tq.setInputRange(cp.filePositionForOffsets(cp.getOffset(), cp.getLimit()));
        return new Parser(tq, mq);
    }

    private static CharProducer fromFile(String path) throws IOException {
        File f = new File(path);
        return CharProducer.Factory.create((Reader)new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"), new InputSource(f.toURI()));
    }
}

