/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.Token;
import com.google.caja.parser.html.AttrStub;
import com.google.caja.parser.html.AttributesImpl;
import com.google.caja.parser.html.CajaTreeBuilder;
import com.google.caja.parser.html.DomParserMessageType;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.html.OpenElementStack;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import com.google.caja.util.Strings;
import java.util.List;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.impl.TokenHandler;
import nu.validator.htmlparser.impl.Tokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Html5ElementStack
implements OpenElementStack {
    private final CajaTreeBuilder builder;
    private final char[] charBuf = new char[1024];
    private final MessageQueue mq;
    private final Document doc;
    private final boolean needsDebugData;
    private boolean isFragment;
    private boolean needsNamespaceFixup;
    private boolean topLevelHtmlFromInput = false;
    private boolean processingFirstTag = true;

    Html5ElementStack(Document doc, boolean needsDebugData, MessageQueue queue) {
        this.doc = doc;
        this.needsDebugData = needsDebugData;
        this.mq = queue;
        this.builder = new CajaTreeBuilder(doc, needsDebugData, this.mq);
    }

    @Override
    public final Document getDocument() {
        return this.doc;
    }

    @Override
    public boolean needsNamespaceFixup() {
        return this.needsNamespaceFixup;
    }

    @Override
    public void open(boolean isFragment) {
        this.isFragment = isFragment;
        this.builder.setDoctypeExpectation(DoctypeExpectation.NO_DOCTYPE_ERRORS);
        try {
            this.builder.start(new Tokenizer((TokenHandler)this.builder));
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
        this.builder.setErrorHandler(new ErrorHandler(){
            private FilePosition lastPos;
            private String lastMessage;

            public void error(SAXParseException ex) {
                this.report(MessageLevel.LINT, ex);
            }

            public void fatalError(SAXParseException ex) {
                this.report(MessageLevel.FATAL_ERROR, ex);
            }

            public void warning(SAXParseException ex) {
                this.report(MessageLevel.LINT, ex);
            }

            private void report(MessageLevel level, SAXParseException ex) {
                String message = this.errorMessage(ex);
                FilePosition pos = Html5ElementStack.this.builder.getErrorLocation();
                if (message.equals(this.lastMessage) && pos.equals(this.lastPos)) {
                    return;
                }
                this.lastMessage = message;
                this.lastPos = pos;
                Html5ElementStack.this.mq.getMessages().add(new Message((MessageTypeInt)DomParserMessageType.GENERIC_SAX_ERROR, level, pos, MessagePart.Factory.valueOf(message)));
            }

            private String errorMessage(SAXParseException ex) {
                return ex.getMessage().replace('\u201c', '\'').replace('\u201d', '\'');
            }
        });
    }

    @Override
    public void finish(FilePosition endOfFile) {
        this.builder.finish(endOfFile);
        this.builder.closeUnclosedNodes();
    }

    public static String canonicalizeName(String name) {
        if (name.indexOf(58) >= 0) {
            return name;
        }
        return Strings.toLowerCase(name);
    }

    static String canonicalElementName(String elementName) {
        return Html5ElementStack.canonicalizeName(elementName);
    }

    static String canonicalAttributeName(String attributeName) {
        return Html5ElementStack.canonicalizeName(attributeName);
    }

    @Override
    public DocumentFragment getRootElement() {
        String tagName;
        Element root = this.builder.getRootElement();
        DocumentFragment result = this.doc.createDocumentFragment();
        if (this.needsDebugData) {
            Nodes.setFilePositionFor(result, this.builder.getFragmentBounds());
        }
        Node first = root.getFirstChild();
        if (!this.isFragment || this.topLevelHtmlFromInput) {
            result.appendChild(root);
            return result;
        }
        boolean tagsBesidesHeadBodyFrameset = false;
        boolean topLevelTagsWithAttributes = Html5ElementStack.hasSpecifiedAttributes(root);
        for (Node child = first; child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element el = (Element)child;
            tagName = el.getTagName();
            if (!("head".equals(tagName) || "body".equals(tagName) || "frameset".equals(tagName))) {
                tagsBesidesHeadBodyFrameset = true;
                break;
            }
            if (topLevelTagsWithAttributes || !Html5ElementStack.hasSpecifiedAttributes(el) || "frameset".equals(tagName)) continue;
            topLevelTagsWithAttributes = true;
        }
        if (tagsBesidesHeadBodyFrameset || topLevelTagsWithAttributes) {
            result.appendChild(root);
            return result;
        }
        Node pending = null;
        for (Node child = first; child != null; child = child.getNextSibling()) {
            if (child instanceof Element) {
                tagName = ((Element)child).getTagName();
                if ("head".equals(tagName) || "body".equals(tagName)) {
                    for (Node grandchild = child.getFirstChild(); grandchild != null; grandchild = grandchild.getNextSibling()) {
                        pending = this.appendNormalized(pending, grandchild, result);
                    }
                    continue;
                }
                pending = child;
                continue;
            }
            pending = this.appendNormalized(pending, child, result);
        }
        if (pending != null) {
            result.appendChild(pending);
        }
        return result;
    }

    private static boolean hasSpecifiedAttributes(Element el) {
        NamedNodeMap attrs = el.getAttributes();
        int n = attrs.getLength();
        for (int i = 0; i < n; ++i) {
            Attr a = (Attr)attrs.item(i);
            if (!el.hasAttributeNS(a.getNamespaceURI(), a.getLocalName())) continue;
            return true;
        }
        return false;
    }

    private Node appendNormalized(Node pending, Node current, DocumentFragment parent) {
        if (pending == null) {
            return current;
        }
        if (pending.getNodeType() != 3 || current.getNodeType() != 3) {
            parent.appendChild(pending);
            return current;
        }
        Text a = (Text)pending;
        Text b = (Text)current;
        Text combined = this.doc.createTextNode(a.getTextContent() + b.getTextContent());
        if (this.needsDebugData) {
            Nodes.setFilePositionFor(combined, FilePosition.span(Nodes.getFilePositionFor(a), Nodes.getFilePositionFor(b)));
            Nodes.setRawText(combined, Nodes.getRawText(a) + Nodes.getRawText(b));
        }
        return combined;
    }

    @Override
    public void processTag(Token<HtmlTokenType> start, Token<HtmlTokenType> end, List<AttrStub> attrStubs) {
        this.builder.setTokenContext(start, end);
        try {
            AttributesImpl attrImpl;
            boolean isEndTag = CajaTreeBuilder.isEndTag(start.text);
            String tagName = start.text.substring(isEndTag ? 2 : 1);
            boolean isHtml = this.checkName(tagName);
            if (this.processingFirstTag && Strings.equalsIgnoreCase("html", tagName)) {
                this.topLevelHtmlFromInput = true;
            }
            this.processingFirstTag = false;
            if (isHtml) {
                tagName = Strings.toLowerCase(tagName);
            }
            tagName = tagName.intern();
            if (!attrStubs.isEmpty()) {
                List<Attr> attrs = Lists.newArrayList();
                for (AttrStub as : attrStubs) {
                    String qname = as.nameTok.text;
                    try {
                        Attr attrNode;
                        boolean isAttrHtml;
                        if ("xmlns".equals(qname)) {
                            if (Namespaces.HTML_NAMESPACE_URI.equals(as.value)) continue;
                            this.mq.addMessage((MessageTypeInt)MessageType.CANNOT_OVERRIDE_DEFAULT_NAMESPACE_IN_HTML, as.nameTok.pos);
                            continue;
                        }
                        boolean bl = isAttrHtml = isHtml && this.checkName(qname);
                        if (isAttrHtml) {
                            qname = Strings.toLowerCase(qname);
                            attrNode = this.doc.createAttributeNS(Namespaces.HTML_NAMESPACE_URI, qname);
                        } else {
                            attrNode = this.doc.createAttribute(qname);
                        }
                        attrNode.setValue(as.value);
                        if (this.needsDebugData) {
                            Nodes.setFilePositionFor(attrNode, as.nameTok.pos);
                            Nodes.setFilePositionForValue(attrNode, as.valueTok.pos);
                            Nodes.setRawValue(attrNode, as.valueTok.text);
                        }
                        attrs.add(attrNode);
                    }
                    catch (DOMException ex) {
                        ex.printStackTrace();
                        this.mq.addMessage((MessageTypeInt)MessageType.INVALID_IDENTIFIER, as.nameTok.pos, MessagePart.Factory.valueOf(as.nameTok.text));
                    }
                }
                attrImpl = new AttributesImpl(attrs);
            } else {
                attrImpl = AttributesImpl.NONE;
            }
            if (isEndTag) {
                this.builder.endTag(tagName, attrImpl);
            } else {
                this.builder.startTag(tagName, attrImpl);
            }
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void processComment(Token<HtmlTokenType> commentToken) {
        char[] chars;
        String text = commentToken.text.substring("<!--".length(), commentToken.text.lastIndexOf("--"));
        commentToken = Token.instance(text, commentToken.type, commentToken.pos);
        int n = text.length();
        if (n <= this.charBuf.length) {
            chars = this.charBuf;
            text.getChars(0, n, chars, 0);
        } else {
            chars = text.toCharArray();
        }
        this.builder.setTokenContext(commentToken, commentToken);
        try {
            this.builder.comment(chars, n);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean checkName(String qname) {
        if (qname.indexOf(58, 1) < 0) {
            return true;
        }
        this.needsNamespaceFixup = true;
        return false;
    }

    @Override
    public void processText(Token<HtmlTokenType> textToken) {
        char[] chars;
        int n;
        String text = textToken.text.replaceAll("\r\n?", "\n");
        if (!text.equals(textToken.text)) {
            textToken = Token.instance(text, textToken.type, textToken.pos);
        }
        if ((n = text.length()) <= this.charBuf.length) {
            chars = this.charBuf;
            text.getChars(0, n, chars, 0);
        } else {
            chars = text.toCharArray();
        }
        this.builder.setTokenContext(textToken, textToken);
        try {
            this.builder.characters(chars, 0, n);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
    }
}

