/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.RulesetDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;

@RulesetDescription(name="IlegalReferenceCheckRewriter", synopsis="Checks that any reserved references are synthetic")
public class IllegalReferenceCheckRewriter
extends Rewriter {
    public final Rule[] cajaRules = new Rule[]{new Rule(){

        @RuleDescription(name="identifierUnderscores", synopsis="Check that any identifier ending with '__' is synthetic", reason="Double underscore identifiers may not be mentioned by Caja code")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            String name;
            if (node instanceof Identifier && !node.getAttributes().is(SyntheticNodes.SYNTHETIC) && (name = ((Identifier)node).getValue()) != null && name.endsWith("__")) {
                IllegalReferenceCheckRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.ILLEGAL_IDENTIFIER_LEFT_OVER, node.getFilePosition(), node);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="recurse", synopsis="Recurse into children", reason="")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.expandAll(node, scope);
        }
    }};

    public IllegalReferenceCheckRewriter(MessageQueue mq) {
        this(mq, true);
    }

    public IllegalReferenceCheckRewriter(MessageQueue mq, boolean logging) {
        super(mq, false, logging);
        this.addRules(this.cajaRules);
    }
}

