/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageTypeInt;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Message
implements Serializable {
    private MessageTypeInt type;
    private MessageLevel level;
    private MessagePart[] parts;

    public Message(MessageTypeInt type, MessagePart ... parts) {
        this(type, type.getLevel(), parts);
    }

    public Message(MessageTypeInt type, MessageLevel level, MessagePart ... parts) {
        this.type = type;
        this.level = level;
        this.parts = new MessagePart[parts.length];
        if (null == type) {
            throw new NullPointerException();
        }
        if (null == level) {
            throw new NullPointerException();
        }
        if (parts.length != type.getParamCount()) {
            throw new IllegalArgumentException(parts.length + " != " + type.getParamCount());
        }
        int i = parts.length;
        while (--i >= 0) {
            MessagePart p = parts[i];
            if (null == p) {
                throw new NullPointerException(String.valueOf(i));
            }
            this.parts[i] = p;
        }
    }

    public MessageTypeInt getMessageType() {
        return this.type;
    }

    public MessageLevel getMessageLevel() {
        return this.level;
    }

    public List<MessagePart> getMessageParts() {
        return Collections.unmodifiableList(Arrays.asList(this.parts));
    }

    public String toString() {
        return this.format(new MessageContext());
    }

    public String format(MessageContext context) {
        try {
            StringBuilder sb = new StringBuilder();
            this.format(context, sb);
            return sb.toString();
        }
        catch (IOException ex) {
            AssertionError e = new AssertionError((Object)"IOException writing to StringBuilder");
            ((Throwable)((Object)e)).initCause(ex);
            throw e;
        }
    }

    public void format(MessageContext context, Appendable out) throws IOException {
        this.type.format(this.parts, context, out);
    }
}

