/*
 * (C) Copyright 2011 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Stéphane Fourrier
 */

package org.nuxeo.opensocial.container.client.event.priv.app.portlet;

import org.nuxeo.opensocial.container.client.ui.api.HasId;

import com.google.gwt.event.shared.GwtEvent;

/**
 * @author Stéphane Fourrier
 */
public class CollapsePortletEvent extends GwtEvent<CollapsePortletEventHandler> implements HasId {
    public static Type<CollapsePortletEventHandler> TYPE = new Type<CollapsePortletEventHandler>();

    private String webContentId;

    public CollapsePortletEvent() {
    }

    public CollapsePortletEvent(String webContentId) {
        this.webContentId = webContentId;
    }

    public String getId() {
        return webContentId;
    }

    public void setId(String id) {
        this.webContentId = id;
    }

    @Override
    public Type<CollapsePortletEventHandler> getAssociatedType() {
        return TYPE;
    }

    @Override
    protected void dispatch(CollapsePortletEventHandler handler) {
        handler.onCollapsePortlet(this);
    }
}
