/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.ContentType;
import com.google.caja.ancillary.servlet.Glob;
import com.google.caja.ancillary.servlet.Input;
import com.google.caja.ancillary.servlet.Request;
import com.google.caja.ancillary.servlet.Resources;
import com.google.caja.ancillary.servlet.Verb;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.HtmlQuasiBuilder;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.util.Join;
import com.google.caja.util.Lists;
import com.google.caja.util.Sets;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

final class IndexPage {
    private static final String INDEX_PAGE_TEMPLATE = Resources.readRequired(IndexPage.class, "index.quasi.html").toString();
    static final String DEFAULT_SOURCE_INPUT = "<script></script>";

    IndexPage() {
    }

    static DocumentFragment render(Request req) {
        Document doc = DomParser.makeDocument(null, null);
        HtmlQuasiBuilder b = HtmlQuasiBuilder.getBuilder(doc);
        DocumentFragment inputsF = doc.createDocumentFragment();
        List<Input> inputs = Lists.newArrayList(req.inputs);
        if (inputs.isEmpty()) {
            inputs.add(new Input(null, null, DEFAULT_SOURCE_INPUT));
        }
        for (Input inp : inputs) {
            inputsF.appendChild(b.substV(Join.join((CharSequence)"\n", "<li>", "<select class=type-select name=it title=Content-Type>", "<option value=''></option>", "<option value=@jsT selected=@isJS>JavaScript</option>", "<option value=@cssT selected=@isCSS>CSS</option>", "<option value=@htmlT selected=@isHTML>HTML</option>", "</select>", "<input type=hidden name=ip value=@file>", "<div class=source-code-cont>", "<textarea name=i class=source-code-input>@code</textarea>", "</div>", "<span class=cursor-pos></span>", "<br clear=all>", "</li>"), "code", inp.code, "file", inp.path != null ? inp.path : "", "it", inp.t != null ? inp.t.mimeType : "", "jsT", ContentType.JS.mimeType, "isJS", inp.t == ContentType.JS, "cssT", ContentType.CSS.mimeType, "isCSS", inp.t == ContentType.CSS, "htmlT", ContentType.HTML.mimeType, "isHTML", inp.t == ContentType.HTML));
        }
        DocumentFragment messageLevels = doc.createDocumentFragment();
        for (MessageLevel lvl : MessageLevel.values()) {
            messageLevels.appendChild(b.substV("<option value=@lvl selected=@selected>@lvl</option>", "lvl", lvl.name(), "selected", req.minLevel == lvl));
        }
        boolean isLint = req.verb == Verb.LINT || req.verb == Verb.INDEX;
        boolean isDoc = req.verb == Verb.DOC;
        boolean isEcho = !isLint && !isDoc;
        DocumentFragment f = doc.createDocumentFragment();
        f.appendChild(b.substV(INDEX_PAGE_TEMPLATE, "inputs", inputsF, "messageLevels", messageLevels, "lint", isLint, "echo", isEcho, "doc", isDoc, "ignores", Join.join((CharSequence)" ", Sets.newTreeSet(req.toIgnore)), "baseUri", req.baseUri.toString(), "minifyTrue", req.minify, "minifyFalse", !req.minify, "asciiOnly", req.asciiOnly, "userAgent", req.userAgent != null ? Glob.regexToGlob(req.userAgent) : "*", "cacheId", req.staticFiles.cacheId));
        return f;
    }
}

