/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FeatureParser {
    FeatureParser() {
    }

    public ParsedFeature parse(Uri parent, String xml) throws GadgetException {
        Element doc;
        try {
            doc = XmlUtil.parse((String)xml);
        }
        catch (XmlException e) {
            throw new GadgetException(GadgetException.Code.MALFORMED_XML_DOCUMENT, (Throwable)e);
        }
        String name = null;
        ArrayList deps = Lists.newArrayList();
        ArrayList bundles = Lists.newArrayList();
        NodeList children = doc.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            if (element.getTagName().equals("name")) {
                name = element.getTextContent();
                continue;
            }
            if (element.getTagName().equals("dependency")) {
                deps.add(element.getTextContent());
                continue;
            }
            String type = element.getTagName().toLowerCase();
            ArrayList resources = Lists.newArrayList();
            NodeList resourceKids = element.getElementsByTagName("script");
            int y = resourceKids.getLength();
            for (int x = 0; x < y; ++x) {
                Element resourceChild = (Element)resourceKids.item(x);
                String src = resourceChild.getAttribute("src");
                String content = resourceChild.getTextContent();
                Map<String, String> attribs = this.getAttribs(resourceChild);
                Uri source = null;
                if (src != null && src.length() > 0) {
                    source = !"false".equals(attribs.get("inline")) ? parent.resolve(FeatureRegistry.getComponentUri(src)) : Uri.parse((String)src);
                }
                resources.add(new ParsedFeature.Resource(source, (String)(src != null && src.length() != 0 ? null : content), this.getAttribs(resourceChild)));
            }
            bundles.add(new ParsedFeature.Bundle(type, this.getAttribs(element), resources));
        }
        return new ParsedFeature(name, deps, bundles);
    }

    private Map<String, String> getAttribs(Element element) {
        HashMap attribs = Maps.newHashMap();
        NamedNodeMap attribNodes = element.getAttributes();
        int y = attribNodes.getLength();
        for (int x = 0; x < y; ++x) {
            Attr attr = (Attr)attribNodes.item(x);
            if (attr.getName().equals("src")) continue;
            attribs.put(attr.getName(), attr.getValue());
        }
        return Collections.unmodifiableMap(attribs);
    }

    static class ParsedFeature {
        private final String name;
        private final List<String> deps;
        private final List<Bundle> bundles;

        private ParsedFeature(String name, List<String> deps, List<Bundle> bundles) {
            this.name = name;
            this.deps = Collections.unmodifiableList(deps);
            this.bundles = Collections.unmodifiableList(bundles);
        }

        public String getName() {
            return this.name;
        }

        public List<String> getDeps() {
            return this.deps;
        }

        public List<Bundle> getBundles() {
            return this.bundles;
        }

        static class Resource {
            private final Uri source;
            private final String content;
            private final Map<String, String> attribs;

            private Resource(Uri source, String content, Map<String, String> attribs) {
                this.source = source;
                this.content = content;
                this.attribs = Collections.unmodifiableMap(attribs);
            }

            public Uri getSource() {
                return this.source;
            }

            public String getContent() {
                return this.content;
            }

            public Map<String, String> getAttribs() {
                return this.attribs;
            }
        }

        public static class Bundle {
            private final String type;
            private final Map<String, String> attribs;
            private final List<Resource> resources;

            private Bundle(String type, Map<String, String> attribs, List<Resource> resources) {
                this.type = type;
                this.attribs = attribs;
                this.resources = resources;
            }

            public String getType() {
                return this.type;
            }

            public Map<String, String> getAttribs() {
                return this.attribs;
            }

            public List<Resource> getResources() {
                return this.resources;
            }
        }
    }
}

