/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;

public class FeatureResourceLoader {
    private static final Logger logger = Logger.getLogger("org.apache.shindig.gadgets");
    private HttpFetcher fetcher;

    @Inject
    public void setHttpFetcher(HttpFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public FeatureResource load(Uri uri, Map<String, String> attribs) throws GadgetException {
        try {
            if ("file".equals(uri.getScheme())) {
                return this.loadFile(uri.getPath(), attribs);
            }
            if ("res".equals(uri.getScheme())) {
                return this.loadResource(uri.getPath(), attribs);
            }
            return this.loadUri(uri, attribs);
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, (Throwable)e);
        }
    }

    protected FeatureResource loadFile(String path, Map<String, String> attribs) throws IOException {
        return new DualModeStaticResource(path, this.getFileContent(new File(this.getOptPath(path))), this.getFileContent(new File(path)));
    }

    protected String getFileContent(File file) {
        try {
            return ResourceLoader.getContent((File)file);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected FeatureResource loadResource(String path, Map<String, String> attribs) throws IOException {
        return new DualModeStaticResource(path, this.getResourceContent(this.getOptPath(path)), this.getResourceContent(path));
    }

    protected String getResourceContent(String resource) {
        try {
            return ResourceLoader.getContent((String)resource);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected FeatureResource loadUri(Uri uri, Map<String, String> attribs) {
        String inline = attribs.get("inline");
        inline = inline != null ? inline : "";
        return new UriResource(this.fetcher, uri, "1".equals(inline) || "true".equalsIgnoreCase(inline));
    }

    protected String getOptPath(String orig) {
        if (orig.endsWith(".js") && !orig.endsWith(".opt.js")) {
            return orig.substring(0, orig.length() - 3) + ".opt.js";
        }
        return orig;
    }

    private static class UriResource
    implements FeatureResource {
        private final HttpFetcher fetcher;
        private final Uri uri;
        private final boolean isInline;
        private String content;
        private long lastLoadTryMs;

        private UriResource(HttpFetcher fetcher, Uri uri, boolean isInline) {
            this.fetcher = fetcher;
            this.uri = uri;
            this.isInline = isInline;
            this.lastLoadTryMs = 0L;
            this.content = this.getContent();
        }

        @Override
        public String getContent() {
            if (this.isExternal()) {
                return this.uri.toString();
            }
            if (this.content != null) {
                return this.content;
            }
            long now = System.currentTimeMillis();
            if (this.fetcher != null && now > this.lastLoadTryMs + 60000L) {
                this.lastLoadTryMs = now;
                try {
                    HttpRequest request = new HttpRequest(this.uri);
                    HttpResponse response = this.fetcher.fetch(request);
                    if (response.getHttpStatusCode() == 200) {
                        this.content = response.getResponseAsString();
                    } else {
                        logger.warning("Unable to retrieve remote library from " + this.uri);
                    }
                }
                catch (GadgetException e) {
                    logger.warning("Unable to retrieve remote library from " + this.uri);
                }
            }
            return this.content;
        }

        @Override
        public String getDebugContent() {
            return this.getContent();
        }

        @Override
        public boolean isExternal() {
            return !this.isInline;
        }

        @Override
        public boolean isProxyCacheable() {
            return this.content != null;
        }
    }

    private static class DualModeStaticResource
    extends FeatureResource.Default {
        private final String content;
        private final String debugContent;

        private DualModeStaticResource(String path, String content, String debugContent) {
            this.content = content != null ? content : debugContent;
            String string = this.debugContent = debugContent != null ? debugContent : content;
            if (this.content == null) {
                throw new IllegalArgumentException("Problems reading resource: " + path);
            }
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public String getDebugContent() {
            return this.debugContent;
        }
    }
}

