/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;

public abstract class ProxyBase {
    public static final String URL_PARAM = "url";
    public static final String REFRESH_PARAM = "refresh";
    public static final String IGNORE_CACHE_PARAM = "nocache";
    public static final String GADGET_PARAM = "gadget";
    public static final String CONTAINER_PARAM = "container";
    public static final String SYND_PARAM = "synd";
    public static final String REWRITE_MIME_TYPE_PARAM = "rewriteMime";
    public static final String SANITIZE_CONTENT_PARAM = "sanitize";
    protected static final Set<String> DISALLOWED_RESPONSE_HEADERS = ImmutableSet.of((Object)"set-cookie", (Object)"content-length", (Object)"content-encoding", (Object)"etag", (Object)"last-modified", (Object)"accept-ranges", (Object[])new String[]{"vary", "expires", "date", "pragma", "cache-control", "transfer-encoding", "www-authenticate"});
    private static final Logger logger = Logger.getLogger(ProxyBase.class.getName());

    protected Uri validateUrl(String urlToValidate) throws GadgetException {
        if (urlToValidate == null) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "url parameter is missing.");
        }
        try {
            UriBuilder url = UriBuilder.parse((String)urlToValidate);
            if (!"http".equals(url.getScheme()) && !"https".equals(url.getScheme())) {
                throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Invalid request url scheme in url: " + Utf8UrlCoder.encode((String)urlToValidate) + "; only \"http\" and \"https\" supported.");
            }
            if (url.getPath() == null || url.getPath().length() == 0) {
                url.setPath("/");
            }
            return url.toUri();
        }
        catch (IllegalArgumentException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "url parameter is not a valid url: " + urlToValidate);
        }
    }

    protected String getParameter(HttpServletRequest request, String name, String defaultValue) {
        String ret = request.getParameter(name);
        return ret == null ? defaultValue : ret;
    }

    protected String getContainer(HttpServletRequest request) {
        String container = this.getParameter(request, CONTAINER_PARAM, null);
        if (container == null) {
            container = this.getParameter(request, SYND_PARAM, "default");
        }
        return container;
    }

    protected void setResponseHeaders(HttpServletRequest request, HttpServletResponse response, HttpResponse results) throws GadgetException {
        int refreshInterval = 0;
        if (results.isStrictNoCache() || "1".equals(request.getParameter(IGNORE_CACHE_PARAM))) {
            refreshInterval = 0;
        } else if (request.getParameter(REFRESH_PARAM) != null) {
            try {
                refreshInterval = Integer.valueOf(request.getParameter(REFRESH_PARAM));
            }
            catch (NumberFormatException nfe) {
                throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "refresh parameter is not a number");
            }
        } else {
            refreshInterval = Math.max(3600, (int)(results.getCacheTtl() / 1000L));
        }
        HttpUtil.setCachingHeaders((HttpServletResponse)response, (int)refreshInterval);
        if (!"application/x-shockwave-flash".equalsIgnoreCase(results.getHeader("Content-Type")) && !"application/x-shockwave-flash".equalsIgnoreCase(response.getContentType())) {
            response.setHeader("Content-Disposition", "attachment;filename=p.txt");
        }
        if (results.getHeader("Content-Type") == null) {
            response.setHeader("Content-Type", "application/octet-stream");
        }
    }

    protected void setRequestHeaders(HttpServletRequest servletRequest, HttpRequest req) {
        String xff = servletRequest.getHeader("X-Forwarded-For");
        String remoteAddr = servletRequest.getRemoteAddr();
        if (!StringUtils.isEmpty((String)remoteAddr)) {
            xff = StringUtils.isEmpty((String)xff) ? servletRequest.getRemoteAddr() : servletRequest.getRemoteAddr() + ", " + xff;
            req.setHeader("X-Forwarded-For", xff);
        }
    }

    public final void fetch(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.doFetch(request, response);
        }
        catch (GadgetException e) {
            this.outputError(response, e);
        }
    }

    protected void outputError(HttpServletResponse resp, GadgetException e) throws IOException {
        int responseCode;
        Level level = Level.FINE;
        switch (e.getCode()) {
            case INTERNAL_SERVER_ERROR: {
                responseCode = 500;
                level = Level.WARNING;
                break;
            }
            default: {
                responseCode = 400;
            }
        }
        logger.log(level, "Request failed", e);
        resp.sendError(responseCode, e.getMessage());
    }

    protected abstract void doFetch(HttpServletRequest var1, HttpServletResponse var2) throws GadgetException, IOException;

    protected boolean getIgnoreCache(HttpServletRequest request) {
        String ignoreCache = request.getParameter(IGNORE_CACHE_PARAM);
        if (ignoreCache == null) {
            return false;
        }
        return !ignoreCache.equals("0");
    }
}

