/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates.tags;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.apache.shindig.gadgets.templates.ElementELResolver;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.tags.AbstractTagHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RenderTagHandler
extends AbstractTagHandler {
    public static final String DEFAULT_NAME = "Render";
    public static final String ATTR_CONTENT = "content";

    @Inject
    public RenderTagHandler() {
        super("http://ns.opensocial.org/2008/markup", DEFAULT_NAME);
    }

    @Override
    public void process(Node result, Element tag, TemplateProcessor processor) {
        block7: {
            String content;
            Map<String, Object> myMap;
            block6: {
                myMap = processor.getTemplateContext().getMy();
                if (myMap == null) {
                    return;
                }
                content = tag.getAttribute(ATTR_CONTENT);
                if (!"".equals(content)) break block6;
                Node root = processor.getTemplateContext().getTemplateRoot();
                if (root == null) break block7;
                for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                    result.appendChild(child.cloneNode(true));
                }
                break block7;
            }
            Object value = myMap.get(content);
            if (value instanceof ElementELResolver.ElementWrapper) {
                this.copyChildren((ElementELResolver.ElementWrapper)value, result);
            } else if (value instanceof List) {
                List children = (List)value;
                for (Object probablyAnElement : children) {
                    if (!(probablyAnElement instanceof ElementELResolver.ElementWrapper)) continue;
                    this.copyChildren((ElementELResolver.ElementWrapper)probablyAnElement, result);
                }
            }
        }
    }

    private void copyChildren(ElementELResolver.ElementWrapper fromWrapper, Node to) {
        Element from = fromWrapper.element;
        for (Node child = from.getFirstChild(); child != null; child = child.getNextSibling()) {
            to.appendChild(child.cloneNode(true));
        }
    }
}

