/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.sample.spi;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.model.SortOrder;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Message;
import org.apache.shindig.social.opensocial.model.MessageCollection;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.MessageService;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Singleton
public class JsonDbOpensocialService
implements ActivityService,
PersonService,
AppDataService,
MessageService {
    private static final Comparator<Person> NAME_COMPARATOR = new Comparator<Person>(){

        @Override
        public int compare(Person person, Person person1) {
            String name = person.getName().getFormatted();
            String name1 = person1.getName().getFormatted();
            return name.compareTo(name1);
        }
    };
    private JSONObject db;
    private BeanConverter converter;
    private static final String PEOPLE_TABLE = "people";
    private static final String ACTIVITIES_TABLE = "activities";
    private static final String DATA_TABLE = "data";
    private static final String FRIEND_LINK_TABLE = "friendLinks";
    private static final String MESSAGE_TABLE = "messages";
    private static final String PASSWORDS_TABLE = "passwords";

    @Inject
    public JsonDbOpensocialService(@Named(value="shindig.canonical.json.db") String jsonLocation, @Named(value="shindig.bean.converter.json") BeanConverter converter) throws Exception {
        String content = IOUtils.toString((InputStream)ResourceLoader.openResource((String)jsonLocation), (String)"UTF-8");
        this.db = new JSONObject(content);
        this.converter = converter;
    }

    public JSONObject getDb() {
        return this.db;
    }

    public void setDb(JSONObject db) {
        this.db = db;
    }

    @Override
    public Future<RestfulCollection<Activity>> getActivities(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
        ArrayList result = Lists.newArrayList();
        try {
            Set<String> idSet = this.getIdSet(userIds, groupId, token);
            for (String id : idSet) {
                if (!this.db.getJSONObject(ACTIVITIES_TABLE).has(id)) continue;
                JSONArray activities = this.db.getJSONObject(ACTIVITIES_TABLE).getJSONArray(id);
                for (int i = 0; i < activities.length(); ++i) {
                    JSONObject activity = activities.getJSONObject(i);
                    if (appId == null || !activity.has(Activity.Field.APP_ID.toString())) {
                        result.add(this.filterFields(activity, fields, Activity.class));
                        continue;
                    }
                    if (!activity.get(Activity.Field.APP_ID.toString()).equals(appId)) continue;
                    result.add(this.filterFields(activity, fields, Activity.class));
                }
            }
            return ImmediateFuture.newInstance((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<Activity>> getActivities(UserId userId, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, Set<String> activityIds, SecurityToken token) throws ProtocolException {
        ArrayList result = Lists.newArrayList();
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ACTIVITIES_TABLE).has(user)) {
                JSONArray activities = this.db.getJSONObject(ACTIVITIES_TABLE).getJSONArray(user);
                for (int i = 0; i < activities.length(); ++i) {
                    JSONObject activity = activities.getJSONObject(i);
                    if (!activity.get(Activity.Field.USER_ID.toString()).equals(user) || !activityIds.contains(activity.getString(Activity.Field.ID.toString()))) continue;
                    result.add(this.filterFields(activity, fields, Activity.class));
                }
            }
            return ImmediateFuture.newInstance((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Activity> getActivity(UserId userId, GroupId groupId, String appId, Set<String> fields, String activityId, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ACTIVITIES_TABLE).has(user)) {
                JSONArray activities = this.db.getJSONObject(ACTIVITIES_TABLE).getJSONArray(user);
                for (int i = 0; i < activities.length(); ++i) {
                    JSONObject activity = activities.getJSONObject(i);
                    if (!activity.get(Activity.Field.USER_ID.toString()).equals(user) || !activity.get(Activity.Field.ID.toString()).equals(activityId)) continue;
                    return ImmediateFuture.newInstance((Object)this.filterFields(activity, fields, Activity.class));
                }
            }
            throw new ProtocolException(400, "Activity not found");
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> deleteActivities(UserId userId, GroupId groupId, String appId, Set<String> activityIds, SecurityToken token) throws ProtocolException {
        try {
            JSONArray activities;
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ACTIVITIES_TABLE).has(user) && (activities = this.db.getJSONObject(ACTIVITIES_TABLE).getJSONArray(user)) != null) {
                JSONArray newList = new JSONArray();
                for (int i = 0; i < activities.length(); ++i) {
                    JSONObject activity = activities.getJSONObject(i);
                    if (activityIds.contains(activity.getString(Activity.Field.ID.toString()))) continue;
                    newList.put((Object)activity);
                }
                this.db.getJSONObject(ACTIVITIES_TABLE).put(user, (Object)newList);
            }
            return ImmediateFuture.newInstance(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> createActivity(UserId userId, GroupId groupId, String appId, Set<String> fields, Activity activity, SecurityToken token) throws ProtocolException {
        try {
            JSONArray jsonArray;
            JSONObject jsonObject = this.convertFromActivity(activity, fields);
            if (!jsonObject.has(Activity.Field.ID.toString())) {
                jsonObject.put(Activity.Field.ID.toString(), System.currentTimeMillis());
            }
            if ((jsonArray = this.db.getJSONObject(ACTIVITIES_TABLE).getJSONArray(userId.getUserId(token))) == null) {
                jsonArray = new JSONArray();
                this.db.getJSONObject(ACTIVITIES_TABLE).put(userId.getUserId(token), (Object)jsonArray);
            }
            jsonArray.put((Object)jsonObject);
            return ImmediateFuture.newInstance(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<Person>> getPeople(Set<UserId> userIds, GroupId groupId, CollectionOptions options, Set<String> fields, SecurityToken token) throws ProtocolException {
        List result = Lists.newArrayList();
        try {
            JSONArray people = this.db.getJSONArray(PEOPLE_TABLE);
            Set<String> idSet = this.getIdSet(userIds, groupId, token);
            for (int i = 0; i < people.length(); ++i) {
                JSONObject person = people.getJSONObject(i);
                if (!idSet.contains(person.get(Person.Field.ID.toString()))) continue;
                Person personObj = this.filterFields(person, fields, Person.class);
                Map<String, Object> appData = this.getPersonAppData(person.getString(Person.Field.ID.toString()), fields);
                personObj.setAppData(appData);
                result.add(personObj);
            }
            if (GroupId.Type.self == groupId.getType() && result.isEmpty()) {
                throw new ProtocolException(400, "Person not found");
            }
            if (options.getSortBy().equals(Person.Field.NAME.toString())) {
                Collections.sort(result, NAME_COMPARATOR);
            }
            if (options.getSortOrder() == SortOrder.descending) {
                Collections.reverse(result);
            }
            int totalSize = result.size();
            int last = options.getFirst() + options.getMax();
            result = result.subList(options.getFirst(), Math.min(last, totalSize));
            return ImmediateFuture.newInstance((Object)new RestfulCollection(result, options.getFirst(), totalSize, options.getMax()));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Person> getPerson(UserId id, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            JSONArray people = this.db.getJSONArray(PEOPLE_TABLE);
            for (int i = 0; i < people.length(); ++i) {
                JSONObject person = people.getJSONObject(i);
                if (id == null || !person.get(Person.Field.ID.toString()).equals(id.getUserId(token))) continue;
                Person personObj = this.filterFields(person, fields, Person.class);
                Map<String, Object> appData = this.getPersonAppData(person.getString(Person.Field.ID.toString()), fields);
                personObj.setAppData(appData);
                return ImmediateFuture.newInstance((Object)personObj);
            }
            throw new ProtocolException(400, "Person not found");
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    private Map<String, Object> getPersonAppData(String id, Set<String> fields) {
        try {
            HashMap appData = null;
            JSONObject personData = this.db.getJSONObject(DATA_TABLE).optJSONObject(id);
            if (personData != null) {
                if (fields.contains(Person.Field.APP_DATA.toString())) {
                    appData = Maps.newHashMap();
                    Iterator keys = personData.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        appData.put(key, personData.get(key));
                    }
                } else {
                    String appDataPrefix = Person.Field.APP_DATA.toString() + ".";
                    for (String field : fields) {
                        String appDataField;
                        if (!field.startsWith(appDataPrefix)) continue;
                        if (appData == null) {
                            appData = Maps.newHashMap();
                        }
                        if (!personData.has(appDataField = field.substring(appDataPrefix.length()))) continue;
                        appData.put(appDataField, personData.get(appDataField));
                    }
                }
            }
            return appData;
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<DataCollection> getPersonData(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            HashMap idToData = Maps.newHashMap();
            Set<String> idSet = this.getIdSet(userIds, groupId, token);
            for (String id : idSet) {
                JSONObject personData = !this.db.getJSONObject(DATA_TABLE).has(id) ? new JSONObject() : (!fields.isEmpty() ? new JSONObject(this.db.getJSONObject(DATA_TABLE).getJSONObject(id), fields.toArray(new String[fields.size()])) : this.db.getJSONObject(DATA_TABLE).getJSONObject(id));
                Iterator keys = personData.keys();
                HashMap data = Maps.newHashMap();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    data.put(key, personData.getString(key));
                }
                idToData.put(id, data);
            }
            return ImmediateFuture.newInstance((Object)new DataCollection((Map)idToData));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> deletePersonData(UserId userId, GroupId groupId, String appId, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (!this.db.getJSONObject(DATA_TABLE).has(user)) {
                return null;
            }
            JSONObject newPersonData = new JSONObject();
            JSONObject oldPersonData = this.db.getJSONObject(DATA_TABLE).getJSONObject(user);
            Iterator keys = oldPersonData.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (fields.contains(key)) continue;
                newPersonData.put(key, (Object)oldPersonData.getString(key));
            }
            this.db.getJSONObject(DATA_TABLE).put(user, (Object)newPersonData);
            return ImmediateFuture.newInstance(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> updatePersonData(UserId userId, GroupId groupId, String appId, Set<String> fields, Map<String, String> values, SecurityToken token) throws ProtocolException {
        try {
            JSONObject personData = this.db.getJSONObject(DATA_TABLE).getJSONObject(userId.getUserId(token));
            if (personData == null) {
                personData = new JSONObject();
                this.db.getJSONObject(DATA_TABLE).put(userId.getUserId(token), (Object)personData);
            }
            for (Map.Entry<String, String> entry : values.entrySet()) {
                personData.put(entry.getKey(), (Object)entry.getValue());
            }
            return ImmediateFuture.newInstance(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> createMessage(UserId userId, String appId, String msgCollId, Message message, SecurityToken token) throws ProtocolException {
        for (String recipient : message.getRecipients()) {
            try {
                JSONArray outbox = this.db.getJSONObject(MESSAGE_TABLE).getJSONArray(recipient);
                if (outbox == null) {
                    outbox = new JSONArray();
                    this.db.getJSONObject(MESSAGE_TABLE).put(recipient, (Object)outbox);
                }
                outbox.put((Object)message);
            }
            catch (JSONException je) {
                throw new ProtocolException(500, je.getMessage(), (Throwable)je);
            }
        }
        return ImmediateFuture.newInstance(null);
    }

    @Override
    public Future<RestfulCollection<MessageCollection>> getMessageCollections(UserId userId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
        try {
            ArrayList result = Lists.newArrayList();
            JSONObject messageCollections = this.db.getJSONObject(MESSAGE_TABLE).getJSONObject(userId.getUserId(token));
            for (String msgCollId : JSONObject.getNames((JSONObject)messageCollections)) {
                JSONObject msgColl = messageCollections.getJSONObject(msgCollId);
                msgColl.put("id", (Object)msgCollId);
                JSONArray messages = msgColl.getJSONArray(MESSAGE_TABLE);
                int numMessages = messages == null ? 0 : messages.length();
                msgColl.put("total", (Object)String.valueOf(numMessages));
                msgColl.put("unread", (Object)String.valueOf(numMessages));
                result.add(this.filterFields(msgColl, fields, MessageCollection.class));
            }
            return ImmediateFuture.newInstance((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> deleteMessages(UserId userId, String msgCollId, List<String> ids, SecurityToken token) throws ProtocolException {
        throw new ProtocolException(501, "this functionality is not yet available");
    }

    @Override
    public Future<RestfulCollection<Message>> getMessages(UserId userId, String msgCollId, Set<String> fields, List<String> msgIds, CollectionOptions options, SecurityToken token) throws ProtocolException {
        try {
            ArrayList result = Lists.newArrayList();
            JSONArray messages = this.db.getJSONObject(MESSAGE_TABLE).getJSONObject(userId.getUserId(token)).getJSONObject(msgCollId).getJSONArray(MESSAGE_TABLE);
            if (messages == null) {
                throw new ProtocolException(400, "message collection" + msgCollId + " not found");
            }
            for (int i = 0; i < messages.length(); ++i) {
                JSONObject msg = messages.getJSONObject(i);
                result.add(this.filterFields(msg, fields, Message.class));
            }
            return ImmediateFuture.newInstance((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<MessageCollection> createMessageCollection(UserId userId, MessageCollection msgCollection, SecurityToken token) throws ProtocolException {
        throw new ProtocolException(501, "this functionality is not yet available");
    }

    @Override
    public Future<Void> modifyMessage(UserId userId, String msgCollId, String messageId, Message message, SecurityToken token) throws ProtocolException {
        throw new ProtocolException(501, "this functionality is not yet available");
    }

    @Override
    public Future<Void> modifyMessageCollection(UserId userId, MessageCollection msgCollection, SecurityToken token) throws ProtocolException {
        throw new ProtocolException(501, "this functionality is not yet available");
    }

    @Override
    public Future<Void> deleteMessageCollection(UserId userId, String msgCollId, SecurityToken token) throws ProtocolException {
        throw new ProtocolException(501, "this functionality is not yet available");
    }

    public String getPassword(String username) {
        try {
            return this.db.getJSONObject(PASSWORDS_TABLE).getString(username);
        }
        catch (JSONException e) {
            return null;
        }
    }

    private Set<String> getIdSet(UserId user, GroupId group, SecurityToken token) throws JSONException {
        String userId = user.getUserId(token);
        if (group == null) {
            return ImmutableSortedSet.of((Comparable)((Object)userId));
        }
        LinkedHashSet returnVal = Sets.newLinkedHashSet();
        switch (group.getType()) {
            case all: 
            case friends: 
            case groupId: {
                if (!this.db.getJSONObject(FRIEND_LINK_TABLE).has(userId)) break;
                JSONArray friends = this.db.getJSONObject(FRIEND_LINK_TABLE).getJSONArray(userId);
                for (int i = 0; i < friends.length(); ++i) {
                    returnVal.add(friends.getString(i));
                }
                break;
            }
            case self: {
                returnVal.add(userId);
            }
        }
        return returnVal;
    }

    private Set<String> getIdSet(Set<UserId> users, GroupId group, SecurityToken token) throws JSONException {
        LinkedHashSet ids = Sets.newLinkedHashSet();
        for (UserId user : users) {
            ids.addAll(this.getIdSet(user, group, token));
        }
        return ids;
    }

    private JSONObject convertFromActivity(Activity activity, Set<String> fields) throws JSONException {
        return new JSONObject(this.converter.convertToString((Object)activity));
    }

    private <T> T filterFields(JSONObject object, Set<String> fields, Class<T> clz) throws JSONException {
        if (!fields.isEmpty()) {
            object = new JSONObject(object, fields.toArray(new String[fields.size()]));
        }
        return (T)this.converter.convertToObject(object.toString(), clz);
    }
}

