/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.parser.html.Namespaces;
import com.google.caja.util.Function;
import com.google.caja.util.Maps;
import com.google.caja.util.Strings;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DoctypeMaker {
    private static final Pattern DOCTYPE_PATTERN;
    private static final Map<String, String> BY_SYSTEM_ID;

    DoctypeMaker() {
    }

    public static Function<DOMImplementation, DocumentType> parse(String text) {
        Matcher m = DOCTYPE_PATTERN.matcher(text);
        if (!m.matches()) {
            return null;
        }
        String name = m.group(1);
        String system2 = DoctypeMaker.dequote(m.group(2));
        String pubid = DoctypeMaker.dequote(m.group(3));
        String system4 = DoctypeMaker.dequote(m.group(4));
        String system = system2 == null ? system4 : system2;
        boolean isHtml = DoctypeMaker.isHtml(name, pubid, system);
        if (isHtml && name.indexOf(58) < 0) {
            name = Strings.toLowerCase(name);
        }
        final String qname = name;
        final String publicId = pubid;
        final String systemId = system;
        return new Function<DOMImplementation, DocumentType>(){

            @Override
            public DocumentType apply(DOMImplementation impl) {
                return impl.createDocumentType(qname, publicId, systemId);
            }
        };
    }

    public static String systemIdToNsUri(String systemId) {
        String nsUri = BY_SYSTEM_ID.get(systemId);
        if (nsUri == null && systemId != null) {
            String wildcard = systemId.replaceFirst("/[^/]+\\.dtd$", "/*.dtd");
            nsUri = BY_SYSTEM_ID.get(wildcard);
        }
        return nsUri;
    }

    private static String dequote(String s) {
        if (s == null) {
            return s;
        }
        int len = s.length();
        if (len < 2) {
            return s;
        }
        char ch0 = s.charAt(0);
        if (ch0 != '\"' && ch0 != '\'') {
            return s;
        }
        if (ch0 != s.charAt(len - 1)) {
            return s;
        }
        return s.substring(1, len - 1);
    }

    static boolean isHtml(String name, String pubid, String systemId) {
        String nsUri = DoctypeMaker.systemIdToNsUri(systemId);
        if (nsUri != null && Namespaces.isHtml(nsUri)) {
            return true;
        }
        if (pubid != null) {
            return (pubid = Strings.toLowerCase(pubid).replaceAll("\\s+", " ").trim()).startsWith("-//w3c//dtd html ") || pubid.startsWith("-//w3c//dtd xhtml ") || pubid.startsWith("-//ietf//dtd html");
        }
        if (systemId == null) {
            return Strings.equalsIgnoreCase("html", name);
        }
        return false;
    }

    static {
        String s = "[ \\t\\r\\n]+";
        String nameStartCharSet = "A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f\u1fff\u200c\u200d\u2070-\u218f\u2c00\u2fef\u3001\ud7ff\uf900-\ufdcf\ufdf0-\ufffd";
        String nameStartChar = "[" + nameStartCharSet + "]";
        String nameChar = "[" + nameStartCharSet + "\\-.0-9\u0087\u0300-\u036f\u203f-\u2040]";
        String name = "(?:" + nameStartChar + nameChar + "*)";
        String systemLiteral = "(?:\"[^\"]*\"|'[^']*')";
        String pubidChar = "[ \\r\\na-zA-Z0-9\\-'()+,./:=?;!*#$_%]";
        String pubidLiteral = "(?:\"" + pubidChar + "*\"|'" + pubidChar.replace("'", "\"") + "*')";
        String externalId = "(?:SYSTEM" + s + "(" + systemLiteral + ")" + "|PUBLIC" + s + "(" + pubidLiteral + ")" + "(?:" + s + "(" + systemLiteral + "))?)";
        String intSubset = "[^\\]>]*";
        DOCTYPE_PATTERN = Pattern.compile("<!DOCTYPE" + s + "(" + name + ")(?:" + s + externalId + ")?" + "(?:" + s + ")?(?:\\[" + intSubset + "\\](?:" + s + ")?)?>", 2);
        BY_SYSTEM_ID = Maps.immutableMap().put("http://www.w3.org/TR/html4/*.dtd", Namespaces.HTML_NAMESPACE_URI).put("http://www.w3.org/TR/xhtml1/DTD/*.dtd", Namespaces.HTML_NAMESPACE_URI).put("http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/*.dtd", Namespaces.SVG_NAMESPACE_URI).put("http://www.w3.org/Graphics/SVG/1.1/DTD/*.dtd", Namespaces.SVG_NAMESPACE_URI).create();
    }
}

