/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.quasiliteral.PermitTemplate;
import java.util.LinkedHashMap;
import java.util.Map;

final class Permit {
    private final Map<String, Permit> permitsUsed = new LinkedHashMap<String, Permit>();
    private final PermitTemplate template;

    Permit() {
        this(PermitTemplate.DefaultTemplate);
    }

    Permit(PermitTemplate template) {
        this.template = template;
    }

    private Permit has(String name) {
        Permit result = this.permitsUsed.get(name);
        if (null != result) {
            return result;
        }
        PermitTemplate subTemplate = this.template.templates.get(name);
        if (null != subTemplate) {
            result = new Permit(subTemplate);
            this.permitsUsed.put(name, result);
            return result;
        }
        return null;
    }

    Permit canRead(ParseTreeNode path) {
        if (path instanceof Reference) {
            return this.has(((Reference)path).getIdentifierName());
        }
        if (path instanceof Identifier) {
            return this.has(((Identifier)path).getName());
        }
        return null;
    }

    Permit canCall(ParseTreeNode path) {
        Permit p = this.canRead(path);
        if (null == p) {
            return null;
        }
        return p.has("()");
    }

    public String getPermitsUsedAsJSONString() {
        StringBuilder myBuf = new StringBuilder();
        this.getPermitsUsedAsJSONString(myBuf, ",\n  ");
        return myBuf.toString();
    }

    private void getPermitsUsedAsJSONString(StringBuilder myBuf, String sep) {
        myBuf.append("{");
        boolean first = true;
        for (Map.Entry<String, Permit> assoc : this.permitsUsed.entrySet()) {
            if (!first) {
                myBuf.append(sep);
            }
            myBuf.append("\"").append(assoc.getKey()).append("\":");
            assoc.getValue().getPermitsUsedAsJSONString(myBuf, sep + "  ");
            first = false;
        }
        myBuf.append("}");
    }
}

