/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.common.JsonProperty;
import org.json.JSONObject;

public class JsonUtil {
    private static final Set<String> EXCLUDE_METHODS = ImmutableSet.of((Object)"getClass", (Object)"getDeclaringClass");
    private static final Map<Class<?>, Map<String, Method>> getters = new MapMaker().makeMap();

    public static Object getProperty(Object value, String propertyName) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull((Object)propertyName);
        if (value instanceof JSONObject) {
            return ((JSONObject)value).opt(propertyName);
        }
        if (value instanceof Map) {
            return ((Map)value).get(propertyName);
        }
        Method method = JsonUtil.getGetters(value).get(propertyName);
        if (method != null) {
            try {
                return method.invoke(value, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static Map<String, Method> getGetters(Object pojo) {
        Class<?> clazz = pojo.getClass();
        HashMap methods = getters.get(clazz);
        if (methods != null) {
            return methods;
        }
        methods = Maps.newHashMap();
        for (Method method : clazz.getMethods()) {
            String name;
            if (method.getParameterTypes().length != 0 || (name = JsonUtil.getPropertyName(method)) == null) continue;
            methods.put(name, method);
        }
        getters.put(clazz, methods);
        return methods;
    }

    private static String getPropertyName(Method method) {
        JsonProperty property = method.getAnnotation(JsonProperty.class);
        if (property == null) {
            String name = method.getName();
            if (name.startsWith("get") && !EXCLUDE_METHODS.contains(name)) {
                return name.substring(3, 4).toLowerCase() + name.substring(4);
            }
            return null;
        }
        return property.value();
    }
}

