/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.protocol.ContentTypes;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.ResponseItem;
import org.apache.shindig.protocol.SystemHandler;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;

public abstract class ApiServlet
extends InjectedServlet {
    private static final Logger logger = Logger.getLogger(ApiServlet.class.getName());
    protected static final String FORMAT_PARAM = "format";
    protected static final String JSON_FORMAT = "json";
    protected static final String ATOM_FORMAT = "atom";
    protected static final String XML_FORMAT = "xml";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    public static final String HANDLERS_PARAM = "handlers";
    public static final Key<Set<Object>> DEFAULT_HANDLER_KEY = Key.get((TypeLiteral)new TypeLiteral<Set<Object>>(){}, (Annotation)Names.named((String)"org.apache.shindig.protocol.handlers"));
    protected HandlerRegistry dispatcher;
    protected BeanJsonConverter jsonConverter;
    protected BeanConverter xmlConverter;
    protected BeanConverter atomConverter;
    @Deprecated
    protected boolean disallowUnknownContentTypes = true;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String handlers = config.getInitParameter(HANDLERS_PARAM);
        Key handlerKey = handlers == null || "".equals(handlers) ? DEFAULT_HANDLER_KEY : Key.get((TypeLiteral)new TypeLiteral<Set<Object>>(){}, (Annotation)Names.named((String)handlers));
        this.dispatcher.addHandlers((Set)this.injector.getInstance(handlerKey));
        this.dispatcher.addHandlers(Collections.singleton(new SystemHandler(this.dispatcher)));
    }

    @Inject
    public void setHandlerRegistry(HandlerRegistry dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Inject(optional=true)
    public void setDisallowUnknownContentTypes(@Named(value="shindig.api.disallow-unknown-content-types") boolean disallowUnknownContentTypes) {
        this.disallowUnknownContentTypes = disallowUnknownContentTypes;
    }

    @Inject
    public void setBeanConverters(@Named(value="shindig.bean.converter.json") BeanConverter jsonConverter, @Named(value="shindig.bean.converter.xml") BeanConverter xmlConverter, @Named(value="shindig.bean.converter.atom") BeanConverter atomConverter) {
        this.jsonConverter = (BeanJsonConverter)jsonConverter;
        this.xmlConverter = xmlConverter;
        this.atomConverter = atomConverter;
    }

    protected SecurityToken getSecurityToken(HttpServletRequest servletRequest) {
        return new AuthInfo(servletRequest).getSecurityToken();
    }

    protected abstract void sendError(HttpServletResponse var1, ResponseItem var2) throws IOException;

    protected void sendSecurityError(HttpServletResponse servletResponse) throws IOException {
        this.sendError(servletResponse, new ResponseItem(401, "The request did not have a proper security token nor oauth message and unauthenticated requests are not allowed"));
    }

    protected ResponseItem getResponseItem(Future<?> future) {
        ResponseItem response;
        try {
            Map result = future != null ? (Map)future.get() : null;
            response = new ResponseItem(result != null ? result : Collections.emptyMap());
        }
        catch (InterruptedException ie) {
            response = this.responseItemFromException(ie);
        }
        catch (ExecutionException ee) {
            response = this.responseItemFromException(ee.getCause());
        }
        return response;
    }

    protected ResponseItem responseItemFromException(Throwable t) {
        if (t instanceof ProtocolException) {
            ProtocolException pe = (ProtocolException)t;
            logger.log(Level.INFO, "Returning a response error as result of a protocol exception", pe);
            return new ResponseItem(pe.getCode(), pe.getMessage(), pe.getResponse());
        }
        logger.log(Level.WARNING, "Returning a response error as result of an exception", t);
        return new ResponseItem(500, t.getMessage());
    }

    protected void setCharacterEncodings(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        if (servletRequest.getCharacterEncoding() == null) {
            servletRequest.setCharacterEncoding(DEFAULT_ENCODING);
        }
        servletResponse.setCharacterEncoding(DEFAULT_ENCODING);
    }

    public void checkContentTypes(Set<String> allowedContentTypes, String contentType) throws ContentTypes.InvalidContentTypeException {
        ContentTypes.checkContentTypes(allowedContentTypes, contentType, this.disallowUnknownContentTypes);
    }
}

