/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import java.util.List;

public class RestfulCollection<T> {
    private List<T> entry;
    private int startIndex;
    private int totalResults;
    private int itemsPerPage;
    private boolean filtered = false;
    private boolean sorted = false;
    private boolean updatedSince = false;

    public RestfulCollection(List<T> entry) {
        this(entry, 0, entry.size(), entry.size());
        this.filtered = true;
        this.sorted = true;
        this.updatedSince = true;
    }

    @Deprecated
    public RestfulCollection(List<T> entry, int startIndex, int totalResults) {
        this(entry, startIndex, totalResults, entry.size());
    }

    public RestfulCollection(List<T> entry, int startIndex, int totalResults, int itemsPerPage) {
        this.entry = entry;
        this.startIndex = startIndex;
        this.totalResults = totalResults;
        this.itemsPerPage = Math.min(itemsPerPage, totalResults);
    }

    public List<T> getEntry() {
        return this.entry;
    }

    public void setEntry(List<T> entry) {
        this.entry = entry;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public void setTotalResults(int totalResults) {
        this.totalResults = totalResults;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public boolean isUpdatedSince() {
        return this.updatedSince;
    }

    public void setUpdatedSince(boolean updatedSince) {
        this.updatedSince = updatedSince;
    }
}

