/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.ApiServlet;
import org.apache.shindig.protocol.ContentTypes;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ResponseItem;
import org.apache.shindig.protocol.RestHandler;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.conversion.BeanConverter;

public class DataServiceServlet
extends ApiServlet {
    private static final Logger logger = Logger.getLogger(DataServiceServlet.class.getName());
    public static final Set<String> ALLOWED_CONTENT_TYPES = new ImmutableSet.Builder().addAll(ContentTypes.ALLOWED_JSON_CONTENT_TYPES).addAll(ContentTypes.ALLOWED_XML_CONTENT_TYPES).addAll(ContentTypes.ALLOWED_ATOM_CONTENT_TYPES).build();
    protected static final String X_HTTP_METHOD_OVERRIDE = "X-HTTP-Method-Override";

    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        this.executeRequest(servletRequest, servletResponse);
    }

    protected void doPut(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        try {
            this.checkContentTypes(ALLOWED_CONTENT_TYPES, servletRequest.getContentType());
            this.executeRequest(servletRequest, servletResponse);
        }
        catch (ContentTypes.InvalidContentTypeException icte) {
            this.sendError(servletResponse, new ResponseItem(400, icte.getMessage()));
        }
    }

    protected void doDelete(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        this.executeRequest(servletRequest, servletResponse);
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        try {
            this.checkContentTypes(ALLOWED_CONTENT_TYPES, servletRequest.getContentType());
            this.executeRequest(servletRequest, servletResponse);
        }
        catch (ContentTypes.InvalidContentTypeException icte) {
            this.sendError(servletResponse, new ResponseItem(400, icte.getMessage()));
        }
    }

    void executeRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Handling restful request for " + servletRequest.getPathInfo());
        }
        this.setCharacterEncodings(servletRequest, servletResponse);
        SecurityToken token = this.getSecurityToken(servletRequest);
        if (token == null) {
            this.sendSecurityError(servletResponse);
            return;
        }
        BeanConverter converter = this.getConverterForRequest(servletRequest);
        this.handleSingleRequest(servletRequest, servletResponse, token, converter);
    }

    @Override
    protected void sendError(HttpServletResponse servletResponse, ResponseItem responseItem) throws IOException {
        int errorCode = responseItem.getErrorCode();
        if (errorCode < 0) {
            switch (errorCode) {
                case -32700: 
                case -32602: 
                case -32600: {
                    errorCode = 400;
                    break;
                }
                case -32601: {
                    errorCode = 501;
                }
                default: {
                    errorCode = 500;
                }
            }
        }
        servletResponse.sendError(responseItem.getErrorCode(), responseItem.getErrorMessage());
    }

    private void handleSingleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, SecurityToken token, BeanConverter converter) throws IOException {
        RestHandler handler = this.getRestHandler(servletRequest);
        BufferedReader bodyReader = null;
        if (!servletRequest.getMethod().equals("GET") && !servletRequest.getMethod().equals("HEAD")) {
            bodyReader = servletRequest.getReader();
        }
        Map parameterMap = servletRequest.getParameterMap();
        Future<?> future = handler.execute(parameterMap, bodyReader, token, converter);
        ResponseItem responseItem = this.getResponseItem(future);
        servletResponse.setContentType(converter.getContentType());
        if (responseItem.getErrorCode() >= 200 && responseItem.getErrorCode() < 400) {
            PrintWriter writer = servletResponse.getWriter();
            Object response = responseItem.getResponse();
            if (!(response instanceof DataCollection) && !(response instanceof RestfulCollection)) {
                response = ImmutableMap.of((Object)"entry", (Object)response);
            }
            writer.write(converter.convertToString(response));
        } else {
            this.sendError(servletResponse, responseItem);
        }
    }

    protected RestHandler getRestHandler(HttpServletRequest servletRequest) {
        String path = servletRequest.getPathInfo();
        String method = servletRequest.getParameter(X_HTTP_METHOD_OVERRIDE);
        if (method == null) {
            method = servletRequest.getMethod();
        }
        return this.dispatcher.getRestHandler(path, method.toUpperCase());
    }

    public BeanConverter getConverterForRequest(HttpServletRequest servletRequest) {
        String contentType;
        BeanConverter converter;
        String formatString;
        block14: {
            block13: {
                formatString = null;
                converter = null;
                contentType = null;
                try {
                    formatString = servletRequest.getParameter("format");
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.FINE)) break block13;
                    logger.fine("Unexpected error : format param is null " + t.toString());
                }
            }
            try {
                contentType = servletRequest.getContentType();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.FINE)) break block14;
                logger.fine("Unexpected error : content type is null " + t.toString());
            }
        }
        if (contentType != null) {
            if (ContentTypes.ALLOWED_JSON_CONTENT_TYPES.contains(contentType)) {
                converter = this.jsonConverter;
            } else if (ContentTypes.ALLOWED_ATOM_CONTENT_TYPES.contains(contentType)) {
                converter = this.atomConverter;
            } else if (ContentTypes.ALLOWED_XML_CONTENT_TYPES.contains(contentType)) {
                converter = this.xmlConverter;
            } else if (formatString == null) {
                converter = this.jsonConverter;
            }
        } else {
            converter = formatString != null ? (formatString.equals("atom") ? this.atomConverter : (formatString.equals("xml") ? this.xmlConverter : this.jsonConverter)) : this.jsonConverter;
        }
        return converter;
    }
}

