/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.JsonConversionUtil;
import org.apache.shindig.protocol.ApiServlet;
import org.apache.shindig.protocol.ContentTypes;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ResponseItem;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.RpcHandler;
import org.apache.shindig.protocol.multipart.FormDataItem;
import org.apache.shindig.protocol.multipart.MultipartFormParser;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonRpcServlet
extends ApiServlet {
    public static final Set<String> ALLOWED_CONTENT_TYPES = new ImmutableSet.Builder().addAll(ContentTypes.ALLOWED_JSON_CONTENT_TYPES).addAll(ContentTypes.ALLOWED_MULTIPART_CONTENT_TYPES).build();
    public static final String REQUEST_PARAM = "request";
    public static final int SC_JSON_PARSE_ERROR = -32700;
    private MultipartFormParser formParser;
    private static final Map<Integer, String> errorTitles = ImmutableMap.builder().put((Object)501, (Object)"notImplemented").put((Object)401, (Object)"unauthorized").put((Object)403, (Object)"forbidden").put((Object)400, (Object)"badRequest").put((Object)500, (Object)"internalError").put((Object)417, (Object)"limitExceeded").build();

    @Inject
    void setMultipartFormParser(MultipartFormParser formParser) {
        this.formParser = formParser;
    }

    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        this.setCharacterEncodings(servletRequest, servletResponse);
        servletResponse.setContentType("application/json");
        SecurityToken token = this.getSecurityToken(servletRequest);
        if (token == null) {
            this.sendSecurityError(servletResponse);
            return;
        }
        try {
            JSONObject request = JsonConversionUtil.fromRequest(servletRequest);
            this.dispatch(request, null, servletRequest, servletResponse, token);
        }
        catch (JSONException je) {
            this.sendJsonParseError(je, servletResponse);
        }
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        this.setCharacterEncodings(servletRequest, servletResponse);
        servletResponse.setContentType("application/json");
        try {
            this.checkContentTypes(ALLOWED_CONTENT_TYPES, servletRequest.getContentType());
            SecurityToken token = this.getSecurityToken(servletRequest);
            if (token == null) {
                this.sendSecurityError(servletResponse);
                return;
            }
            String content = null;
            Map<String, FormDataItem> formItems = Collections.emptyMap();
            if (this.formParser.isMultipartContent(servletRequest)) {
                formItems = new HashMap();
                for (FormDataItem item : this.formParser.parse(servletRequest)) {
                    if (item.isFormField() && REQUEST_PARAM.equals(item.getFieldName()) && content == null) {
                        if (!StringUtils.isEmpty((String)item.getContentType())) {
                            this.checkContentTypes(ContentTypes.ALLOWED_JSON_CONTENT_TYPES, item.getContentType());
                        }
                        content = item.getAsString();
                        continue;
                    }
                    formItems.put(item.getFieldName(), item);
                }
                if (content == null) {
                    content = "";
                }
            } else {
                content = IOUtils.toString((InputStream)servletRequest.getInputStream(), (String)servletRequest.getCharacterEncoding());
            }
            if (content.indexOf(91) != -1 && content.indexOf(91) < content.indexOf(123)) {
                JSONArray batch = new JSONArray(content);
                this.dispatchBatch(batch, formItems, servletRequest, servletResponse, token);
            } else {
                JSONObject request = new JSONObject(content);
                this.dispatch(request, formItems, servletRequest, servletResponse, token);
            }
        }
        catch (JSONException je) {
            this.sendJsonParseError(je, servletResponse);
        }
        catch (ContentTypes.InvalidContentTypeException icte) {
            this.sendBadRequest(icte, servletResponse);
        }
    }

    protected void dispatchBatch(JSONArray batch, Map<String, FormDataItem> formItems, HttpServletRequest servletRequest, HttpServletResponse servletResponse, SecurityToken token) throws JSONException, IOException {
        ArrayList responses = Lists.newArrayListWithCapacity((int)batch.length());
        for (int i = 0; i < batch.length(); ++i) {
            JSONObject batchObj = batch.getJSONObject(i);
            responses.add(this.getHandler(batchObj, servletRequest).execute(formItems, token, this.jsonConverter));
        }
        ArrayList<Object> result = new ArrayList<Object>(batch.length());
        for (int i = 0; i < batch.length(); ++i) {
            JSONObject batchObj = batch.getJSONObject(i);
            String key = null;
            if (batchObj.has("id")) {
                key = batchObj.getString("id");
            }
            result.add(this.getJSONResponse(key, this.getResponseItem((Future)responses.get(i))));
        }
        this.jsonConverter.append(servletResponse.getWriter(), result);
    }

    protected void dispatch(JSONObject request, Map<String, FormDataItem> formItems, HttpServletRequest servletRequest, HttpServletResponse servletResponse, SecurityToken token) throws JSONException, IOException {
        String key = null;
        if (request.has("id")) {
            key = request.getString("id");
        }
        Future<?> future = this.getHandler(request, servletRequest).execute(formItems, token, this.jsonConverter);
        ResponseItem response = this.getResponseItem(future);
        Object result = this.getJSONResponse(key, response);
        this.jsonConverter.append(servletResponse.getWriter(), result);
    }

    protected RpcHandler getHandler(JSONObject rpc, HttpServletRequest request) {
        return this.dispatcher.getRpcHandler(rpc);
    }

    Object getJSONResponse(String key, ResponseItem responseItem) {
        HashMap result = Maps.newHashMap();
        if (key != null) {
            result.put("id", key);
        }
        if (responseItem.getErrorCode() < 200 || responseItem.getErrorCode() >= 400) {
            result.put("error", this.getErrorJson(responseItem));
        } else {
            Object response = responseItem.getResponse();
            if (response instanceof DataCollection) {
                result.put("data", ((DataCollection)response).getEntry());
            } else if (response instanceof RestfulCollection) {
                HashMap map = Maps.newHashMap();
                RestfulCollection collection = (RestfulCollection)response;
                if (collection.getTotalResults() != collection.getEntry().size()) {
                    map.put("totalResults", collection.getTotalResults());
                    map.put("startIndex", collection.getStartIndex());
                    map.put("itemsPerPage", collection.getItemsPerPage());
                }
                if (!collection.isFiltered()) {
                    map.put("filtered", collection.isFiltered());
                }
                if (!collection.isUpdatedSince()) {
                    map.put("updatedSince", collection.isUpdatedSince());
                }
                if (!collection.isSorted()) {
                    map.put("sorted", collection.isUpdatedSince());
                }
                map.put("list", collection.getEntry());
                result.put("data", map);
            } else {
                result.put("data", response);
            }
        }
        return result;
    }

    private Object getErrorJson(ResponseItem responseItem) {
        HashMap<String, Object> error = new HashMap<String, Object>(2, 1.0f);
        error.put("code", responseItem.getErrorCode());
        String message = errorTitles.get(responseItem.getErrorCode());
        if (message == null) {
            message = responseItem.getErrorMessage();
        } else if (StringUtils.isNotBlank((String)responseItem.getErrorMessage())) {
            message = message + ": " + responseItem.getErrorMessage();
        }
        if (StringUtils.isNotBlank((String)message)) {
            error.put("message", message);
        }
        if (responseItem.getResponse() != null) {
            error.put("data", responseItem.getResponse());
        }
        return error;
    }

    @Override
    protected void sendError(HttpServletResponse servletResponse, ResponseItem responseItem) throws IOException {
        this.jsonConverter.append(servletResponse.getWriter(), this.getErrorJson(responseItem));
    }

    private void sendBadRequest(Throwable t, HttpServletResponse response) throws IOException {
        this.sendError(response, new ResponseItem(400, "Invalid batch - " + t.getMessage()));
    }

    private void sendJsonParseError(JSONException e, HttpServletResponse response) throws IOException {
        this.sendError(response, new ResponseItem(-32700, "Invalid JSON - " + e.getMessage()));
    }
}

