/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.shindig.oauth;

import javax.inject.Inject;
import net.oauth.OAuthConsumer;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.oauth.AccessorInfo;
import org.apache.shindig.gadgets.oauth.AccessorInfoBuilder;
import org.apache.shindig.gadgets.oauth.GadgetOAuthTokenStore;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth.OAuthClientState;
import org.apache.shindig.gadgets.oauth.OAuthFetcherConfig;
import org.apache.shindig.gadgets.oauth.OAuthResponseParams;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.nuxeo.ecm.platform.oauth.keys.OAuthServerKeyManager;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.runtime.api.Framework;

public class NXGadgetOAuthTokenStore
extends GadgetOAuthTokenStore {
    protected OpenSocialService os = (OpenSocialService)Framework.getLocalService(OpenSocialService.class);
    protected OAuthServerKeyManager okm = (OAuthServerKeyManager)Framework.getLocalService(OAuthServerKeyManager.class);

    @Inject
    public NXGadgetOAuthTokenStore(OAuthStore store, GadgetSpecFactory specFactory) {
        super(store, specFactory);
    }

    protected boolean isConsumerEmpty(OAuthStore.ConsumerInfo consumerInfo) {
        if (consumerInfo == null) {
            return true;
        }
        if (consumerInfo.getConsumer() == null) {
            return true;
        }
        return consumerInfo.getConsumer().consumerKey == null;
    }

    protected boolean isInternalRequest(OAuthArguments arguments) {
        return arguments.getRequestOption("Nuxeo-Internal-Request", "false").equals("true");
    }

    public AccessorInfo getOAuthAccessor(SecurityToken securityToken, OAuthArguments arguments, OAuthClientState clientState, OAuthResponseParams responseParams, OAuthFetcherConfig fetcherConfig) throws OAuthResponseParams.OAuthRequestException {
        AccessorInfo accessorInfo = super.getOAuthAccessor(securityToken, arguments, clientState, responseParams, fetcherConfig);
        if (this.isConsumerEmpty(accessorInfo.getConsumer()) && this.isInternalRequest(arguments) && !this.os.propagateJSESSIONIDToTrustedHosts()) {
            AccessorInfoBuilder accessorBuilder = new AccessorInfoBuilder();
            accessorBuilder.setParameterLocation(AccessorInfo.OAuthParamLocation.URI_QUERY);
            String callBack = this.os.getOAuthCallbackUrl();
            String consumerKey = this.okm.getInternalKey();
            String secret = this.okm.getInternalSecret();
            OAuthConsumer consumer = new OAuthConsumer(callBack, consumerKey, secret, null);
            consumer.setProperty("oauth_signature_method", (Object)"HMAC-SHA1");
            OAuthStore.ConsumerInfo ci = new OAuthStore.ConsumerInfo(consumer, arguments.getServiceName(), callBack);
            accessorBuilder.setConsumer(ci);
            return accessorBuilder.create(responseParams);
        }
        return accessorInfo;
    }
}

