/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class GroupId {
    private Type type;
    private String groupId;

    public GroupId(Type type, String groupId) {
        this.groupId = groupId;
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public static GroupId fromJson(String jsonId) {
        Type idSpecEnum = Type.jsonValueOf(jsonId);
        if (idSpecEnum != null) {
            return new GroupId(idSpecEnum, null);
        }
        return new GroupId(Type.groupId, jsonId);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GroupId)) {
            return false;
        }
        GroupId actual = (GroupId)o;
        return this.type == actual.type && Objects.equal((Object)this.groupId, (Object)actual.groupId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.groupId, this.type});
    }

    public String toString() {
        switch (this.type) {
            case all: {
                return "ALL";
            }
            case deleted: {
                return "DELETE";
            }
            case friends: {
                return "FRIENDS";
            }
            case self: {
                return "SELF";
            }
            case groupId: {
                return "GROUPID(" + this.groupId + ')';
            }
        }
        return "UNKNOWN";
    }

    public static enum Type {
        all,
        friends,
        self,
        deleted,
        groupId;

        private static final Map<String, Type> jsonTypeMap;

        public static Type jsonValueOf(String jsonType) {
            return jsonTypeMap.get(jsonType);
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Type type : Type.values()) {
                builder.put((Object)('@' + type.name()), (Object)type);
            }
            jsonTypeMap = builder.build();
        }
    }
}

