/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AbstractSpecFactory;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;

@Singleton
public class DefaultMessageBundleFactory
extends AbstractSpecFactory<MessageBundle>
implements MessageBundleFactory {
    private static final Locale ALL_ALL = new Locale("all", "ALL");
    public static final String CACHE_NAME = "messageBundles";

    @Inject
    public DefaultMessageBundleFactory(ExecutorService executor, RequestPipeline pipeline, CacheProvider cacheProvider, @Named(value="shindig.cache.xml.refreshInterval") long refresh) {
        super(MessageBundle.class, executor, pipeline, DefaultMessageBundleFactory.makeCache(cacheProvider), refresh);
    }

    private static Cache<Uri, Object> makeCache(CacheProvider cacheProvider) {
        return cacheProvider.createCache(CACHE_NAME);
    }

    @Override
    protected MessageBundle parse(String content, AbstractSpecFactory.Query query) throws GadgetException {
        return new MessageBundle(((LocaleQuery)query).locale, content);
    }

    @Override
    public MessageBundle getBundle(GadgetSpec spec, Locale locale, boolean ignoreCache) throws GadgetException {
        MessageBundle exact = this.getBundleFor(spec, locale, ignoreCache);
        boolean isAllLanguage = locale.getLanguage().equalsIgnoreCase("all");
        boolean isAllCountry = locale.getCountry().equalsIgnoreCase("ALL");
        MessageBundle lang = isAllCountry ? MessageBundle.EMPTY : this.getBundleFor(spec, new Locale(locale.getLanguage(), "ALL"), ignoreCache);
        MessageBundle country = isAllLanguage ? MessageBundle.EMPTY : this.getBundleFor(spec, new Locale("all", locale.getCountry()), ignoreCache);
        MessageBundle all = isAllCountry || isAllLanguage ? MessageBundle.EMPTY : this.getBundleFor(spec, ALL_ALL, ignoreCache);
        return new MessageBundle(all, country, lang, exact);
    }

    private MessageBundle getBundleFor(GadgetSpec spec, Locale locale, boolean ignoreCache) throws GadgetException {
        LocaleSpec localeSpec = spec.getModulePrefs().getLocale(locale);
        if (localeSpec == null) {
            return MessageBundle.EMPTY;
        }
        if (localeSpec.getMessages().toString().length() == 0) {
            return localeSpec.getMessageBundle();
        }
        LocaleQuery query = new LocaleQuery();
        query.setSpecUri(localeSpec.getMessages()).setGadgetUri(spec.getUrl()).setContainer("default").setIgnoreCache(ignoreCache);
        query.locale = localeSpec;
        return (MessageBundle)super.getSpec(query);
    }

    private static class LocaleQuery
    extends AbstractSpecFactory.Query {
        LocaleSpec locale;

        private LocaleQuery() {
        }
    }
}

