/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.gadgets.http.HttpResponse;

public class FetchResponseUtils {
    public static Map<String, Object> getResponseAsJson(HttpResponse response, String id, String body) {
        HashMap resp = Maps.newHashMap();
        if (id != null) {
            resp.put("id", id);
        }
        resp.put("rc", response.getHttpStatusCode());
        resp.put("body", body);
        HashMap headers = Maps.newHashMap();
        FetchResponseUtils.addHeaders(headers, response, "set-cookie");
        FetchResponseUtils.addHeaders(headers, response, "location");
        if (headers.size() > 0) {
            resp.put("headers", headers);
        }
        for (Map.Entry<String, String> entry : response.getMetadata().entrySet()) {
            resp.put(entry.getKey(), entry.getValue());
        }
        return resp;
    }

    private static void addHeaders(Map<String, Collection<String>> headers, HttpResponse response, String name) {
        Collection<String> values = response.getHeaders(name);
        if (!values.isEmpty()) {
            headers.put(name.toLowerCase(), values);
        }
    }
}

