/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.servlet.UserAgent;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.features.FeatureResourceLoader;

public class BrowserSpecificFeatureResource
implements FeatureResource {
    private final Provider<UserAgent> uaProvider;
    private final FeatureResource delegate;
    private final Map<UserAgent.Browser, List<VersionMatcher>> browserMatch;

    public BrowserSpecificFeatureResource(Provider<UserAgent> uaProvider, FeatureResource delegate, String browserKey) {
        this.uaProvider = uaProvider;
        this.delegate = delegate;
        this.browserMatch = BrowserSpecificFeatureResource.populateBrowserMatchers(browserKey);
    }

    @Override
    public String getContent() {
        if (this.browserMatches()) {
            return this.delegate.getContent();
        }
        return "";
    }

    @Override
    public String getDebugContent() {
        if (this.browserMatches()) {
            return this.delegate.getDebugContent();
        }
        return "";
    }

    @Override
    public boolean isExternal() {
        return this.delegate.isExternal();
    }

    @Override
    public boolean isProxyCacheable() {
        return this.browserMatch.size() > 0 ? false : this.delegate.isProxyCacheable();
    }

    private boolean browserMatches() {
        if (this.browserMatch.size() == 0) {
            return true;
        }
        UserAgent ua = (UserAgent)this.uaProvider.get();
        List<VersionMatcher> versionMatchers = this.browserMatch.get(ua.getBrowser());
        for (VersionMatcher matcher : versionMatchers) {
            if (!matcher.matches(ua.getVersion())) continue;
            return true;
        }
        return false;
    }

    private static Map<UserAgent.Browser, List<VersionMatcher>> populateBrowserMatchers(String browserKey) {
        String[] entries;
        HashMap map = Maps.newHashMap();
        if (browserKey == null || browserKey.length() == 0) {
            return map;
        }
        for (String entry : entries = browserKey.split(",")) {
            entry = entry.trim();
            String[] browserAndVersion = entry.split("-");
            String browser = browserAndVersion[0];
            String versionKey = browserAndVersion.length == 2 ? browserAndVersion[1] : null;
            UserAgent.Browser browserEnum = UserAgent.Browser.valueOf((String)browser.toUpperCase());
            if (!map.containsKey(browserEnum)) {
                map.put(browserEnum, Lists.newLinkedList());
            }
            ((List)map.get(browserEnum)).add(new VersionMatcher(versionKey));
        }
        return map;
    }

    private static class VersionMatcher {
        private static final Op[] OPS = new Op[]{new Op("^"){

            @Override
            public boolean match(String in, String key) {
                return in.matches(key);
            }
        }, new Op("="){

            @Override
            public boolean match(String in, String key) {
                return in.equals(key) || VersionMatcher.num(in).eq(VersionMatcher.num(key));
            }
        }, new Op(">"){

            @Override
            public boolean match(String in, String key) {
                return VersionMatcher.num(in).gt(VersionMatcher.num(key));
            }
        }, new Op(">="){

            @Override
            public boolean match(String in, String key) {
                return in.equals(key) || VersionMatcher.num(in).eq(VersionMatcher.num(key)) || VersionMatcher.num(in).gt(VersionMatcher.num(key));
            }
        }, new Op("<"){

            @Override
            public boolean match(String in, String key) {
                return VersionMatcher.num(in).lt(VersionMatcher.num(key));
            }
        }, new Op("<="){

            @Override
            public boolean match(String in, String key) {
                return in.equals(key) || VersionMatcher.num(in).eq(VersionMatcher.num(key)) || VersionMatcher.num(in).lt(VersionMatcher.num(key));
            }
        }};
        private final String versionKey;

        private VersionMatcher(String versionKey) {
            this.versionKey = versionKey != null && versionKey.length() != 0 ? versionKey : null;
        }

        public boolean matches(String version) {
            if (this.versionKey == null || this.versionKey.equals(version)) {
                return true;
            }
            for (Op op : OPS) {
                if (!op.apply(version, this.versionKey)) continue;
                return true;
            }
            return false;
        }

        private static VersionNumber num(String str) {
            return new VersionNumber(str);
        }

        private static class VersionNumber {
            private final int[] parts;

            private VersionNumber(String str) {
                String[] strParts = str.split("\\.");
                int[] intParts = new int[strParts.length];
                try {
                    for (int i = 0; i < strParts.length; ++i) {
                        intParts[i] = Integer.parseInt(strParts[i]);
                    }
                }
                catch (NumberFormatException e) {
                    intParts = null;
                }
                this.parts = intParts;
            }

            public boolean eq(VersionNumber other) {
                return Arrays.equals(this.parts, other.parts);
            }

            public boolean lt(VersionNumber other) {
                for (int i = 0; i < this.parts.length; ++i) {
                    int otherVal;
                    int n = otherVal = i < other.parts.length ? other.parts[i] : 0;
                    if (this.parts[i] <= otherVal) continue;
                    return false;
                }
                return true;
            }

            public boolean gt(VersionNumber other) {
                for (int i = 0; i < this.parts.length; ++i) {
                    int otherVal;
                    int n = otherVal = i < other.parts.length ? other.parts[i] : 0;
                    if (this.parts[i] >= otherVal) continue;
                    return false;
                }
                return true;
            }
        }

        private static abstract class Op {
            private final String pfx;

            private Op(String pfx) {
                this.pfx = pfx;
            }

            private boolean apply(String version, String key) {
                if (version.startsWith(this.pfx)) {
                    version = version.substring(this.pfx.length());
                    return this.match(version, key);
                }
                return false;
            }

            public abstract boolean match(String var1, String var2);
        }
    }

    public static class Loader
    extends FeatureResourceLoader {
        private final Provider<UserAgent> uaProvider;

        @Inject
        public Loader(Provider<UserAgent> uaProvider) {
            this.uaProvider = uaProvider;
        }

        @Override
        public FeatureResource load(Uri uri, Map<String, String> attribs) throws GadgetException {
            return new BrowserSpecificFeatureResource(this.uaProvider, super.load(uri, attribs), attribs.get("browser"));
        }
    }
}

