/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssLexer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.GadgetException;

public class CajaCssLexerParser {
    private static final Pattern urlMatcher = Pattern.compile("(url\\s*\\(\\s*['\"]?)([^\\)'\"]*)(['\"]?\\s*\\))", 2);
    private static final URI DUMMY_SOURCE = URI.create("http://www.example.org");
    public static final String CACHE_NAME = "parsedCss";
    private Cache<String, List<Object>> parsedCssCache;

    @Inject
    public void setCacheProvider(CacheProvider cacheProvider) {
        this.parsedCssCache = cacheProvider.createCache(CACHE_NAME);
    }

    public List<Object> parse(String content) throws GadgetException {
        List parsedCss = null;
        boolean shouldCache = this.shouldCache();
        String key = null;
        if (shouldCache) {
            key = HashUtil.rawChecksum((byte[])content.getBytes());
            parsedCss = (List)this.parsedCssCache.getElement((Object)key);
        }
        if (parsedCss == null) {
            parsedCss = this.parseImpl(content);
            if (shouldCache) {
                this.parsedCssCache.addElement((Object)key, (Object)parsedCss);
            }
        }
        if (shouldCache) {
            ArrayList cloned = Lists.newArrayListWithCapacity((int)parsedCss.size());
            for (Object o : parsedCss) {
                if (o instanceof ImportDecl) {
                    cloned.add(new ImportDecl(((ImportDecl)o).getUri()));
                    continue;
                }
                if (o instanceof UriDecl) {
                    cloned.add(new UriDecl(((UriDecl)o).getUri()));
                    continue;
                }
                cloned.add(o);
            }
            return cloned;
        }
        return parsedCss;
    }

    List<Object> parseImpl(String content) throws GadgetException {
        ArrayList parsedCss = Lists.newArrayList();
        CharProducer producer = CharProducer.Factory.create((StringReader)new StringReader(content), (InputSource)new InputSource(DUMMY_SOURCE));
        CssLexer lexer = new CssLexer(producer);
        try {
            StringBuilder builder = new StringBuilder();
            boolean inImport = false;
            while (lexer.hasNext()) {
                Matcher matcher;
                Token token = lexer.next();
                if (token.type == CssTokenType.SYMBOL && token.text.equalsIgnoreCase("@import")) {
                    parsedCss.add(builder.toString());
                    builder.setLength(0);
                    inImport = true;
                    continue;
                }
                if (inImport) {
                    if (token.type == CssTokenType.URI) {
                        parsedCss.add(builder.toString());
                        builder.setLength(0);
                        matcher = urlMatcher.matcher(token.text);
                        if (!matcher.find()) continue;
                        parsedCss.add(new ImportDecl(matcher.group(2).trim()));
                        continue;
                    }
                    if (token.type == CssTokenType.SPACE || token.type == CssTokenType.PUNCTUATION) continue;
                    inImport = false;
                    builder.append(token.text);
                    continue;
                }
                if (token.type == CssTokenType.URI) {
                    matcher = urlMatcher.matcher(token.text);
                    if (!matcher.find()) {
                        builder.append(token.text);
                        continue;
                    }
                    parsedCss.add(builder.toString());
                    builder.setLength(0);
                    parsedCss.add(new UriDecl(matcher.group(2).trim()));
                    continue;
                }
                builder.append(token.text);
            }
            parsedCss.add(builder.toString());
        }
        catch (ParseException pe) {
            throw new GadgetException(GadgetException.Code.CSS_PARSE_ERROR, (Throwable)pe);
        }
        return parsedCss;
    }

    public String serialize(List<Object> styleSheet) {
        StringWriter writer = new StringWriter();
        this.serialize(styleSheet, writer);
        return writer.toString();
    }

    public void serialize(List<Object> styleSheet, Appendable writer) {
        try {
            for (Object o : styleSheet) {
                writer.append(o.toString());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private boolean shouldCache() {
        return this.parsedCssCache != null && this.parsedCssCache.getCapacity() != 0L;
    }

    public static class UriDecl {
        private String uri;

        public UriDecl(String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String toString() {
            return "url('" + this.uri + "')";
        }
    }

    public static class ImportDecl {
        private String uri;

        public ImportDecl(String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String toString() {
            return "@import url('" + this.uri + "');\n";
        }
    }
}

