/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import org.apache.shindig.common.JsonUtil;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.expressions.RootELResolver;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetELResolver;
import org.apache.shindig.gadgets.preload.PipelinedDataPreloader;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.PreloaderService;
import org.apache.shindig.gadgets.spec.PipelinedData;

public class PipelineExecutor {
    private static final int MAX_BATCH_COUNT = 3;
    private static final Logger logger = Logger.getLogger(PipelineExecutor.class.getName());
    private PipelinedDataPreloader preloader;
    private PreloaderService preloaderService;
    private Expressions expressions;

    @Inject
    public PipelineExecutor(PipelinedDataPreloader preloader, PreloaderService preloaderService, Expressions expressions) {
        this.preloader = preloader;
        this.preloaderService = preloaderService;
        this.expressions = expressions;
    }

    public Results execute(GadgetContext context, Collection<PipelinedData> pipelines) {
        ArrayList results = Lists.newArrayList();
        HashMap elResults = Maps.newHashMap();
        CompositeELResolver rootObjects = new CompositeELResolver();
        rootObjects.add((ELResolver)new GadgetELResolver(context));
        rootObjects.add((ELResolver)new RootELResolver((Map)elResults));
        ArrayList pipelineStates = Lists.newArrayList();
        for (PipelinedData pipeline : pipelines) {
            PipelinedData.Batch batch = pipeline.getBatch(this.expressions, (ELResolver)rootObjects);
            pipelineStates.add(new PipelineState(pipeline, batch));
        }
        int batchCount = 0;
        do {
            ArrayList tasks = Lists.newArrayList();
            for (PipelineState pipeline : pipelineStates) {
                if (pipeline.batch == null) continue;
                tasks.addAll(this.preloader.createPreloadTasks(context, pipeline.batch));
            }
            if (tasks.isEmpty()) break;
            Collection<PreloadedData> preloads = this.preloaderService.preload(tasks);
            for (PreloadedData preloaded : preloads) {
                try {
                    for (Object entry : preloaded.toJson()) {
                        results.add(entry);
                        String id = (String)JsonUtil.getProperty((Object)entry, (String)"id");
                        Object data = JsonUtil.getProperty((Object)entry, (String)"data");
                        if (data != null) {
                            elResults.put(id, data);
                            continue;
                        }
                        Object error = JsonUtil.getProperty((Object)entry, (String)"error");
                        if (error == null) continue;
                        elResults.put(id, error);
                    }
                }
                catch (PreloadException pe) {
                    logger.log(Level.WARNING, "Unexpected error when preloading", pe);
                }
            }
            for (PipelineState pipeline : pipelineStates) {
                if (pipeline.batch == null) continue;
                pipeline.batch = pipeline.batch.getNextBatch((ELResolver)rootObjects);
            }
        } while (++batchCount != 3);
        ArrayList remainingPipelines = Lists.newArrayList();
        for (PipelineState pipeline : pipelineStates) {
            if (pipeline.batch == null) continue;
            remainingPipelines.add(pipeline.pipeline);
        }
        return new Results(remainingPipelines, results, elResults);
    }

    static class PipelineState {
        public final PipelinedData pipeline;
        public PipelinedData.Batch batch;

        public PipelineState(PipelinedData pipeline, PipelinedData.Batch batch) {
            this.pipeline = pipeline;
            this.batch = batch;
        }
    }

    public static class Results {
        public final Collection<PipelinedData> remainingPipelines;
        public final Collection<? extends Object> results;
        public final Map<String, ? extends Object> keyedResults;

        public Results(Collection<PipelinedData> remainingPipelines, Collection<? extends Object> results, Map<String, ? extends Object> keyedResults) {
            this.remainingPipelines = remainingPipelines;
            this.results = results;
            this.keyedResults = keyedResults;
        }
    }
}

