/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.concurrent.TimeUnit;
import org.apache.shindig.gadgets.render.DefaultServiceFetcher;
import org.apache.shindig.gadgets.render.RpcServiceLookup;

@Singleton
public class DefaultRpcServiceLookup
implements RpcServiceLookup {
    private final Cache<String, Multimap<String, String>> containerServices;
    private final DefaultServiceFetcher fetcher;

    @Inject
    public DefaultRpcServiceLookup(DefaultServiceFetcher fetcher, @Named(value="org.apache.shindig.serviceExpirationDurationMinutes") Long duration) {
        this.containerServices = CacheBuilder.newBuilder().expireAfterWrite(duration * 60L, TimeUnit.SECONDS).build();
        this.fetcher = fetcher;
    }

    @Override
    public Multimap<String, String> getServicesFor(String container, String host) {
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkArgument((container.length() != 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)host);
        Multimap<String, String> foundServices = (Multimap<String, String>)this.containerServices.getIfPresent((Object)container);
        if (foundServices == null && (foundServices = this.fetcher.getServicesForContainer(container, host)) != null) {
            this.setServicesFor(container, foundServices);
        }
        if (foundServices == null) {
            foundServices = ImmutableMultimap.builder().build();
        }
        return foundServices;
    }

    void setServicesFor(String container, Multimap<String, String> foundServices) {
        this.containerServices.put((Object)container, foundServices);
    }
}

