/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.render.Renderer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DefaultServiceFetcher {
    static final Logger logger = Logger.getLogger(Renderer.class.getName());
    static final String JSON_RESPONSE_WRAPPER_ELEMENT = "data";
    static final String OSAPI_FEATURE_CONFIG = "osapi";
    static final String OSAPI_SERVICES = "osapi.services";
    static final String GADGETS_FEATURES_CONFIG = "gadgets.features";
    static final String SYSTEM_LIST_METHODS_METHOD = "system.listMethods";
    static final String OSAPI_BASE_ENDPOINTS = "endPoints";
    private final ContainerConfig containerConfig;
    private final HttpFetcher fetcher;

    @Inject
    public DefaultServiceFetcher(ContainerConfig config, HttpFetcher fetcher) {
        this.containerConfig = config;
        this.fetcher = fetcher;
    }

    public Multimap<String, String> getServicesForContainer(String container, String host) {
        if (this.containerConfig == null) {
            return ImmutableMultimap.builder().build();
        }
        LinkedHashMultimap endpointServices = LinkedHashMultimap.create();
        Map declaredServices = (Map)this.containerConfig.getMap(container, GADGETS_FEATURES_CONFIG).get(OSAPI_SERVICES);
        if (declaredServices != null) {
            for (Map.Entry entry : declaredServices.entrySet()) {
                Iterable entryValue = (Iterable)entry.getValue();
                endpointServices.putAll(entry.getKey(), entryValue);
            }
        }
        List<String> endpoints = this.getEndpointsFromContainerConfig(container, host);
        for (String endpoint : endpoints) {
            endpointServices.putAll((Object)endpoint, this.retrieveServices(endpoint.replace("%host%", host)));
        }
        return ImmutableMultimap.copyOf((Multimap)endpointServices);
    }

    private List<String> getEndpointsFromContainerConfig(String container, String host) {
        Map properties = (Map)this.containerConfig.getMap(container, GADGETS_FEATURES_CONFIG).get(OSAPI_FEATURE_CONFIG);
        if (properties != null) {
            return (List)properties.get(OSAPI_BASE_ENDPOINTS);
        }
        return ImmutableList.of();
    }

    private Set<String> retrieveServices(String endpoint) {
        Uri url = Uri.parse((String)(endpoint + "?method=" + SYSTEM_LIST_METHODS_METHOD));
        HttpRequest request = new HttpRequest(url);
        try {
            HttpResponse response = this.fetcher.fetch(request);
            if (response.getHttpStatusCode() == 200) {
                return this.getServicesFromJsonResponse(response.getResponseAsString());
            }
            logger.log(Level.SEVERE, "HTTP Error " + response.getHttpStatusCode() + " fetching service methods from endpoint " + endpoint);
        }
        catch (GadgetException ge) {
            logger.log(Level.SEVERE, "Failed to fetch services methods from endpoint " + endpoint + ". Error " + ge.getMessage());
        }
        catch (JSONException je) {
            logger.log(Level.SEVERE, "Failed to parse services methods from endpoint " + endpoint + ". " + je.getMessage());
        }
        return ImmutableSet.of();
    }

    private Set<String> getServicesFromJsonResponse(String content) throws JSONException {
        ImmutableSet.Builder services = ImmutableSet.builder();
        JSONObject js = new JSONObject(content);
        JSONArray json = js.getJSONArray(JSON_RESPONSE_WRAPPER_ELEMENT);
        for (int i = 0; i < json.length(); ++i) {
            String o = json.getString(i);
            services.add((Object)o);
        }
        return services.build();
    }
}

