/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.base.Preconditions;
import org.apache.shindig.common.uri.Uri;

public class RenderingResults {
    private final Status status;
    private final String content;
    private final String errorMessage;
    private final Uri redirect;

    private RenderingResults(Status status, String content, String errorMessage, Uri redirect) {
        this.status = status;
        this.content = content;
        this.errorMessage = errorMessage;
        this.redirect = redirect;
    }

    public static RenderingResults ok(String content) {
        return new RenderingResults(Status.OK, content, null, null);
    }

    public static RenderingResults error(String errorMessage) {
        return new RenderingResults(Status.ERROR, null, errorMessage, null);
    }

    public static RenderingResults mustRedirect(Uri redirect) {
        Preconditions.checkNotNull((Object)redirect);
        return new RenderingResults(Status.MUST_REDIRECT, null, null, redirect);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getContent() {
        Preconditions.checkState((this.status == Status.OK ? 1 : 0) != 0, (Object)"Only available when status is OK.");
        return this.content;
    }

    public String getErrorMessage() {
        Preconditions.checkState((this.status == Status.ERROR ? 1 : 0) != 0, (Object)"Only available when status is ERROR.");
        return this.errorMessage;
    }

    public Uri getRedirect() {
        Preconditions.checkState((this.status == Status.MUST_REDIRECT ? 1 : 0) != 0, (Object)"Only available when status is MUST_REDIRECT.");
        return this.redirect;
    }

    public static enum Status {
        OK,
        MUST_REDIRECT,
        ERROR;

    }
}

