/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterUris;

public class ConcatLinkRewriter {
    private static final int MAX_URL_LENGTH = 1500;
    private final ContentRewriterUris rewriterUris;
    private final ContentRewriterFeature rewriterFeature;
    private final Uri gadgetUri;
    private final String container;
    private final boolean debug;
    private final boolean ignoreCache;

    public ConcatLinkRewriter(ContentRewriterUris rewriterUris, Uri gadgetUri, ContentRewriterFeature rewriterFeature, String container, boolean debug, boolean ignoreCache) {
        this.rewriterUris = rewriterUris;
        this.rewriterFeature = rewriterFeature;
        this.gadgetUri = gadgetUri;
        this.container = container;
        this.debug = debug;
        this.ignoreCache = ignoreCache;
    }

    public List<Uri> rewrite(String mimeType, LinkedHashSet<Uri> uris) {
        String concatBase = this.getConcatBase(this.gadgetUri, this.rewriterFeature, mimeType, this.container);
        LinkedList concatUris = Lists.newLinkedList();
        int paramIndex = 1;
        StringBuilder builder = null;
        int maxUriLen = 1500 + concatBase.length();
        try {
            int uriIx = 0;
            for (Uri uri : uris) {
                String uriStr = uri.toString();
                if (builder != null && builder.length() + uriStr.length() > maxUriLen) {
                    concatUris.add(Uri.parse((String)builder.toString()));
                    builder = null;
                    paramIndex = 1;
                    if (uriStr.length() > 1500) {
                        concatUris.add(uri);
                        continue;
                    }
                }
                if (paramIndex == 1) {
                    builder = new StringBuilder(concatBase);
                    if (this.debug) {
                        builder.append("debug=1&");
                    }
                    if (this.ignoreCache) {
                        builder.append("nocache=1&");
                    }
                    if (this.rewriterFeature.getExpires() != null) {
                        builder.append("refresh").append('=').append(this.rewriterFeature.getExpires().toString()).append('&');
                    }
                } else {
                    builder.append('&');
                }
                builder.append(paramIndex).append('=').append(URLEncoder.encode(uriStr, "UTF-8"));
                ++paramIndex;
                ++uriIx;
            }
            if (builder != null) {
                concatUris.add(Uri.parse((String)builder.toString()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return concatUris;
    }

    protected String getConcatBase(Uri gadgetUri, ContentRewriterFeature feature, String mimeType, String container) {
        String concatBaseNoGadget = this.rewriterUris.getConcatBase(container);
        return concatBaseNoGadget + "rewriteMime" + '=' + mimeType + (gadgetUri == null ? "" : "&gadget=" + Utf8UrlCoder.encode((String)gadgetUri.toString())) + "&fp=" + feature.getFingerprint() + '&';
    }
}

