/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizer;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.apache.shindig.gadgets.rewrite.image.PNGOptimizer;

public class JPEGOptimizer
extends BaseOptimizer {
    private boolean usePng;

    public static BufferedImage readJpeg(InputStream is) throws ImageReadException, IOException {
        ICC_Profile iccProfile;
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        Sanselan.getMetadata((byte[])bytes, null);
        byte[] iccBytes = Sanselan.getICCProfileBytes((byte[])bytes);
        if (iccBytes != null && iccBytes.length > 0 && (iccProfile = Sanselan.getICCProfile((byte[])bytes, null)) == null) {
            throw new ImageReadException("Image has ICC but it is corrupt and cannot be read");
        }
        return ImageIO.read(new ByteArrayInputStream(bytes));
    }

    public JPEGOptimizer(OptimizerConfig config, HttpResponse original) {
        super(config, original);
    }

    @Override
    protected void rewriteImpl(BufferedImage image) throws IOException {
        OptimizerConfig pngConfig = new OptimizerConfig(this.config.getMaxInMemoryBytes(), this.config.getMaxPaletteSize(), false, this.config.getJpegCompression(), this.config.getMinThresholdBytes());
        PNGOptimizer pngOptimizer = new PNGOptimizer(pngConfig, this.originalResponse);
        pngOptimizer.rewriteImpl(image);
        int pngLength = Integer.MAX_VALUE;
        if (pngOptimizer.getRewrittenImage() != null) {
            this.minBytes = pngOptimizer.getRewrittenImage();
            pngLength = this.minLength = this.minBytes.length;
        }
        this.write(image);
        if (pngLength == this.minLength) {
            this.usePng = true;
        }
    }

    @Override
    protected String getOutputContentType() {
        if (this.usePng) {
            return "image/png";
        }
        return "image/jpeg";
    }

    @Override
    protected String getOriginalContentType() {
        return "image/jpeg";
    }

    @Override
    protected String getOriginalFormatName() {
        return "jpeg";
    }
}

