/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.Icon;
import org.apache.shindig.gadgets.spec.LinkSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.OAuthSpec;
import org.apache.shindig.gadgets.spec.Preload;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModulePrefs {
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TITLE_URL = "title_url";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_AUTHOR = "author";
    private static final String ATTR_AUTHOR_EMAIL = "author_email";
    private static final String ATTR_SCREENSHOT = "screenshot";
    private static final String ATTR_THUMBNAIL = "thumbnail";
    private static final String ATTR_DIRECTORY_TITLE = "directory_title";
    private static final String ATTR_AUTHOR_AFFILIATION = "author_affiliation";
    private static final String ATTR_AUTHOR_LOCATION = "author_location";
    private static final String ATTR_AUTHOR_PHOTO = "author_photo";
    private static final String ATTR_AUTHOR_ABOUTME = "author_aboutme";
    private static final String ATTR_AUTHOR_QUOTE = "author_quote";
    private static final String ATTR_AUTHOR_LINK = "author_link";
    private static final String ATTR_SHOW_STATS = "show_stats";
    private static final String ATTR_SHOW_IN_DIRECTORY = "show_in_directory";
    private static final String ATTR_SINGLETON = "singleton";
    private static final String ATTR_SCALING = "scaling";
    private static final String ATTR_SCROLLING = "scrolling";
    private static final String ATTR_WIDTH = "width";
    private static final String ATTR_HEIGHT = "height";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_CATEGORY2 = "category2";
    private static final Uri EMPTY_URI = Uri.parse((String)"");
    private static final String UP_SUBST_PREFIX = "__UP_";
    private final Map<String, String> attributes;
    private final Uri base;
    private final boolean needsUserPrefSubstitution;
    private final List<String> categories;
    private Map<String, Feature> features;
    private List<Preload> preloads;
    private List<Icon> icons;
    private Map<Locale, LocaleSpec> locales;
    private Map<String, LinkSpec> links;
    private OAuthSpec oauth;
    private Multimap<String, Node> extraElements;

    public ModulePrefs(Element element, Uri base) throws SpecParserException {
        this.base = base;
        this.attributes = Maps.newHashMap();
        NamedNodeMap attributeNodes = element.getAttributes();
        for (int i = 0; i < attributeNodes.getLength(); ++i) {
            Node node = attributeNodes.item(i);
            this.attributes.put(node.getNodeName(), node.getNodeValue());
        }
        if (this.getTitle() == null) {
            throw new SpecParserException("ModulePrefs@title is required.");
        }
        this.categories = ImmutableList.of((Object)this.getAttribute(ATTR_CATEGORY, ""), (Object)this.getAttribute(ATTR_CATEGORY2, ""));
        MutableBoolean oauthMarker = new MutableBoolean(false);
        ImmutableSet visitors = ImmutableSet.of((Object)new FeatureVisitor(oauthMarker), (Object)new PreloadVisitor(), (Object)new OAuthVisitor(oauthMarker), (Object)new IconVisitor(), (Object)new LocaleVisitor(), (Object)new LinkVisitor(), (Object[])new ElementVisitor[]{new ExtraElementsVisitor()});
        ModulePrefs.walk(element, (Set<ElementVisitor>)visitors);
        for (ElementVisitor ev : visitors) {
            ev.apply(this);
        }
        this.needsUserPrefSubstitution = ModulePrefs.prefsNeedsUserPrefSubstitution(this);
    }

    private ModulePrefs(ModulePrefs prefs, Substitutions substituter) {
        this.base = prefs.base;
        this.categories = prefs.getCategories();
        this.features = prefs.getFeatures();
        this.locales = prefs.getLocales();
        this.oauth = prefs.oauth;
        ArrayList preloads = Lists.newArrayList();
        for (Preload preload : prefs.preloads) {
            preloads.add(preload.substitute(substituter));
        }
        this.preloads = ImmutableList.copyOf((Collection)preloads);
        ArrayList icons = Lists.newArrayList();
        for (Icon icon : prefs.icons) {
            icons.add(icon.substitute(substituter));
        }
        this.icons = ImmutableList.copyOf((Collection)icons);
        ImmutableMap.Builder links = ImmutableMap.builder();
        for (LinkSpec link : prefs.links.values()) {
            LinkSpec sub = link.substitute(substituter);
            links.put((Object)sub.getRel(), (Object)sub);
        }
        this.links = links.build();
        ImmutableMap.Builder attributes = ImmutableMap.builder();
        for (Map.Entry<String, String> attr : prefs.attributes.entrySet()) {
            String substituted = substituter.substituteString(attr.getValue());
            attributes.put((Object)attr.getKey(), (Object)substituted);
        }
        this.extraElements = ImmutableMultimap.copyOf(prefs.extraElements);
        this.attributes = attributes.build();
        this.needsUserPrefSubstitution = prefs.needsUserPrefSubstitution;
    }

    public String getTitle() {
        return this.getAttribute(ATTR_TITLE);
    }

    public Uri getTitleUrl() {
        return this.getUriAttribute(ATTR_TITLE_URL);
    }

    public String getDescription() {
        return this.getAttribute(ATTR_DESCRIPTION);
    }

    public String getAuthor() {
        return this.getAttribute(ATTR_AUTHOR);
    }

    public String getAuthorEmail() {
        return this.getAttribute(ATTR_AUTHOR_EMAIL);
    }

    public Uri getScreenshot() {
        return this.getUriAttribute(ATTR_SCREENSHOT);
    }

    public Uri getThumbnail() {
        return this.getUriAttribute(ATTR_THUMBNAIL);
    }

    public String getDirectoryTitle() {
        return this.getAttribute(ATTR_DIRECTORY_TITLE);
    }

    public String getAuthorAffiliation() {
        return this.getAttribute(ATTR_AUTHOR_AFFILIATION);
    }

    public String getAuthorLocation() {
        return this.getAttribute(ATTR_AUTHOR_LOCATION);
    }

    public Uri getAuthorPhoto() {
        return this.getUriAttribute(ATTR_AUTHOR_PHOTO);
    }

    public String getAuthorAboutme() {
        return this.getAttribute(ATTR_AUTHOR_ABOUTME);
    }

    public String getAuthorQuote() {
        return this.getAttribute(ATTR_AUTHOR_QUOTE);
    }

    public Uri getAuthorLink() {
        return this.getUriAttribute(ATTR_AUTHOR_LINK);
    }

    public boolean getShowStats() {
        return this.getBoolAttribute(ATTR_SHOW_STATS);
    }

    public boolean getShowInDirectory() {
        return this.getBoolAttribute(ATTR_SHOW_IN_DIRECTORY);
    }

    public boolean getSingleton() {
        return this.getBoolAttribute(ATTR_SINGLETON);
    }

    public boolean getScaling() {
        return this.getBoolAttribute(ATTR_SCALING);
    }

    public boolean getScrolling() {
        return this.getBoolAttribute(ATTR_SCROLLING);
    }

    public int getWidth() {
        return this.getIntAttribute(ATTR_WIDTH);
    }

    public int getHeight() {
        return this.getIntAttribute(ATTR_HEIGHT);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String getAttribute(String name, String defaultValue) {
        String value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Uri getUriAttribute(String name) {
        String uriAttribute = this.getAttribute(name);
        if (uriAttribute != null) {
            try {
                Uri uri = Uri.parse((String)uriAttribute);
                return this.base.resolve(uri);
            }
            catch (IllegalArgumentException e) {
                return EMPTY_URI;
            }
        }
        return EMPTY_URI;
    }

    public boolean getBoolAttribute(String name) {
        String value = this.getAttribute(name);
        return Boolean.parseBoolean(value);
    }

    public int getIntAttribute(String name) {
        String value = this.getAttribute(name);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public Map<String, Feature> getFeatures() {
        return this.features;
    }

    public List<Preload> getPreloads() {
        return this.preloads;
    }

    public List<Icon> getIcons() {
        return this.icons;
    }

    public Map<Locale, LocaleSpec> getLocales() {
        return this.locales;
    }

    public Map<String, LinkSpec> getLinks() {
        return this.links;
    }

    public OAuthSpec getOAuthSpec() {
        return this.oauth;
    }

    public Multimap<String, Node> getExtraElements() {
        return this.extraElements;
    }

    public boolean needsUserPrefSubstitution() {
        return this.needsUserPrefSubstitution;
    }

    public LocaleSpec getLocale(Locale locale) {
        return this.locales.get(locale);
    }

    public ModulePrefs substitute(Substitutions substituter) {
        return new ModulePrefs(this, substituter);
    }

    private static void walk(Element element, Set<ElementVisitor> visitors) throws SpecParserException {
        NodeList children = element.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (!(child instanceof Element)) continue;
            for (ElementVisitor ev : visitors) {
                if (ev.visit(tagName, (Element)child)) break;
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<ModulePrefs");
        for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
            buf.append(' ').append(attr.getKey()).append("=\"").append(attr.getValue()).append('\"');
        }
        buf.append(">\n");
        Joiner j = Joiner.on((String)"\n");
        j.appendTo(buf, this.preloads);
        j.appendTo(buf, this.features.values());
        j.appendTo(buf, this.icons);
        j.appendTo(buf, this.locales.values());
        j.appendTo(buf, this.links.values());
        if (this.oauth != null) {
            buf.append(this.oauth).append('\n');
        }
        if (this.extraElements != null) {
            for (Node node : this.extraElements.values()) {
                DOMSource source = new DOMSource(node);
                StringWriter sw = new StringWriter();
                StreamResult result = new StreamResult(sw);
                try {
                    Transformer xformer = TransformerFactory.newInstance().newTransformer();
                    xformer.setOutputProperty("omit-xml-declaration", "yes");
                    xformer.transform(source, result);
                }
                catch (TransformerConfigurationException e) {
                }
                catch (TransformerException e) {
                    // empty catch block
                }
                buf.append(sw.toString());
            }
        }
        buf.append("</ModulePrefs>");
        return buf.toString();
    }

    static boolean prefsNeedsUserPrefSubstitution(ModulePrefs prefs) {
        for (Preload preload : prefs.preloads) {
            if (!preload.getHref().toString().contains(UP_SUBST_PREFIX)) continue;
            return true;
        }
        return prefs.getTitle().contains(UP_SUBST_PREFIX) || prefs.getTitleUrl().toString().contains(UP_SUBST_PREFIX);
    }

    private static class ExtraElementsVisitor
    implements ElementVisitor {
        private Multimap<String, Node> elements = ArrayListMultimap.create();

        private ExtraElementsVisitor() {
        }

        @Override
        public boolean visit(String tag, Element element) throws SpecParserException {
            this.elements.put((Object)tag, (Object)element.cloneNode(true));
            return true;
        }

        @Override
        public void apply(ModulePrefs moduleprefs) {
            moduleprefs.extraElements = (Multimap)ImmutableMultimap.copyOf(this.elements);
        }
    }

    private class LinkVisitor
    implements ElementVisitor {
        private final Map<String, LinkSpec> linkMap = Maps.newHashMap();

        private LinkVisitor() {
        }

        @Override
        public boolean visit(String tag, Element element) throws SpecParserException {
            if (!"Link".equals(tag)) {
                return false;
            }
            LinkSpec link = new LinkSpec(element, ModulePrefs.this.base);
            this.linkMap.put(link.getRel(), link);
            return true;
        }

        @Override
        public void apply(ModulePrefs moduleprefs) {
            moduleprefs.links = (Map)ImmutableMap.copyOf(this.linkMap);
        }
    }

    private class LocaleVisitor
    implements ElementVisitor {
        private final Map<Locale, LocaleSpec> localeMap = Maps.newHashMap();

        private LocaleVisitor() {
        }

        @Override
        public boolean visit(String tag, Element element) throws SpecParserException {
            if (!"Locale".equals(tag)) {
                return false;
            }
            LocaleSpec locale = new LocaleSpec(element, ModulePrefs.this.base);
            this.localeMap.put(new Locale(locale.getLanguage(), locale.getCountry()), locale);
            return true;
        }

        @Override
        public void apply(ModulePrefs moduleprefs) {
            moduleprefs.locales = (Map)ImmutableMap.copyOf(this.localeMap);
        }
    }

    private static class IconVisitor
    implements ElementVisitor {
        private final List<Icon> icons = Lists.newLinkedList();

        private IconVisitor() {
        }

        @Override
        public boolean visit(String tag, Element element) throws SpecParserException {
            if (!"Icon".equals(tag)) {
                return false;
            }
            this.icons.add(new Icon(element));
            return true;
        }

        @Override
        public void apply(ModulePrefs moduleprefs) {
            moduleprefs.icons = (List)ImmutableList.copyOf(this.icons);
        }
    }

    private static class FeatureVisitor
    implements ElementVisitor {
        private final Map<String, Feature> features = Maps.newHashMap();
        private final MutableBoolean oauthMarker;
        private boolean coreIncluded = false;
        private static final Set<String> tags = ImmutableSet.of((Object)"Require", (Object)"Optional");

        private FeatureVisitor(MutableBoolean oauthMarker) {
            this.oauthMarker = oauthMarker;
        }

        @Override
        public boolean visit(String tag, Element element) throws SpecParserException {
            if (!tags.contains(tag)) {
                return false;
            }
            Feature feature = new Feature(element);
            this.coreIncluded = this.coreIncluded || feature.getName().startsWith("core");
            this.features.put(feature.getName(), feature);
            return true;
        }

        @Override
        public void apply(ModulePrefs moduleprefs) {
            if (!this.coreIncluded) {
                this.features.put(Feature.CORE_FEATURE.getName(), Feature.CORE_FEATURE);
            }
            if (this.oauthMarker.booleanValue()) {
                this.features.put(Feature.SECURITY_TOKEN_FEATURE.getName(), Feature.SECURITY_TOKEN_FEATURE);
            }
            moduleprefs.features = (Map)ImmutableMap.copyOf(this.features);
        }
    }

    private class OAuthVisitor
    implements ElementVisitor {
        private OAuthSpec oauthSpec = null;
        private final MutableBoolean oauthMarker;

        private OAuthVisitor(MutableBoolean oauthMarker) {
            this.oauthMarker = oauthMarker;
        }

        @Override
        public boolean visit(String tag, Element element) throws SpecParserException {
            if (!"OAuth".equals(tag)) {
                return false;
            }
            if (this.oauthSpec != null) {
                throw new SpecParserException("ModulePrefs/OAuth may only occur once.");
            }
            this.oauthSpec = new OAuthSpec(element, ModulePrefs.this.base);
            this.oauthMarker.setValue(true);
            return true;
        }

        @Override
        public void apply(ModulePrefs moduleprefs) {
            moduleprefs.oauth = this.oauthSpec;
        }
    }

    private class PreloadVisitor
    implements ElementVisitor {
        private final List<Preload> preloaded = Lists.newLinkedList();

        private PreloadVisitor() {
        }

        @Override
        public boolean visit(String tag, Element element) throws SpecParserException {
            if (!"Preload".equals(tag)) {
                return false;
            }
            Preload preload = new Preload(element, ModulePrefs.this.base);
            this.preloaded.add(preload);
            return true;
        }

        @Override
        public void apply(ModulePrefs moduleprefs) {
            moduleprefs.preloads = (List)ImmutableList.copyOf(this.preloaded);
        }
    }

    static interface ElementVisitor {
        public boolean visit(String var1, Element var2) throws SpecParserException;

        public void apply(ModulePrefs var1);
    }
}

