/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.F2;
import fj.Function;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.P4;
import fj.P5;
import fj.P6;
import fj.P7;
import fj.P8;
import fj.data.Array;
import fj.data.Either;
import fj.data.LazyString;
import fj.data.List;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Set;
import fj.data.Stream;
import fj.data.Tree;
import fj.data.Validation;
import fj.data.hlist.HList;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;
import fj.data.vector.V5;
import fj.data.vector.V6;
import fj.data.vector.V7;
import fj.data.vector.V8;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Equal<A> {
    private final F<A, F<A, Boolean>> f;
    public static final Equal<Boolean> booleanEqual = Equal.anyEqual();
    public static final Equal<Byte> byteEqual = Equal.anyEqual();
    public static final Equal<Character> charEqual = Equal.anyEqual();
    public static final Equal<Double> doubleEqual = Equal.anyEqual();
    public static final Equal<Float> floatEqual = Equal.anyEqual();
    public static final Equal<Integer> intEqual = Equal.anyEqual();
    public static final Equal<BigInteger> bigintEqual = Equal.anyEqual();
    public static final Equal<BigDecimal> bigdecimalEqual = Equal.anyEqual();
    public static final Equal<Long> longEqual = Equal.anyEqual();
    public static final Equal<Short> shortEqual = Equal.anyEqual();
    public static final Equal<String> stringEqual = Equal.anyEqual();
    public static final Equal<StringBuffer> stringBufferEqual = new Equal<StringBuffer>(new F<StringBuffer, F<StringBuffer, Boolean>>(){

        @Override
        public F<StringBuffer, Boolean> f(final StringBuffer stringBuffer) {
            return new F<StringBuffer, Boolean>(){

                @Override
                public Boolean f(StringBuffer stringBuffer2) {
                    if (stringBuffer.length() == stringBuffer2.length()) {
                        for (int i = 0; i < stringBuffer.length(); ++i) {
                            if (stringBuffer.charAt(i) == stringBuffer2.charAt(i)) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
    });
    public static final Equal<StringBuilder> stringBuilderEqual = new Equal<StringBuilder>(new F<StringBuilder, F<StringBuilder, Boolean>>(){

        @Override
        public F<StringBuilder, Boolean> f(final StringBuilder stringBuilder) {
            return new F<StringBuilder, Boolean>(){

                @Override
                public Boolean f(StringBuilder stringBuilder2) {
                    if (stringBuilder.length() == stringBuilder2.length()) {
                        for (int i = 0; i < stringBuilder.length(); ++i) {
                            if (stringBuilder.charAt(i) == stringBuilder2.charAt(i)) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
    });
    public static final Equal<LazyString> eq = Equal.streamEqual(charEqual).comap(LazyString.toStream);
    public static final Equal<HList.HNil> hListEqual = Equal.anyEqual();

    private Equal(F<A, F<A, Boolean>> f) {
        this.f = f;
    }

    public boolean eq(A a, A a2) {
        return this.f.f(a).f(a2);
    }

    public F2<A, A, Boolean> eq() {
        return new F2<A, A, Boolean>(){

            @Override
            public Boolean f(A a, A a2) {
                return Equal.this.eq(a, a2);
            }
        };
    }

    public F<A, Boolean> eq(final A a) {
        return new F<A, Boolean>(){

            @Override
            public Boolean f(A a2) {
                return Equal.this.eq(a, a2);
            }
        };
    }

    public <B> Equal<B> comap(F<B, A> f) {
        return Equal.equal(f.andThen().o(this.f).o(f));
    }

    public static <A> Equal<A> equal(F<A, F<A, Boolean>> f) {
        return new Equal<A>(f);
    }

    public static <A> Equal<A> anyEqual() {
        return new Equal<A>(new F<A, F<A, Boolean>>(){

            @Override
            public F<A, Boolean> f(final A a) {
                return new F<A, Boolean>(){

                    @Override
                    public Boolean f(A a2) {
                        return a.equals(a2);
                    }
                };
            }
        });
    }

    public static <A, B> Equal<Either<A, B>> eitherEqual(final Equal<A> equal, final Equal<B> equal2) {
        return new Equal<Either<A, B>>(new F<Either<A, B>, F<Either<A, B>, Boolean>>(){

            @Override
            public F<Either<A, B>, Boolean> f(final Either<A, B> either) {
                return new F<Either<A, B>, Boolean>(){

                    @Override
                    public Boolean f(Either<A, B> either2) {
                        return either.isLeft() && either2.isLeft() && (Boolean)((F)equal.f.f(either.left().value())).f(either2.left().value()) != false || either.isRight() && either2.isRight() && (Boolean)((F)equal2.f.f(either.right().value())).f(either2.right().value()) != false;
                    }
                };
            }
        });
    }

    public static <A, B> Equal<Validation<A, B>> validationEqual(Equal<A> equal, Equal<B> equal2) {
        return Equal.eitherEqual(equal, equal2).comap(Validation.either());
    }

    public static <A> Equal<List<A>> listEqual(final Equal<A> equal) {
        return new Equal<List<A>>(new F<List<A>, F<List<A>, Boolean>>(){

            @Override
            public F<List<A>, Boolean> f(final List<A> list) {
                return new F<List<A>, Boolean>(){

                    @Override
                    public Boolean f(List<A> list4) {
                        List list2 = list;
                        List list3 = list4;
                        while (list2.isNotEmpty() && list3.isNotEmpty()) {
                            if (!equal.eq(list2.head(), list3.head())) {
                                return false;
                            }
                            list2 = list2.tail();
                            list3 = list3.tail();
                        }
                        return list2.isEmpty() && list3.isEmpty();
                    }
                };
            }
        });
    }

    public static <A> Equal<NonEmptyList<A>> nonEmptyListEqual(Equal<A> equal) {
        return Equal.listEqual(equal).comap(NonEmptyList.toList_());
    }

    public static <A> Equal<Option<A>> optionEqual(final Equal<A> equal) {
        return new Equal<Option<A>>(new F<Option<A>, F<Option<A>, Boolean>>(){

            @Override
            public F<Option<A>, Boolean> f(final Option<A> option) {
                return new F<Option<A>, Boolean>(){

                    @Override
                    public Boolean f(Option<A> option2) {
                        return option.isNone() && option2.isNone() || option.isSome() && option2.isSome() && (Boolean)((F)equal.f.f(option.some())).f(option2.some()) != false;
                    }
                };
            }
        });
    }

    public static <A> Equal<Stream<A>> streamEqual(final Equal<A> equal) {
        return new Equal<Stream<A>>(new F<Stream<A>, F<Stream<A>, Boolean>>(){

            @Override
            public F<Stream<A>, Boolean> f(final Stream<A> stream) {
                return new F<Stream<A>, Boolean>(){

                    @Override
                    public Boolean f(Stream<A> stream4) {
                        Stream stream2 = stream;
                        Stream stream3 = stream4;
                        while (stream2.isNotEmpty() && stream3.isNotEmpty()) {
                            if (!equal.eq(stream2.head(), stream3.head())) {
                                return false;
                            }
                            stream2 = stream2.tail()._1();
                            stream3 = stream3.tail()._1();
                        }
                        return stream2.isEmpty() && stream3.isEmpty();
                    }
                };
            }
        });
    }

    public static <A> Equal<Array<A>> arrayEqual(final Equal<A> equal) {
        return new Equal<Array<A>>(new F<Array<A>, F<Array<A>, Boolean>>(){

            @Override
            public F<Array<A>, Boolean> f(final Array<A> array) {
                return new F<Array<A>, Boolean>(){

                    @Override
                    public Boolean f(Array<A> array2) {
                        if (array.length() == array2.length()) {
                            for (int i = 0; i < array.length(); ++i) {
                                if (equal.eq(array.get(i), array2.get(i))) continue;
                                return false;
                            }
                            return true;
                        }
                        return false;
                    }
                };
            }
        });
    }

    public static <A> Equal<Tree<A>> treeEqual(final Equal<A> equal) {
        return new Equal<Tree<A>>(Function.curry(new F2<Tree<A>, Tree<A>, Boolean>(){

            @Override
            public Boolean f(Tree<A> tree, Tree<A> tree2) {
                return equal.eq(tree.root(), tree2.root()) && Equal.p1Equal(Equal.streamEqual(Equal.treeEqual(equal))).eq(tree2.subForest(), tree.subForest());
            }
        }));
    }

    public static <A> Equal<P1<A>> p1Equal(final Equal<A> equal) {
        return new Equal<P1<A>>(new F<P1<A>, F<P1<A>, Boolean>>(){

            @Override
            public F<P1<A>, Boolean> f(final P1<A> p1) {
                return new F<P1<A>, Boolean>(){

                    @Override
                    public Boolean f(P1<A> p12) {
                        return equal.eq(p1._1(), p12._1());
                    }
                };
            }
        });
    }

    public static <A, B> Equal<P2<A, B>> p2Equal(final Equal<A> equal, final Equal<B> equal2) {
        return new Equal<P2<A, B>>(new F<P2<A, B>, F<P2<A, B>, Boolean>>(){

            @Override
            public F<P2<A, B>, Boolean> f(final P2<A, B> p2) {
                return new F<P2<A, B>, Boolean>(){

                    @Override
                    public Boolean f(P2<A, B> p22) {
                        return equal.eq(p2._1(), p22._1()) && equal2.eq(p2._2(), p22._2());
                    }
                };
            }
        });
    }

    public static <A, B, C> Equal<P3<A, B, C>> p3Equal(final Equal<A> equal, final Equal<B> equal2, final Equal<C> equal3) {
        return new Equal<P3<A, B, C>>(new F<P3<A, B, C>, F<P3<A, B, C>, Boolean>>(){

            @Override
            public F<P3<A, B, C>, Boolean> f(final P3<A, B, C> p3) {
                return new F<P3<A, B, C>, Boolean>(){

                    @Override
                    public Boolean f(P3<A, B, C> p32) {
                        return equal.eq(p3._1(), p32._1()) && equal2.eq(p3._2(), p32._2()) && equal3.eq(p3._3(), p32._3());
                    }
                };
            }
        });
    }

    public static <A, B, C, D> Equal<P4<A, B, C, D>> p4Equal(final Equal<A> equal, final Equal<B> equal2, final Equal<C> equal3, final Equal<D> equal4) {
        return new Equal<P4<A, B, C, D>>(new F<P4<A, B, C, D>, F<P4<A, B, C, D>, Boolean>>(){

            @Override
            public F<P4<A, B, C, D>, Boolean> f(final P4<A, B, C, D> p4) {
                return new F<P4<A, B, C, D>, Boolean>(){

                    @Override
                    public Boolean f(P4<A, B, C, D> p42) {
                        return equal.eq(p4._1(), p42._1()) && equal2.eq(p4._2(), p42._2()) && equal3.eq(p4._3(), p42._3()) && equal4.eq(p4._4(), p42._4());
                    }
                };
            }
        });
    }

    public static <A, B, C, D, E> Equal<P5<A, B, C, D, E>> p5Equal(final Equal<A> equal, final Equal<B> equal2, final Equal<C> equal3, final Equal<D> equal4, final Equal<E> equal5) {
        return new Equal<P5<A, B, C, D, E>>(new F<P5<A, B, C, D, E>, F<P5<A, B, C, D, E>, Boolean>>(){

            @Override
            public F<P5<A, B, C, D, E>, Boolean> f(final P5<A, B, C, D, E> p5) {
                return new F<P5<A, B, C, D, E>, Boolean>(){

                    @Override
                    public Boolean f(P5<A, B, C, D, E> p52) {
                        return equal.eq(p5._1(), p52._1()) && equal2.eq(p5._2(), p52._2()) && equal3.eq(p5._3(), p52._3()) && equal4.eq(p5._4(), p52._4()) && equal5.eq(p5._5(), p52._5());
                    }
                };
            }
        });
    }

    public static <A, B, C, D, E, F$> Equal<P6<A, B, C, D, E, F$>> p6Equal(final Equal<A> equal, final Equal<B> equal2, final Equal<C> equal3, final Equal<D> equal4, final Equal<E> equal5, final Equal<F$> equal6) {
        return new Equal<P6<A, B, C, D, E, F$>>(new F<P6<A, B, C, D, E, F$>, F<P6<A, B, C, D, E, F$>, Boolean>>(){

            @Override
            public F<P6<A, B, C, D, E, F$>, Boolean> f(final P6<A, B, C, D, E, F$> p6) {
                return new F<P6<A, B, C, D, E, F$>, Boolean>(){

                    @Override
                    public Boolean f(P6<A, B, C, D, E, F$> p62) {
                        return equal.eq(p6._1(), p62._1()) && equal2.eq(p6._2(), p62._2()) && equal3.eq(p6._3(), p62._3()) && equal4.eq(p6._4(), p62._4()) && equal5.eq(p6._5(), p62._5()) && equal6.eq(p6._6(), p62._6());
                    }
                };
            }
        });
    }

    public static <A, B, C, D, E, F$, G> Equal<P7<A, B, C, D, E, F$, G>> p7Equal(final Equal<A> equal, final Equal<B> equal2, final Equal<C> equal3, final Equal<D> equal4, final Equal<E> equal5, final Equal<F$> equal6, final Equal<G> equal7) {
        return new Equal<P7<A, B, C, D, E, F$, G>>(new F<P7<A, B, C, D, E, F$, G>, F<P7<A, B, C, D, E, F$, G>, Boolean>>(){

            @Override
            public F<P7<A, B, C, D, E, F$, G>, Boolean> f(final P7<A, B, C, D, E, F$, G> p7) {
                return new F<P7<A, B, C, D, E, F$, G>, Boolean>(){

                    @Override
                    public Boolean f(P7<A, B, C, D, E, F$, G> p72) {
                        return equal.eq(p7._1(), p72._1()) && equal2.eq(p7._2(), p72._2()) && equal3.eq(p7._3(), p72._3()) && equal4.eq(p7._4(), p72._4()) && equal5.eq(p7._5(), p72._5()) && equal6.eq(p7._6(), p72._6()) && equal7.eq(p7._7(), p72._7());
                    }
                };
            }
        });
    }

    public static <A, B, C, D, E, F$, G, H> Equal<P8<A, B, C, D, E, F$, G, H>> p8Equal(final Equal<A> equal, final Equal<B> equal2, final Equal<C> equal3, final Equal<D> equal4, final Equal<E> equal5, final Equal<F$> equal6, final Equal<G> equal7, final Equal<H> equal8) {
        return new Equal<P8<A, B, C, D, E, F$, G, H>>(new F<P8<A, B, C, D, E, F$, G, H>, F<P8<A, B, C, D, E, F$, G, H>, Boolean>>(){

            @Override
            public F<P8<A, B, C, D, E, F$, G, H>, Boolean> f(final P8<A, B, C, D, E, F$, G, H> p8) {
                return new F<P8<A, B, C, D, E, F$, G, H>, Boolean>(){

                    @Override
                    public Boolean f(P8<A, B, C, D, E, F$, G, H> p82) {
                        return equal.eq(p8._1(), p82._1()) && equal2.eq(p8._2(), p82._2()) && equal3.eq(p8._3(), p82._3()) && equal4.eq(p8._4(), p82._4()) && equal5.eq(p8._5(), p82._5()) && equal6.eq(p8._6(), p82._6()) && equal7.eq(p8._7(), p82._7()) && equal8.eq(p8._8(), p82._8());
                    }
                };
            }
        });
    }

    public static <A> Equal<V2<A>> v2Equal(Equal<A> equal) {
        return Equal.streamEqual(equal).comap(V2.toStream_());
    }

    public static <A> Equal<V3<A>> v3Equal(Equal<A> equal) {
        return Equal.streamEqual(equal).comap(V3.toStream_());
    }

    public static <A> Equal<V4<A>> v4Equal(Equal<A> equal) {
        return Equal.streamEqual(equal).comap(V4.toStream_());
    }

    public static <A> Equal<V5<A>> v5Equal(Equal<A> equal) {
        return Equal.streamEqual(equal).comap(V5.toStream_());
    }

    public static <A> Equal<V6<A>> v6Equal(Equal<A> equal) {
        return Equal.streamEqual(equal).comap(V6.toStream_());
    }

    public static <A> Equal<V7<A>> v7Equal(Equal<A> equal) {
        return Equal.streamEqual(equal).comap(V7.toStream_());
    }

    public static <A> Equal<V8<A>> v8Equal(Equal<A> equal) {
        return Equal.streamEqual(equal).comap(V8.toStream_());
    }

    public static <E, L extends HList<L>> Equal<HList.HCons<E, L>> hListEqual(final Equal<E> equal, final Equal<L> equal2) {
        return Equal.equal(Function.curry(new F2<HList.HCons<E, L>, HList.HCons<E, L>, Boolean>(){

            @Override
            public Boolean f(HList.HCons<E, L> hCons, HList.HCons<E, L> hCons2) {
                return equal.eq(hCons.head(), hCons2.head()) && equal2.eq(hCons.tail(), hCons2.tail());
            }
        }));
    }

    public static <A> Equal<Set<A>> setEqual(final Equal<A> equal) {
        return Equal.equal(Function.curry(new F2<Set<A>, Set<A>, Boolean>(){

            @Override
            public Boolean f(Set<A> set, Set<A> set2) {
                return Equal.streamEqual(equal).eq(set.toStream(), set2.toStream());
            }
        }));
    }
}

