/*
 * Decompiled with CFR 0.152.
 */
package fj.control.db;

import fj.F;
import fj.Function;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DB<A> {
    public abstract A run(Connection var1) throws SQLException;

    public static <A> DB<A> db(final F<Connection, A> f) {
        return new DB<A>(){

            @Override
            public A run(Connection connection) {
                return f.f(connection);
            }
        };
    }

    public final F<Connection, Callable<A>> asFunction() {
        return new F<Connection, Callable<A>>(){

            @Override
            public Callable<A> f(final Connection connection) {
                return new Callable<A>(){

                    @Override
                    public A call() throws Exception {
                        return DB.this.run(connection);
                    }
                };
            }
        };
    }

    public final <B> DB<B> map(final F<A, B> f) {
        return new DB<B>(){

            @Override
            public B run(Connection connection) throws SQLException {
                return f.f(DB.this.run(connection));
            }
        };
    }

    public static <A, B> F<DB<A>, DB<B>> liftM(final F<A, B> f) {
        return new F<DB<A>, DB<B>>(){

            @Override
            public DB<B> f(DB<A> dB) {
                return dB.map(f);
            }
        };
    }

    public static <A> DB<A> unit(final A a) {
        return new DB<A>(){

            @Override
            public A run(Connection connection) {
                return a;
            }
        };
    }

    public final <B> DB<B> bind(final F<A, DB<B>> f) {
        return new DB<B>(){

            @Override
            public B run(Connection connection) throws SQLException {
                return ((DB)f.f(DB.this.run(connection))).run(connection);
            }
        };
    }

    public static <A> DB<A> join(DB<DB<A>> dB) {
        return dB.bind(Function.identity());
    }
}

