/*
 * Decompiled with CFR 0.152.
 */
package fj.control.db;

import fj.Unit;
import fj.control.db.Connector;
import fj.control.db.DB;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DbState {
    private final Connector pc;
    private final DB<Unit> terminal;
    private static final DB<Unit> rollback = new DB<Unit>(){

        @Override
        public Unit run(Connection connection) throws SQLException {
            connection.rollback();
            return Unit.unit();
        }
    };
    private static final DB<Unit> commit = new DB<Unit>(){

        @Override
        public Unit run(Connection connection) throws SQLException {
            connection.commit();
            return Unit.unit();
        }
    };

    private DbState(Connector connector, DB<Unit> dB) {
        this.pc = connector;
        this.terminal = dB;
    }

    public static Connector driverManager(final String string) {
        return new Connector(){

            public Connection connect() throws SQLException {
                return DriverManager.getConnection(string);
            }
        };
    }

    public static DbState reader(String string) {
        return new DbState(DbState.driverManager(string), rollback);
    }

    public static DbState writer(String string) {
        return new DbState(DbState.driverManager(string), commit);
    }

    public static DbState reader(Connector connector) {
        return new DbState(connector, rollback);
    }

    public static DbState writer(Connector connector) {
        return new DbState(connector, commit);
    }

    public <A> A run(DB<A> dB) throws SQLException {
        Connection connection = this.pc.connect();
        connection.setAutoCommit(false);
        try {
            A a = dB.run(connection);
            this.terminal.run(connection);
            A a2 = a;
            return a2;
        }
        catch (SQLException sQLException) {
            connection.rollback();
            throw sQLException;
        }
        finally {
            connection.close();
        }
    }
}

