/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Effect;
import fj.F;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Unit;
import fj.data.Either;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Array<A>
implements Iterable<A> {
    private final Object[] a;

    private Array(Object[] objectArray) {
        this.a = objectArray;
    }

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public A get(int n) {
        return (A)this.a[n];
    }

    public Unit set(int n, A a) {
        this.a[n] = a;
        return Unit.unit();
    }

    public int length() {
        return this.a.length;
    }

    public ImmutableProjection<A> immutable() {
        return new ImmutableProjection(this);
    }

    public boolean isEmpty() {
        return this.a.length == 0;
    }

    public boolean isNotEmpty() {
        return this.a.length != 0;
    }

    public A[] array(Class<A[]> clazz) {
        return Array.copyOf(this.a, this.a.length, clazz);
    }

    public Object[] array() {
        return Array.copyOf(this.a, this.a.length);
    }

    public Option<A> toOption() {
        return this.a.length == 0 ? Option.none() : Option.some(this.a[0]);
    }

    public <X> Either<X, A> toEither(P1<X> p1) {
        return this.a.length == 0 ? Either.left(p1._1()) : Either.right(this.a[0]);
    }

    public List<A> toList() {
        List<Object> list = List.nil();
        for (int i = this.a.length - 1; i >= 0; --i) {
            list = list.cons(this.a[i]);
        }
        return list;
    }

    public Stream<A> toStream() {
        return Stream.unfold(new F<Integer, Option<P2<A, Integer>>>(){

            @Override
            public Option<P2<A, Integer>> f(Integer n) {
                return Array.this.a.length > n ? Option.some(P.p(Array.this.a[n], n + 1)) : Option.none();
            }
        }, 0);
    }

    public <B> Array<B> map(F<A, B> f) {
        Object[] objectArray = new Object[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            objectArray[i] = f.f(this.a[i]);
        }
        return new Array<A>(objectArray);
    }

    public Array<A> filter(F<A, Boolean> f) {
        List<Object> list = List.nil();
        for (int i = this.a.length - 1; i >= 0; --i) {
            if (!f.f(this.a[i]).booleanValue()) continue;
            list = list.cons(this.a[i]);
        }
        return list.toArray();
    }

    public Unit foreach(F<A, Unit> f) {
        for (Object object : this.a) {
            f.f(object);
        }
        return Unit.unit();
    }

    public void foreach(Effect<A> effect) {
        for (Object object : this.a) {
            effect.e(object);
        }
    }

    public <B> B foldRight(F<A, F<B, B>> f, B b) {
        B b2 = b;
        for (int i = this.a.length - 1; i >= 0; --i) {
            b2 = f.f(this.a[i]).f(b2);
        }
        return b2;
    }

    public <B> B foldRight(F2<A, B, B> f2, B b) {
        return this.foldRight(Function.curry(f2), b);
    }

    public <B> B foldLeft(F<B, F<A, B>> f, B b) {
        B b2 = b;
        for (Object object : this.a) {
            b2 = f.f(b2).f(object);
        }
        return b2;
    }

    public <B> B foldLeft(F2<B, A, B> f2, B b) {
        return this.foldLeft(Function.curry(f2), b);
    }

    public <B> Array<B> bind(F<A, Array<B>> f) {
        List<Array<B>> list = List.nil();
        int n = 0;
        for (int i = this.a.length - 1; i >= 0; --i) {
            Array<B> array = f.f(this.a[i]);
            n += array.length();
            list = list.cons(array);
        }
        final Object[] objectArray = new Object[n];
        list.foreach(new F<Array<B>, Unit>(){
            private int i;

            @Override
            public Unit f(Array<B> array) {
                System.arraycopy(array.a, 0, objectArray, this.i, array.a.length);
                this.i += array.a.length;
                return Unit.unit();
            }
        });
        return new Array<A>(objectArray);
    }

    public <B> Array<B> sequence(Array<B> array) {
        F f = Function.constant(array);
        return this.bind(f);
    }

    public <B, C> Array<C> bind(Array<B> array, F<A, F<B, C>> f) {
        return array.apply(this.map(f));
    }

    public <B, C> Array<C> bind(Array<B> array, F2<A, B, C> f2) {
        return this.bind(array, Function.curry(f2));
    }

    public <B> Array<B> apply(Array<F<A, B>> array) {
        return array.bind(new F<F<A, B>, Array<B>>(){

            @Override
            public Array<B> f(final F<A, B> f) {
                return Array.this.map(new F<A, B>(){

                    @Override
                    public B f(A a) {
                        return f.f(a);
                    }
                });
            }
        });
    }

    public Array<A> reverse() {
        Object[] objectArray = new Object[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            objectArray[this.a.length - 1 - i] = this.a[i];
        }
        return new Array<A>(objectArray);
    }

    public Array<A> append(Array<A> array) {
        Object[] objectArray = new Object[this.a.length + array.a.length];
        System.arraycopy(this.a, 0, objectArray, 0, this.a.length);
        System.arraycopy(array.a, 0, objectArray, this.a.length, array.a.length);
        return new Array<A>(objectArray);
    }

    public static <A> Array<A> empty() {
        return new Array<A>(new Object[0]);
    }

    public static <A> Array<A> array(A ... AArray) {
        return new Array<A>(AArray);
    }

    static <A> Array<A> mkArray(Object[] objectArray) {
        return new Array<A>(objectArray);
    }

    public static <A> Array<A> single(A a) {
        return new Array<A>(new Object[]{a});
    }

    public static <A> F<A[], Array<A>> wrap() {
        return new F<A[], Array<A>>(){

            @Override
            public Array<A> f(A[] AArray) {
                return Array.array(AArray);
            }
        };
    }

    public static <A, B> F<F<A, B>, F<Array<A>, Array<B>>> map() {
        return Function.curry(new F2<F<A, B>, Array<A>, Array<B>>(){

            @Override
            public Array<B> f(F<A, B> f, Array<A> array) {
                return array.map(f);
            }
        });
    }

    public static <A> Array<A> join(Array<Array<A>> array) {
        F f = Function.identity();
        return array.bind(f);
    }

    public static <A> F<Array<Array<A>>, Array<A>> join() {
        return new F<Array<Array<A>>, Array<A>>(){

            @Override
            public Array<A> f(Array<Array<A>> array) {
                return Array.join(array);
            }
        };
    }

    public boolean forall(F<A, Boolean> f) {
        for (Object object : this.a) {
            if (f.f(object).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean exists(F<A, Boolean> f) {
        for (Object object : this.a) {
            if (!f.f(object).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Option<A> find(F<A, Boolean> f) {
        for (Object object : this.a) {
            if (!f.f(object).booleanValue()) continue;
            return Option.some(object);
        }
        return Option.none();
    }

    public static Array<Integer> range(int n, int n2) {
        if (n >= n2) {
            return Array.empty();
        }
        Array<Integer> array = new Array<Integer>(new Integer[n2 - n]);
        for (int i = n; i < n2; ++i) {
            array.set(i - n, i);
        }
        return array;
    }

    public <B, C> Array<C> zipWith(Array<B> array, F<A, F<B, C>> f) {
        int n = Math.min(this.a.length, array.length());
        Array<C> array2 = new Array<C>(new Object[n]);
        for (int i = 0; i < n; ++i) {
            array2.set(i, f.f(this.get(i)).f(array.get(i)));
        }
        return array2;
    }

    public <B, C> Array<C> zipWith(Array<B> array, F2<A, B, C> f2) {
        return this.zipWith(array, Function.curry(f2));
    }

    public <B> Array<P2<A, B>> zip(Array<B> array) {
        F f = P.p2();
        return this.zipWith(array, f);
    }

    public Array<P2<A, Integer>> zipIndex() {
        return this.zipWith(Array.range(0, this.length()), new F<A, F<Integer, P2<A, Integer>>>(){

            @Override
            public F<Integer, P2<A, Integer>> f(final A a) {
                return new F<Integer, P2<A, Integer>>(){

                    @Override
                    public P2<A, Integer> f(Integer n) {
                        return P.p(a, n);
                    }
                };
            }
        });
    }

    public Collection<A> toCollection() {
        return new AbstractCollection<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){
                    private int i;

                    @Override
                    public boolean hasNext() {
                        return this.i < Array.this.a.length;
                    }

                    @Override
                    public A next() {
                        if (this.i >= Array.this.a.length) {
                            throw new NoSuchElementException();
                        }
                        Object object = Array.this.a[this.i];
                        ++this.i;
                        return object;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return Array.this.a.length;
            }
        };
    }

    public static <A> Array<A> iterableArray(Iterable<A> iterable) {
        return List.iterableList(iterable).toArray();
    }

    public static <A, B> P2<Array<A>, Array<B>> unzip(Array<P2<A, B>> array) {
        int n = array.length();
        Array<A> array2 = new Array<A>(new Object[n]);
        Array<B> array3 = new Array<B>(new Object[n]);
        for (int i = n - 1; i >= 0; --i) {
            P2<A, B> p2 = array.get(i);
            array2.set(i, p2._1());
            array3.set(i, p2._2());
        }
        return P.p(array2, array3);
    }

    public static <T, U> T[] copyOf(U[] UArray, int n, Class<? extends T[]> clazz) {
        Object[] objectArray = clazz == Object[].class ? new Object[n] : (Object[])java.lang.reflect.Array.newInstance(clazz.getComponentType(), n);
        System.arraycopy(UArray, 0, objectArray, 0, Math.min(UArray.length, n));
        return objectArray;
    }

    public static <T> T[] copyOf(T[] TArray, int n) {
        return Array.copyOf(TArray, n, TArray.getClass());
    }

    public static char[] copyOfRange(char[] cArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        char[] cArray2 = new char[n3];
        System.arraycopy(cArray, n, cArray2, 0, Math.min(cArray.length - n, n3));
        return cArray2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ImmutableProjection<A>
    implements Iterable<A> {
        private final Array<A> a;

        private ImmutableProjection(Array<A> array2) {
            this.a = array2;
        }

        @Override
        public Iterator<A> iterator() {
            return this.a.iterator();
        }

        public A get(int n) {
            return this.a.get(n);
        }

        public int length() {
            return this.a.length();
        }

        public boolean isEmpty() {
            return this.a.isEmpty();
        }

        public boolean isNotEmpty() {
            return this.a.isNotEmpty();
        }

        public Option<A> toOption() {
            return this.a.toOption();
        }

        public <X> Either<X, A> toEither(P1<X> p1) {
            return this.a.toEither(p1);
        }

        public List<A> toList() {
            return this.a.toList();
        }

        public Stream<A> toStream() {
            return this.a.toStream();
        }

        public <B> Array<B> map(F<A, B> f) {
            return this.a.map(f);
        }

        public Array<A> filter(F<A, Boolean> f) {
            return this.a.filter(f);
        }

        public Unit foreach(F<A, Unit> f) {
            return this.a.foreach(f);
        }

        public <B> B foldRight(F<A, F<B, B>> f, B b) {
            return this.a.foldRight(f, b);
        }

        public <B> B foldLeft(F<B, F<A, B>> f, B b) {
            return this.a.foldLeft(f, b);
        }

        public <B> Array<B> bind(F<A, Array<B>> f) {
            return this.a.bind(f);
        }

        public <B> Array<B> sequence(Array<B> array) {
            return this.a.sequence(array);
        }

        public <B> Array<B> apply(Array<F<A, B>> array) {
            return this.a.apply(array);
        }

        public Array<A> reverse() {
            return this.a.reverse();
        }

        public Array<A> append(Array<A> array) {
            return this.a.append(array);
        }

        public Collection<A> toCollection() {
            return this.a.toCollection();
        }
    }
}

