/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Ord;
import fj.Ordering;
import fj.data.Natural;
import fj.data.Option;
import fj.data.Stream;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Enumerator<A> {
    private final F<A, Option<A>> successor;
    private final F<A, Option<A>> predecessor;
    private final Option<A> max;
    private final Option<A> min;
    private final Ord<A> order;
    private final F<A, F<Long, Option<A>>> plus;
    public static final Enumerator<Boolean> booleanEnumerator = Enumerator.enumerator(new F<Boolean, Option<Boolean>>(){

        @Override
        public Option<Boolean> f(Boolean bl) {
            return bl != false ? Option.none() : Option.some(true);
        }
    }, new F<Boolean, Option<Boolean>>(){

        @Override
        public Option<Boolean> f(Boolean bl) {
            return bl != false ? Option.some(false) : Option.none();
        }
    }, Option.some(true), Option.some(false), Ord.booleanOrd);
    public static final Enumerator<Byte> byteEnumerator = Enumerator.enumerator(new F<Byte, Option<Byte>>(){

        @Override
        public Option<Byte> f(Byte by) {
            return by == 127 ? Option.none() : Option.some((byte)(by + 1));
        }
    }, new F<Byte, Option<Byte>>(){

        @Override
        public Option<Byte> f(Byte by) {
            return by == -128 ? Option.none() : Option.some((byte)(by - 1));
        }
    }, Option.some((byte)127), Option.some((byte)-128), Ord.byteOrd);
    public static final Enumerator<Character> charEnumerator = Enumerator.enumerator(new F<Character, Option<Character>>(){

        @Override
        public Option<Character> f(Character c) {
            return c.charValue() == '\uffff' ? Option.none() : Option.some(Character.valueOf((char)(c.charValue() + '\u0001')));
        }
    }, new F<Character, Option<Character>>(){

        @Override
        public Option<Character> f(Character c) {
            return c.charValue() == '\u0000' ? Option.none() : Option.some(Character.valueOf((char)(c.charValue() - '\u0001')));
        }
    }, Option.some(Character.valueOf('\uffff')), Option.some(Character.valueOf('\u0000')), Ord.charOrd);
    public static final Enumerator<Double> doubleEnumerator = Enumerator.enumerator(new F<Double, Option<Double>>(){

        @Override
        public Option<Double> f(Double d) {
            return d == Double.MAX_VALUE ? Option.none() : Option.some(d + 1.0);
        }
    }, new F<Double, Option<Double>>(){

        @Override
        public Option<Double> f(Double d) {
            return d == Double.MIN_VALUE ? Option.none() : Option.some(d - 1.0);
        }
    }, Option.some(Double.MAX_VALUE), Option.some(Double.MIN_VALUE), Ord.doubleOrd);
    public static final Enumerator<Float> floatEnumerator = Enumerator.enumerator(new F<Float, Option<Float>>(){

        @Override
        public Option<Float> f(Float f) {
            return f.floatValue() == Float.MAX_VALUE ? Option.none() : Option.some(Float.valueOf(f.floatValue() + 1.0f));
        }
    }, new F<Float, Option<Float>>(){

        @Override
        public Option<Float> f(Float f) {
            return f.floatValue() == Float.MIN_VALUE ? Option.none() : Option.some(Float.valueOf(f.floatValue() - 1.0f));
        }
    }, Option.some(Float.valueOf(Float.MAX_VALUE)), Option.some(Float.valueOf(Float.MIN_VALUE)), Ord.floatOrd);
    public static final Enumerator<Integer> intEnumerator = Enumerator.enumerator(new F<Integer, Option<Integer>>(){

        @Override
        public Option<Integer> f(Integer n) {
            return n == Integer.MAX_VALUE ? Option.none() : Option.some(n + 1);
        }
    }, new F<Integer, Option<Integer>>(){

        @Override
        public Option<Integer> f(Integer n) {
            return n == Integer.MIN_VALUE ? Option.none() : Option.some(n - 1);
        }
    }, Option.some(Integer.MAX_VALUE), Option.some(Integer.MIN_VALUE), Ord.intOrd);
    public static final Enumerator<BigInteger> bigintEnumerator = Enumerator.enumerator(new F<BigInteger, Option<BigInteger>>(){

        @Override
        public Option<BigInteger> f(BigInteger bigInteger) {
            return Option.some(bigInteger.add(BigInteger.ONE));
        }
    }, new F<BigInteger, Option<BigInteger>>(){

        @Override
        public Option<BigInteger> f(BigInteger bigInteger) {
            return Option.some(bigInteger.subtract(BigInteger.ONE));
        }
    }, Option.none(), Option.none(), Ord.bigintOrd, Function.curry(new F2<BigInteger, Long, Option<BigInteger>>(){

        @Override
        public Option<BigInteger> f(BigInteger bigInteger, Long l) {
            return Option.some(bigInteger.add(BigInteger.valueOf(l)));
        }
    }));
    public static final Enumerator<BigDecimal> bigdecimalEnumerator = Enumerator.enumerator(new F<BigDecimal, Option<BigDecimal>>(){

        @Override
        public Option<BigDecimal> f(BigDecimal bigDecimal) {
            return Option.some(bigDecimal.add(BigDecimal.ONE));
        }
    }, new F<BigDecimal, Option<BigDecimal>>(){

        @Override
        public Option<BigDecimal> f(BigDecimal bigDecimal) {
            return Option.some(bigDecimal.subtract(BigDecimal.ONE));
        }
    }, Option.none(), Option.none(), Ord.bigdecimalOrd, Function.curry(new F2<BigDecimal, Long, Option<BigDecimal>>(){

        @Override
        public Option<BigDecimal> f(BigDecimal bigDecimal, Long l) {
            return Option.some(bigDecimal.add(BigDecimal.valueOf(l)));
        }
    }));
    public static final Enumerator<Long> longEnumerator = Enumerator.enumerator(new F<Long, Option<Long>>(){

        @Override
        public Option<Long> f(Long l) {
            return l == Long.MAX_VALUE ? Option.none() : Option.some(l + 1L);
        }
    }, new F<Long, Option<Long>>(){

        @Override
        public Option<Long> f(Long l) {
            return l == Long.MIN_VALUE ? Option.none() : Option.some(l - 1L);
        }
    }, Option.some(Long.MAX_VALUE), Option.some(Long.MIN_VALUE), Ord.longOrd);
    public static final Enumerator<Short> shortEnumerator = Enumerator.enumerator(new F<Short, Option<Short>>(){

        @Override
        public Option<Short> f(Short s) {
            return s == Short.MAX_VALUE ? Option.none() : Option.some((short)(s + 1));
        }
    }, new F<Short, Option<Short>>(){

        @Override
        public Option<Short> f(Short s) {
            return s == Short.MIN_VALUE ? Option.none() : Option.some((short)(s - 1));
        }
    }, Option.some((short)Short.MAX_VALUE), Option.some((short)Short.MIN_VALUE), Ord.shortOrd);
    public static final Enumerator<Ordering> orderingEnumerator = Enumerator.enumerator(new F<Ordering, Option<Ordering>>(){

        @Override
        public Option<Ordering> f(Ordering ordering) {
            return ordering == Ordering.LT ? Option.some(Ordering.EQ) : (ordering == Ordering.EQ ? Option.some(Ordering.GT) : Option.none());
        }
    }, new F<Ordering, Option<Ordering>>(){

        @Override
        public Option<Ordering> f(Ordering ordering) {
            return ordering == Ordering.GT ? Option.some(Ordering.EQ) : (ordering == Ordering.EQ ? Option.some(Ordering.LT) : Option.none());
        }
    }, Option.some(Ordering.GT), Option.some(Ordering.LT), Ord.orderingOrd);
    public static final Enumerator<Natural> naturalEnumerator = Enumerator.enumerator(new F<Natural, Option<Natural>>(){

        @Override
        public Option<Natural> f(Natural natural) {
            return Option.some(natural.succ());
        }
    }, new F<Natural, Option<Natural>>(){

        @Override
        public Option<Natural> f(Natural natural) {
            return natural.pred();
        }
    }, Option.none(), Option.some(Natural.ZERO), Ord.naturalOrd, Function.curry(new F2<Natural, Long, Option<Natural>>(){

        @Override
        public Option<Natural> f(Natural natural, Long l) {
            return Option.some(natural).apply(Natural.natural(l).map(Function.curry(new F2<Natural, Natural, Natural>(){

                @Override
                public Natural f(Natural natural, Natural natural2) {
                    return natural.add(natural2);
                }
            })));
        }
    }));

    private Enumerator(F<A, Option<A>> f, F<A, Option<A>> f2, Option<A> option, Option<A> option2, Ord<A> ord, F<A, F<Long, Option<A>>> f3) {
        this.successor = f;
        this.predecessor = f2;
        this.max = option;
        this.min = option2;
        this.order = ord;
        this.plus = f3;
    }

    public F<A, Option<A>> successor() {
        return this.successor;
    }

    public Option<A> successor(A a) {
        return this.successor.f(a);
    }

    public F<A, Option<A>> predecessor() {
        return this.predecessor;
    }

    public Option<A> predecessor(A a) {
        return this.predecessor.f(a);
    }

    public Option<A> max() {
        return this.max;
    }

    public Option<A> min() {
        return this.min;
    }

    public F<A, F<Long, Option<A>>> plus() {
        return this.plus;
    }

    public F<Long, Option<A>> plus(A a) {
        return this.plus.f(a);
    }

    public F<A, Option<A>> plus(long l) {
        return Function.flip(this.plus).f(l);
    }

    public Option<A> plus(A a, long l) {
        return this.plus.f(a).f(l);
    }

    public Ord<A> order() {
        return this.order;
    }

    public <B> Enumerator<B> xmap(final F<A, B> f, F<B, A> f2) {
        F f3 = new F<Option<A>, Option<B>>(){

            @Override
            public Option<B> f(Option<A> option) {
                return option.map(f);
            }
        };
        return Enumerator.enumerator(Function.compose(Function.compose(f3, this.successor), f2), Function.compose(Function.compose(f3, this.predecessor), f2), this.max.map(f), this.min.map(f), this.order.comap(f2), Function.compose(Function.compose(Function.compose().f(f3), this.plus), f2));
    }

    public Stream<A> toStream(A a) {
        F f = Function.identity();
        return Stream.fromFunction(this, f, a);
    }

    public Enumerator<A> setMin(Option<A> option) {
        return Enumerator.enumerator(this.successor, this.predecessor, this.max, option, this.order, this.plus);
    }

    public Enumerator<A> setMax(Option<A> option) {
        return Enumerator.enumerator(this.successor, this.predecessor, option, this.min, this.order, this.plus);
    }

    public static <A> Enumerator<A> enumerator(F<A, Option<A>> f, F<A, Option<A>> f2, Option<A> option, Option<A> option2, Ord<A> ord, F<A, F<Long, Option<A>>> f3) {
        return new Enumerator<A>(f, f2, option, option2, ord, f3);
    }

    public static <A> Enumerator<A> enumerator(final F<A, Option<A>> f, final F<A, Option<A>> f2, Option<A> option, Option<A> option2, Ord<A> ord) {
        return new Enumerator<A>(f, f2, option, option2, ord, Function.curry(new F2<A, Long, Option<A>>(){

            @Override
            public Option<A> f(A a, Long l) {
                if (l == 0L) {
                    return Option.some(a);
                }
                if (l < 0L) {
                    Object a2 = a;
                    for (long i = l.longValue(); i < 0L; ++i) {
                        Option option = (Option)f2.f(a2);
                        if (option.isNone()) {
                            return Option.none();
                        }
                        a2 = option.some();
                    }
                    return Option.some(a2);
                }
                Object a3 = a;
                for (long i = l.longValue(); i > 0L; --i) {
                    Option option = (Option)f.f(a3);
                    if (option.isNone()) {
                        return Option.none();
                    }
                    a3 = option.some();
                }
                return Option.some(a3);
            }
        }));
    }
}

