/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Effect;
import fj.Equal;
import fj.F;
import fj.F2;
import fj.F3;
import fj.Function;
import fj.Monoid;
import fj.Ord;
import fj.Ordering;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Unit;
import fj.control.parallel.Promise;
import fj.control.parallel.Strategy;
import fj.data.Array;
import fj.data.Either;
import fj.data.Enumerator;
import fj.data.LazyString;
import fj.data.List;
import fj.data.Natural;
import fj.data.Option;
import fj.function.Booleans;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stream<A>
implements Iterable<A> {
    private Stream() {
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A head();

    public abstract P1<Stream<A>> tail();

    public final boolean isEmpty() {
        return this instanceof Nil;
    }

    public final boolean isNotEmpty() {
        return this instanceof Cons;
    }

    public final <B> B stream(B b, F<A, F<P1<Stream<A>>, B>> f) {
        return this.isEmpty() ? b : f.f(this.head()).f(this.tail());
    }

    public final <B> B foldRight(final F<A, F<P1<B>, B>> f, final B b) {
        return this.isEmpty() ? b : f.f(this.head()).f(new P1<B>(){

            @Override
            public B _1() {
                return Stream.this.tail()._1().foldRight(f, b);
            }
        });
    }

    public final <B> B foldRight(F2<A, P1<B>, B> f2, B b) {
        return this.foldRight(Function.curry(f2), b);
    }

    public final <B> B foldRight1(F<A, F<B, B>> f, B b) {
        return (B)this.foldRight(Function.compose(Function.andThen().f(P1.__1()), f), b);
    }

    public final <B> B foldRight1(F2<A, B, B> f2, B b) {
        return this.foldRight1(Function.curry(f2), b);
    }

    public final <B> B foldLeft(F<B, F<A, B>> f, B b) {
        B b2 = b;
        Stream<A> stream = this;
        while (!stream.isEmpty()) {
            b2 = f.f(b2).f(stream.head());
            stream = stream.tail()._1();
        }
        return b2;
    }

    public final <B> B foldLeft(F2<B, A, B> f2, B b) {
        return this.foldLeft(Function.curry(f2), b);
    }

    public final A foldLeft1(F2<A, A, A> f2) {
        return this.foldLeft1(Function.curry(f2));
    }

    public final A foldLeft1(F<A, F<A, A>> f) {
        if (this.isEmpty()) {
            throw Bottom.error("Undefined: foldLeft1 on empty list");
        }
        return this.tail()._1().foldLeft(f, this.head());
    }

    public final A orHead(P1<A> p1) {
        return this.isEmpty() ? p1._1() : this.head();
    }

    public final P1<Stream<A>> orTail(P1<Stream<A>> p1) {
        return this.isEmpty() ? p1 : this.tail();
    }

    public final Stream<A> intersperse(final A a) {
        return this.isEmpty() ? this : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return this.prefix(a, Stream.this.tail()._1());
            }

            public Stream<A> prefix(A a2, final Stream<A> stream) {
                return stream.isEmpty() ? stream : Stream.cons(a2, P.p(Stream.cons(stream.head(), new P1<Stream<A>>(){

                    @Override
                    public Stream<A> _1() {
                        return this.prefix(a, stream.tail()._1());
                    }
                })));
            }
        });
    }

    public final <B> Stream<B> map(final F<A, B> f) {
        return this.isEmpty() ? Stream.nil() : Stream.cons(f.f(this.head()), new P1<Stream<B>>(){

            @Override
            public Stream<B> _1() {
                return Stream.this.tail()._1().map(f);
            }
        });
    }

    public static <A, B> F<F<A, B>, F<Stream<A>, Stream<B>>> map_() {
        return new F<F<A, B>, F<Stream<A>, Stream<B>>>(){

            @Override
            public F<Stream<A>, Stream<B>> f(final F<A, B> f) {
                return new F<Stream<A>, Stream<B>>(){

                    @Override
                    public Stream<B> f(Stream<A> stream) {
                        return stream.map(f);
                    }
                };
            }
        };
    }

    public final Unit foreach(F<A, Unit> f) {
        Stream<A> stream = this;
        while (stream.isNotEmpty()) {
            f.f(stream.head());
            stream = stream.tail()._1();
        }
        return Unit.unit();
    }

    public final void foreach(Effect<A> effect) {
        Stream<A> stream = this;
        while (stream.isNotEmpty()) {
            effect.e(stream.head());
            stream = stream.tail()._1();
        }
    }

    public final Stream<A> filter(final F<A, Boolean> f) {
        final Stream<A> stream = this.dropWhile(Booleans.not(f));
        return stream.isNotEmpty() ? Stream.cons(stream.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return stream.tail()._1().filter(f);
            }
        }) : stream;
    }

    public final Stream<A> append(final Stream<A> stream) {
        return this.isEmpty() ? stream : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().append(stream);
            }
        });
    }

    public final Stream<A> append(final P1<Stream<A>> p1) {
        return this.isEmpty() ? p1._1() : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().append(p1);
            }
        });
    }

    public final Stream<A> minus(Equal<A> equal, Stream<A> stream) {
        return this.removeAll(Function.compose(Monoid.disjunctionMonoid.sumLeftS(), stream.mapM(Function.curry(equal.eq()))));
    }

    public final Stream<A> removeAll(F<A, Boolean> f) {
        return this.filter(Function.compose(Booleans.not, f));
    }

    public static <A, B> F<B, Stream<A>> sequence_(Stream<F<B, A>> stream) {
        return stream.foldRight(new F2<F<B, A>, P1<F<B, Stream<A>>>, F<B, Stream<A>>>(){

            @Override
            public F<B, Stream<A>> f(F<B, A> f, P1<F<B, Stream<A>>> p1) {
                return Function.bind(f, p1._1(), Function.curry(new F2<A, Stream<A>, Stream<A>>(){

                    @Override
                    public Stream<A> f(A a, Stream<A> stream) {
                        return Stream.cons(a, P.p(stream));
                    }
                }));
            }
        }, Function.constant(Stream.<A>nil()));
    }

    public final <B, C> F<B, Stream<C>> mapM(F<A, F<B, C>> f) {
        return Stream.sequence_(this.map(f));
    }

    public final <B> Stream<B> bind(F<A, Stream<B>> f) {
        return Stream.join(this.map(f));
    }

    public final <B, C> Stream<C> bind(Stream<B> stream, F<A, F<B, C>> f) {
        return stream.apply(this.map(f));
    }

    public final <B, C> Stream<C> bind(Stream<B> stream, F2<A, B, C> f2) {
        return this.bind(stream, Function.curry(f2));
    }

    public final <B, C, D> Stream<D> bind(Stream<B> stream, Stream<C> stream2, F<A, F<B, F<C, D>>> f) {
        return stream2.apply(this.bind(stream, f));
    }

    public final <B, C, D, E> Stream<E> bind(Stream<B> stream, Stream<C> stream2, Stream<D> stream3, F<A, F<B, F<C, F<D, E>>>> f) {
        return stream3.apply(this.bind(stream, stream2, f));
    }

    public final <B, C, D, E, F$> Stream<F$> bind(Stream<B> stream, Stream<C> stream2, Stream<D> stream3, Stream<E> stream4, F<A, F<B, F<C, F<D, F<E, F$>>>>> f) {
        return stream4.apply(this.bind(stream, stream2, stream3, f));
    }

    public final <B, C, D, E, F$, G> Stream<G> bind(Stream<B> stream, Stream<C> stream2, Stream<D> stream3, Stream<E> stream4, Stream<F$> stream5, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f) {
        return stream5.apply(this.bind(stream, stream2, stream3, stream4, f));
    }

    public final <B, C, D, E, F$, G, H> Stream<H> bind(Stream<B> stream, Stream<C> stream2, Stream<D> stream3, Stream<E> stream4, Stream<F$> stream5, Stream<G> stream6, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f) {
        return stream6.apply(this.bind(stream, stream2, stream3, stream4, stream5, f));
    }

    public final <B, C, D, E, F$, G, H, I> Stream<I> bind(Stream<B> stream, Stream<C> stream2, Stream<D> stream3, Stream<E> stream4, Stream<F$> stream5, Stream<G> stream6, Stream<H> stream7, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f) {
        return stream7.apply(this.bind(stream, stream2, stream3, stream4, stream5, stream6, f));
    }

    public final <B> Stream<B> sequence(Stream<B> stream) {
        F f = Function.constant(stream);
        return this.bind(f);
    }

    public final <B> Stream<B> apply(Stream<F<A, B>> stream) {
        return stream.bind(new F<F<A, B>, Stream<B>>(){

            @Override
            public Stream<B> f(final F<A, B> f) {
                return Stream.this.map(new F<A, B>(){

                    @Override
                    public B f(A a) {
                        return f.f(a);
                    }
                });
            }
        });
    }

    public final Stream<A> interleave(final Stream<A> stream) {
        return this.isEmpty() ? stream : (stream.isEmpty() ? this : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return stream.interleave(Stream.this.tail()._1());
            }
        }));
    }

    public final Stream<A> sort(Ord<A> ord) {
        return Stream.mergesort(ord, this.map(Function.flip(Stream.<A>cons()).f(P.p(Stream.<A>nil()))));
    }

    private static <A> Stream<A> mergesort(Ord<A> ord, Stream<Stream<A>> stream) {
        if (stream.isEmpty()) {
            return Stream.nil();
        }
        Stream<Stream<A>> stream2 = stream;
        while (stream2.tail()._1().isNotEmpty()) {
            stream2 = Stream.mergePairs(ord, stream2);
        }
        return stream2.head();
    }

    private static <A> Stream<Stream<A>> mergePairs(final Ord<A> ord, Stream<Stream<A>> stream) {
        if (stream.isEmpty() || stream.tail()._1().isEmpty()) {
            return stream;
        }
        final Stream<Stream<A>> stream2 = stream.tail()._1();
        return Stream.cons(Stream.merge(ord, stream.head(), stream2.head()), new P1<Stream<Stream<A>>>(){

            @Override
            public Stream<Stream<A>> _1() {
                return Stream.mergePairs(ord, stream2.tail()._1());
            }
        });
    }

    private static <A> Stream<A> merge(final Ord<A> ord, final Stream<A> stream, final Stream<A> stream2) {
        A a;
        if (stream.isEmpty()) {
            return stream2;
        }
        if (stream2.isEmpty()) {
            return stream;
        }
        A a2 = stream.head();
        if (ord.isGreaterThan(a2, a = stream2.head())) {
            return Stream.cons(a, new P1<Stream<A>>(){

                @Override
                public Stream<A> _1() {
                    return Stream.merge(ord, stream, stream2.tail()._1());
                }
            });
        }
        return Stream.cons(a2, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.merge(ord, stream.tail()._1(), stream2);
            }
        });
    }

    public final Stream<A> sort(Ord<A> ord, Strategy<Unit> strategy) {
        return this.qs(ord, strategy).claim();
    }

    private Promise<Stream<A>> qs(Ord<A> ord, Strategy<Unit> strategy) {
        if (this.isEmpty()) {
            return Promise.promise(strategy, P.p(this));
        }
        F<Boolean, Boolean> f = Function.identity();
        A a = this.head();
        P1<Stream<Stream<A>>> p1 = this.tail();
        Promise promise = Promise.join(strategy, p1.map(Stream.flt(ord, strategy, a, f)));
        Promise<Stream<Stream<A>>> promise2 = p1.map(Stream.flt(ord, strategy, a, Booleans.not))._1();
        Monoid<Stream<Stream<A>>> monoid = Monoid.streamMonoid();
        return promise2.fmap(monoid.sum(Stream.single(a))).apply(promise.fmap(monoid.sum()));
    }

    private static <A> F<Stream<A>, Promise<Stream<A>>> qs_(final Ord<A> ord, final Strategy<Unit> strategy) {
        return new F<Stream<A>, Promise<Stream<A>>>(){

            @Override
            public Promise<Stream<A>> f(Stream<A> stream) {
                return stream.qs(ord, strategy);
            }
        };
    }

    private static <A> F<Stream<A>, Promise<Stream<A>>> flt(Ord<A> ord, Strategy<Unit> strategy, A a, F<Boolean, Boolean> f) {
        F<F<F<A, Boolean>, Boolean>, F<Stream<F<A, Boolean>>, Stream<F<A, Boolean>>>> f2 = Stream.filter();
        F<A, Boolean> f3 = ord.isLessThan(a);
        return Function.compose(Stream.qs_(ord, strategy), f2.f(Function.compose(f, f3)));
    }

    public final Collection<A> toCollection() {
        return new AbstractCollection<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){
                    private Stream<A> xs;
                    {
                        this.xs = Stream.this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.xs.isNotEmpty();
                    }

                    @Override
                    public A next() {
                        if (this.xs.isEmpty()) {
                            throw new NoSuchElementException();
                        }
                        Object a = this.xs.head();
                        this.xs = this.xs.tail()._1();
                        return a;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return Stream.this.length();
            }
        };
    }

    public static Stream<Integer> range(final int n, final long l) {
        return (long)n >= l ? Stream.nil() : Stream.cons(n, new P1<Stream<Integer>>(){

            @Override
            public Stream<Integer> _1() {
                return Stream.range(n + 1, l);
            }
        });
    }

    public static <A> Stream<A> stream(A ... AArray) {
        return AArray.length == 0 ? Stream.nil() : Stream.unfold(P2.tuple(new F2<A[], Integer, Option<P2<A, P2<A[], Integer>>>>(){

            @Override
            public Option<P2<A, P2<A[], Integer>>> f(A[] AArray, Integer n) {
                return n >= AArray.length ? Option.none() : Option.some(P.p(AArray[n], P.p(AArray, n + 1)));
            }
        }), P.p(AArray, 0));
    }

    public static <A> Stream<A> forever(Enumerator<A> enumerator, A a) {
        return Stream.forever(enumerator, a, 1L);
    }

    public static <A> Stream<A> forever(final Enumerator<A> enumerator, final A a, final long l) {
        return Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return enumerator.plus(a, l).map(new F<A, Stream<A>>(){

                    @Override
                    public Stream<A> f(A a) {
                        return Stream.forever(enumerator, a, l);
                    }
                }).orSome(Stream.nil());
            }
        });
    }

    public static <A> Stream<A> range(Enumerator<A> enumerator, A a, A a2) {
        return Stream.range(enumerator, a, a2, 1L);
    }

    public static <A> Stream<A> range(final Enumerator<A> enumerator, final A a, final A a2, final long l) {
        final Ordering ordering = enumerator.order().compare(a, a2);
        return ordering == Ordering.EQ || l > 0L && ordering == Ordering.GT || l < 0L && ordering == Ordering.LT ? Stream.single(a) : Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.join(enumerator.plus(a, l).filter(new F<A, Boolean>(){

                    @Override
                    public Boolean f(A a) {
                        return !(ordering != Ordering.LT ? enumerator.order().isGreaterThan(a2, a) : enumerator.order().isLessThan(a2, a));
                    }
                }).map(new F<A, Stream<A>>(){

                    @Override
                    public Stream<A> f(A a) {
                        return Stream.range(enumerator, a, a2, l);
                    }
                }).toStream());
            }
        });
    }

    public static Stream<Integer> range(final int n) {
        return Stream.cons(n, new P1<Stream<Integer>>(){

            @Override
            public Stream<Integer> _1() {
                return Stream.range(n + 1);
            }
        });
    }

    public static <A> F<F<A, Boolean>, F<Stream<A>, Stream<A>>> filter() {
        return Function.curry(new F2<F<A, Boolean>, Stream<A>, Stream<A>>(){

            @Override
            public Stream<A> f(F<A, Boolean> f, Stream<A> stream) {
                return stream.filter(f);
            }
        });
    }

    public final <B> Stream<B> zapp(final Stream<F<A, B>> stream) {
        return stream.isEmpty() || this.isEmpty() ? Stream.nil() : Stream.cons(stream.head().f(this.head()), new P1<Stream<B>>(){

            @Override
            public Stream<B> _1() {
                return Stream.this.tail()._1().zapp(stream.tail()._1());
            }
        });
    }

    public final <B, C> Stream<C> zipWith(Stream<B> stream, F<A, F<B, C>> f) {
        return stream.zapp(this.zapp(Stream.repeat(f)));
    }

    public final <B, C> Stream<C> zipWith(Stream<B> stream, F2<A, B, C> f2) {
        return this.zipWith(stream, Function.curry(f2));
    }

    public final <B, C> F<Stream<B>, Stream<C>> zipWith(final F<A, F<B, C>> f) {
        return new F<Stream<B>, Stream<C>>(){

            @Override
            public Stream<C> f(Stream<B> stream) {
                return Stream.this.zipWith(stream, f);
            }
        };
    }

    public final <B> Stream<P2<A, B>> zip(Stream<B> stream) {
        F f = P.p2();
        return this.zipWith(stream, f);
    }

    public final Stream<P2<A, Integer>> zipIndex() {
        return this.zipWith(Stream.range(0), new F2<A, Integer, P2<A, Integer>>(){

            @Override
            public P2<A, Integer> f(A a, Integer n) {
                return P.p(a, n);
            }
        });
    }

    public final <X> Either<X, A> toEither(P1<X> p1) {
        return this.isEmpty() ? Either.left(p1._1()) : Either.right(this.head());
    }

    public final Option<A> toOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.head());
    }

    public final List<A> toList() {
        List<A> list = List.nil();
        Stream<A> stream = this;
        while (!stream.isEmpty()) {
            list = list.snoc(stream.head());
            stream = stream.tail()._1();
        }
        return list;
    }

    public final Array<A> toArray() {
        int n = this.length();
        Object[] objectArray = new Object[n];
        Stream<A> stream = this;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = stream.head();
            stream = stream.tail()._1();
        }
        return Array.mkArray(objectArray);
    }

    public final Array<A> toArray(Class<A[]> clazz) {
        Object[] objectArray = (Object[])java.lang.reflect.Array.newInstance(clazz.getComponentType(), this.length());
        int n = 0;
        for (A a : this) {
            objectArray[n] = a;
            ++n;
        }
        return Array.array(objectArray);
    }

    public final A[] array(Class<A[]> clazz) {
        return this.toArray(clazz).array(clazz);
    }

    public final Stream<A> cons(A a) {
        return new Cons<A>(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this;
            }
        });
    }

    public static String asString(Stream<Character> stream) {
        return LazyString.fromStream(stream).toString();
    }

    public static Stream<Character> fromString(String string) {
        return LazyString.str(string).toStream();
    }

    public final Stream<A> snoc(A a) {
        return this.snoc(P.p(a));
    }

    public final Stream<A> snoc(final P1<A> p1) {
        return this.append(new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.single(p1._1());
            }
        });
    }

    public final Stream<A> take(final int n) {
        return n <= 0 || this.isEmpty() ? Stream.nil() : Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().take(n - 1);
            }
        });
    }

    public final Stream<A> drop(int n) {
        Stream<A> stream = this;
        for (int i = 0; stream.isNotEmpty() && i < n; ++i) {
            stream = stream.tail()._1();
        }
        return stream;
    }

    public final Stream<A> takeWhile(final F<A, Boolean> f) {
        return this.isEmpty() ? this : (f.f(this.head()) != false ? Stream.cons(this.head(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.this.tail()._1().takeWhile(f);
            }
        }) : Stream.nil());
    }

    public final Stream<A> dropWhile(F<A, Boolean> f) {
        Stream<A> stream = this;
        while (!stream.isEmpty() && f.f(stream.head()).booleanValue()) {
            stream = stream.tail()._1();
        }
        return stream;
    }

    public final P2<Stream<A>, Stream<A>> span(final F<A, Boolean> f) {
        if (this.isEmpty()) {
            return P.p(this, this);
        }
        if (f.f(this.head()).booleanValue()) {
            final P1 p1 = new P1<P2<Stream<A>, Stream<A>>>(){

                @Override
                public P2<Stream<A>, Stream<A>> _1() {
                    return Stream.this.tail()._1().span(f);
                }
            };
            return new P2<Stream<A>, Stream<A>>(){

                @Override
                public Stream<A> _1() {
                    return Stream.cons(Stream.this.head(), p1.map(P2.__1()));
                }

                @Override
                public Stream<A> _2() {
                    return (Stream)((P2)p1._1())._2();
                }
            };
        }
        return P.p(Stream.<A>nil(), this);
    }

    public final Stream<A> replace(final F<A, Boolean> f, final A a) {
        if (this.isEmpty()) {
            return Stream.nil();
        }
        final P2<Stream<A>, Stream<A>> p2 = this.span(f);
        return p2._1().append(Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return ((Stream)p2._2()).tail()._1().replace(f, a);
            }
        }));
    }

    public final P2<Stream<A>, Stream<A>> split(F<A, Boolean> f) {
        return this.span(Function.compose(Booleans.not, f));
    }

    public final Stream<A> reverse() {
        return this.foldLeft(new F<Stream<A>, F<A, Stream<A>>>(){

            @Override
            public F<A, Stream<A>> f(final Stream<A> stream) {
                return new F<A, Stream<A>>(){

                    @Override
                    public Stream<A> f(A a) {
                        return Stream.cons(a, new P1<Stream<A>>(){

                            @Override
                            public Stream<A> _1() {
                                return stream;
                            }
                        });
                    }
                };
            }
        }, Stream.<A>nil());
    }

    public final A last() {
        return this.reverse().head();
    }

    public final int length() {
        return this.toList().length();
    }

    public final A index(int n) {
        if (n < 0) {
            throw Bottom.error("index " + n + " out of range on stream");
        }
        Stream<A> stream = this;
        for (int i = 0; i < n; ++i) {
            if (stream.isEmpty()) {
                throw Bottom.error("index " + n + " out of range on stream");
            }
            stream = stream.tail()._1();
        }
        if (stream.isEmpty()) {
            throw Bottom.error("index " + n + " out of range on stream");
        }
        return stream.head();
    }

    public final boolean forall(F<A, Boolean> f) {
        return this.isEmpty() || f.f(this.head()) != false && this.tail()._1().forall(f);
    }

    public final boolean exists(F<A, Boolean> f) {
        return this.dropWhile(Booleans.not(f)).isNotEmpty();
    }

    public final Option<A> find(F<A, Boolean> f) {
        Stream<A> stream = this;
        while (stream.isNotEmpty()) {
            if (f.f(stream.head()).booleanValue()) {
                return Option.some(stream.head());
            }
            stream = stream.tail()._1();
        }
        return Option.none();
    }

    public final <B> Stream<B> cobind(F<Stream<A>, B> f) {
        return this.substreams().map(f);
    }

    public final Stream<Stream<A>> tails() {
        return this.isEmpty() ? Stream.nil() : Stream.cons(this, new P1<Stream<Stream<A>>>(){

            @Override
            public Stream<Stream<A>> _1() {
                return Stream.this.tail()._1().tails();
            }
        });
    }

    public final Stream<Stream<A>> inits() {
        Stream<Stream<Stream<A>>> stream = Stream.nil();
        return this.isEmpty() ? stream : stream.append(new P1<Stream<Stream<A>>>(){

            @Override
            public Stream<Stream<A>> _1() {
                return Stream.this.tail()._1().inits().map(Stream.cons_().f(Stream.this.head()));
            }
        });
    }

    public final Stream<Stream<A>> substreams() {
        return this.tails().bind(new F<Stream<A>, Stream<Stream<A>>>(){

            @Override
            public Stream<Stream<A>> f(Stream<A> stream) {
                return stream.inits();
            }
        });
    }

    public final Option<Integer> indexOf(final F<A, Boolean> f) {
        return this.zipIndex().find(new F<P2<A, Integer>, Boolean>(){

            @Override
            public Boolean f(P2<A, Integer> p2) {
                return (Boolean)f.f(p2._1());
            }
        }).map(P2.__2());
    }

    public final <B> Stream<B> sequenceW(final Stream<F<Stream<A>, B>> stream) {
        return stream.isEmpty() ? Stream.nil() : Stream.cons(stream.head().f(this), new P1<Stream<B>>(){

            @Override
            public Stream<B> _1() {
                return Stream.this.sequenceW(stream.tail()._1());
            }
        });
    }

    public final F<Integer, A> toFunction() {
        return new F<Integer, A>(){

            @Override
            public A f(Integer n) {
                return Stream.this.index(n);
            }
        };
    }

    public static <A> Stream<A> fromFunction(F<Natural, A> f) {
        return Stream.fromFunction(Enumerator.naturalEnumerator, f, Natural.ZERO);
    }

    public static <A, B> Stream<A> fromFunction(final Enumerator<B> enumerator, final F<B, A> f, final B b) {
        return Stream.cons(f.f(b), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                Option<Object> option = enumerator.successor(b);
                return option.isSome() ? Stream.fromFunction(enumerator, f, option.some()) : Stream.nil();
            }
        });
    }

    public static <A, B> P2<Stream<A>, Stream<B>> unzip(Stream<P2<A, B>> stream) {
        return stream.foldRight(new F2<P2<A, B>, P1<P2<Stream<A>, Stream<B>>>, P2<Stream<A>, Stream<B>>>(){

            @Override
            public P2<Stream<A>, Stream<B>> f(P2<A, B> p2, P1<P2<Stream<A>, Stream<B>>> p1) {
                P2 p22 = p1._1();
                return P.p(Stream.cons(p2._1(), P.p(p22._1())), Stream.cons(p2._2(), P.p(p22._2())));
            }
        }, P.p(Stream.<A>nil(), Stream.<A>nil()));
    }

    public static <A, B, C> F<Stream<A>, F<Stream<B>, F<F<A, F<B, C>>, Stream<C>>>> zipWith() {
        return Function.curry(new F3<Stream<A>, Stream<B>, F<A, F<B, C>>, Stream<C>>(){

            @Override
            public Stream<C> f(Stream<A> stream, Stream<B> stream2, F<A, F<B, C>> f) {
                return stream.zipWith(stream2, f);
            }
        });
    }

    public static <A> F<A, F<P1<Stream<A>>, Stream<A>>> cons() {
        return new F<A, F<P1<Stream<A>>, Stream<A>>>(){

            @Override
            public F<P1<Stream<A>>, Stream<A>> f(final A a) {
                return new F<P1<Stream<A>>, Stream<A>>(){

                    @Override
                    public Stream<A> f(P1<Stream<A>> p1) {
                        return Stream.cons(a, p1);
                    }
                };
            }
        };
    }

    public static <A> F<A, F<Stream<A>, Stream<A>>> cons_() {
        return Function.curry(new F2<A, Stream<A>, Stream<A>>(){

            @Override
            public Stream<A> f(A a, Stream<A> stream) {
                return stream.cons(a);
            }
        });
    }

    public static <A> Stream<A> nil() {
        return new Nil();
    }

    public static <A> P1<Stream<A>> nil_() {
        return new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return new Nil();
            }
        };
    }

    public static <A> F<Stream<A>, Boolean> isEmpty_() {
        return new F<Stream<A>, Boolean>(){

            @Override
            public Boolean f(Stream<A> stream) {
                return stream.isEmpty();
            }
        };
    }

    public static <A> F<Stream<A>, Boolean> isNotEmpty_() {
        return new F<Stream<A>, Boolean>(){

            @Override
            public Boolean f(Stream<A> stream) {
                return stream.isNotEmpty();
            }
        };
    }

    public static <A> Stream<A> single(A a) {
        return Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.nil();
            }
        });
    }

    public static <A> F<A, Stream<A>> single() {
        return new F<A, Stream<A>>(){

            @Override
            public Stream<A> f(A a) {
                return Stream.single(a);
            }
        };
    }

    public static <A> Stream<A> cons(A a, P1<Stream<A>> p1) {
        return new Cons<A>(a, p1);
    }

    public static <A> Stream<A> join(Stream<Stream<A>> stream) {
        return Monoid.streamMonoid().sumRight(stream);
    }

    public static <A> F<Stream<Stream<A>>, Stream<A>> join() {
        return new F<Stream<Stream<A>>, Stream<A>>(){

            @Override
            public Stream<A> f(Stream<Stream<A>> stream) {
                return Stream.join(stream);
            }
        };
    }

    public static <A, B> Stream<A> unfold(final F<B, Option<P2<A, B>>> f, B b) {
        Option<P2<A, B>> option = f.f(b);
        if (option.isNone()) {
            return Stream.nil();
        }
        final P2<A, B> p2 = option.some();
        return Stream.cons(p2._1(), new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.unfold(f, p2._2());
            }
        });
    }

    public static <A> Stream<A> iterateWhile(final F<A, A> f, final F<A, Boolean> f2, A a) {
        return Stream.unfold(new F<A, Option<P2<A, A>>>(){

            @Override
            public Option<P2<A, A>> f(final A a) {
                return Option.iif(new F<P2<A, A>, Boolean>(){

                    @Override
                    public Boolean f(P2<A, A> p2) {
                        return (Boolean)f2.f(a);
                    }
                }, P.p(a, f.f(a)));
            }
        }, a);
    }

    public static <A> Stream<A> iterableStream(Iterable<A> iterable) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Util {
            Util() {
            }

            public <A> Stream<A> iteratorStream(final Iterator<A> iterator) {
                if (iterator.hasNext()) {
                    A a = iterator.next();
                    return Stream.cons(a, new P1<Stream<A>>(){

                        @Override
                        public Stream<A> _1() {
                            return this.iteratorStream(iterator);
                        }
                    });
                }
                return Stream.nil();
            }
        }
        return new Util().iteratorStream(iterable.iterator());
    }

    public static <A> Stream<A> repeat(final A a) {
        return Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.repeat(a);
            }
        });
    }

    public static <A> Stream<A> cycle(final Stream<A> stream) {
        if (stream.isEmpty()) {
            throw Bottom.error("cycle on empty list");
        }
        return stream.append(new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.cycle(stream);
            }
        });
    }

    public static <A> Stream<A> iterate(final F<A, A> f, final A a) {
        return Stream.cons(a, new P1<Stream<A>>(){

            @Override
            public Stream<A> _1() {
                return Stream.iterate(f, f.f(a));
            }
        });
    }

    public static <A> F<F<A, A>, F<A, Stream<A>>> iterate() {
        return Function.curry(new F2<F<A, A>, A, Stream<A>>(){

            @Override
            public Stream<A> f(F<A, A> f, A a) {
                return Stream.iterate(f, a);
            }
        });
    }

    public static <A, B> F<F<A, Stream<B>>, F<Stream<A>, Stream<B>>> bind_() {
        return Function.curry(new F2<F<A, Stream<B>>, Stream<A>, Stream<B>>(){

            @Override
            public Stream<B> f(F<A, Stream<B>> f, Stream<A> stream) {
                return stream.bind(f);
            }
        });
    }

    public static <A, B> F<F<A, F<P1<B>, B>>, F<B, F<Stream<A>, B>>> foldRight() {
        return Function.curry(new F3<F<A, F<P1<B>, B>>, B, Stream<A>, B>(){

            @Override
            public B f(F<A, F<P1<B>, B>> f, B b, Stream<A> stream) {
                return stream.foldRight(f, b);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Cons<A>
    extends Stream<A> {
        private final A head;
        private final P1<Stream<A>> tail;

        Cons(A a, P1<Stream<A>> p1) {
            this.head = a;
            this.tail = p1.memo();
        }

        @Override
        public A head() {
            return this.head;
        }

        @Override
        public P1<Stream<A>> tail() {
            return this.tail;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Nil<A>
    extends Stream<A> {
        private Nil() {
        }

        @Override
        public A head() {
            throw Bottom.error("head on empty stream");
        }

        @Override
        public P1<Stream<A>> tail() {
            throw Bottom.error("tail on empty stream");
        }
    }
}

