/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Monoid;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Show;
import fj.data.List;
import fj.data.Stream;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tree<A>
implements Iterable<A> {
    private final A root;
    private final P1<Stream<Tree<A>>> subForest;

    @Override
    public Iterator<A> iterator() {
        return this.flatten().iterator();
    }

    private Tree(A a, P1<Stream<Tree<A>>> p1) {
        this.root = a;
        this.subForest = p1;
    }

    public static <A> Tree<A> leaf(A a) {
        return Tree.node(a, Stream.nil());
    }

    public static <A> Tree<A> node(A a, P1<Stream<Tree<A>>> p1) {
        return new Tree<A>(a, p1);
    }

    public static <A> Tree<A> node(A a, Stream<Tree<A>> stream) {
        return new Tree<A>(a, P.p(stream));
    }

    public static <A> Tree<A> node(A a, List<Tree<A>> list) {
        return Tree.node(a, list.toStream());
    }

    public static <A> F<A, F<P1<Stream<Tree<A>>>, Tree<A>>> node() {
        return Function.curry(new F2<A, P1<Stream<Tree<A>>>, Tree<A>>(){

            @Override
            public Tree<A> f(A a, P1<Stream<Tree<A>>> p1) {
                return Tree.node(a, p1);
            }
        });
    }

    public A root() {
        return this.root;
    }

    public P1<Stream<Tree<A>>> subForest() {
        return this.subForest;
    }

    public static <A> F<Tree<A>, A> root_() {
        return new F<Tree<A>, A>(){

            @Override
            public A f(Tree<A> tree) {
                return tree.root();
            }
        };
    }

    public static <A> F<Tree<A>, P1<Stream<Tree<A>>>> subForest_() {
        return new F<Tree<A>, P1<Stream<Tree<A>>>>(){

            @Override
            public P1<Stream<Tree<A>>> f(Tree<A> tree) {
                return tree.subForest();
            }
        };
    }

    public Stream<A> flatten() {
        F2 f2 = new F2<Tree<A>, P1<Stream<A>>, Stream<A>>(){

            @Override
            public Stream<A> f(Tree<A> tree, P1<Stream<A>> p1) {
                return Stream.cons(tree.root(), tree.subForest().map(Stream.foldRight().f(this.curry()).f(p1._1())));
            }
        };
        return (Stream)f2.f(this, P.p(Stream.nil()));
    }

    public static <A> F<Tree<A>, Stream<A>> flatten_() {
        return new F<Tree<A>, Stream<A>>(){

            @Override
            public Stream<A> f(Tree<A> tree) {
                return tree.flatten();
            }
        };
    }

    public Stream<Stream<A>> levels() {
        F f = Stream.bind_().f(Function.compose(P1.__1(), Tree.<Tree<A>>subForest_()));
        F f2 = Stream.map_().f(Tree.<Tree<A>>root_());
        return Stream.iterateWhile(f, Stream.isNotEmpty_(), Stream.single(this)).map(f2);
    }

    public <B> Tree<B> fmap(F<A, B> f) {
        return Tree.node(f.f(this.root()), this.subForest().map(Stream.map_().f(Tree.fmap_().f(f))));
    }

    public static <A, B> F<F<A, B>, F<Tree<A>, Tree<B>>> fmap_() {
        return new F<F<A, B>, F<Tree<A>, Tree<B>>>(){

            @Override
            public F<Tree<A>, Tree<B>> f(final F<A, B> f) {
                return new F<Tree<A>, Tree<B>>(){

                    @Override
                    public Tree<B> f(Tree<A> tree) {
                        return tree.fmap(f);
                    }
                };
            }
        };
    }

    public <B> B foldMap(F<A, B> f, Monoid<B> monoid) {
        return monoid.sum(f.f(this.root()), monoid.sumRight(this.subForest()._1().map(Tree.foldMap_(f, monoid)).toList()));
    }

    public Collection<A> toCollection() {
        return this.flatten().toCollection();
    }

    public static <A, B> F<Tree<A>, B> foldMap_(final F<A, B> f, final Monoid<B> monoid) {
        return new F<Tree<A>, B>(){

            @Override
            public B f(Tree<A> tree) {
                return tree.foldMap(f, monoid);
            }
        };
    }

    public static <A, B> F<B, Tree<A>> unfoldTree(final F<B, P2<A, P1<Stream<B>>>> f) {
        return new F<B, Tree<A>>(){

            @Override
            public Tree<A> f(B b) {
                P2 p2 = (P2)f.f(b);
                return Tree.node(p2._1(), ((P1)p2._2()).map(Stream.map_().f(Tree.unfoldTree(f))));
            }
        };
    }

    public <B> Tree<B> cobind(final F<Tree<A>, B> f) {
        return Tree.unfoldTree(new F<Tree<A>, P2<B, P1<Stream<Tree<A>>>>>(){

            @Override
            public P2<B, P1<Stream<Tree<A>>>> f(Tree<A> tree) {
                return P.p(f.f(tree), tree.subForest());
            }
        }).f(this);
    }

    public Tree<Tree<A>> cojoin() {
        F f = Function.identity();
        return this.cobind(f);
    }

    private static <A> Stream<String> drawSubTrees(Show<A> show, Stream<Tree<A>> stream) {
        return stream.isEmpty() ? Stream.nil() : (stream.tail()._1().isEmpty() ? Tree.shift("`- ", "   ", super.drawTree(show)).cons("|") : Tree.shift("+- ", "|  ", super.drawTree(show)).append(Tree.drawSubTrees(show, stream.tail()._1())));
    }

    private static Stream<String> shift(String string, String string2, Stream<String> stream) {
        return Stream.repeat(string2).cons(string).zipWith(stream, Monoid.stringMonoid.sum());
    }

    private Stream<String> drawTree(Show<A> show) {
        return Tree.drawSubTrees(show, this.subForest._1()).cons(show.showS(this.root));
    }

    public String draw(Show<A> show) {
        return Monoid.stringMonoid.join(this.drawTree(show), "\n");
    }

    public static <A> Show<Tree<A>> show2D(final Show<A> show) {
        return Show.showS(new F<Tree<A>, String>(){

            @Override
            public String f(Tree<A> tree) {
                return tree.draw(show);
            }
        });
    }

    public <B, C> Tree<C> zipWith(Tree<B> tree, F2<A, B, C> f2) {
        return f2.zipTreeM().f(this, tree);
    }

    public <B, C> Tree<C> zipWith(Tree<B> tree, F<A, F<B, C>> f) {
        return this.zipWith(tree, Function.uncurryF2(f));
    }
}

