/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.Function;
import fj.Ord;
import fj.P;
import fj.P2;
import fj.P3;
import fj.data.IterableW;
import fj.data.List;
import fj.data.Option;
import fj.data.Set;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeMap<K, V>
implements Iterable<P2<K, V>> {
    private final Set<P2<K, Option<V>>> tree;

    private TreeMap(Set<P2<K, Option<V>>> set) {
        this.tree = set;
    }

    private static <K, V> Ord<P2<K, V>> ord(Ord<K> ord) {
        return ord.comap(P2.__1());
    }

    public static <K, V> TreeMap<K, V> empty(Ord<K> ord) {
        return new TreeMap<K, V>(Set.empty(TreeMap.ord(ord)));
    }

    public Option<V> get(K k) {
        Option option = this.tree.split(P.p(k, Option.none()))._2();
        return option.bind(P2.__2());
    }

    public TreeMap<K, V> set(K k, V v) {
        P3 p3 = this.tree.split(P.p(k, Option.none()));
        return new TreeMap<K, V>(p3._1().union(p3._3().insert(P.p(k, Option.some(v)))));
    }

    public TreeMap<K, V> delete(K k) {
        return new TreeMap<K, V>(this.tree.delete(P.p(k, Option.none())));
    }

    public int size() {
        return this.tree.size();
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public List<V> values() {
        return List.iterableList(IterableW.join(this.tree.toList().map(Function.compose(IterableW.wrap(), P2.__2()))));
    }

    public List<K> keys() {
        return this.tree.toList().map(P2.__1());
    }

    public boolean contains(K k) {
        return this.tree.member(P.p(k, Option.none()));
    }

    @Override
    public Iterator<P2<K, V>> iterator() {
        return IterableW.join(this.tree.toStream().map(P2.map2_(IterableW.wrap())).map(P2.tuple(Function.compose(IterableW.map(), P.p2())))).iterator();
    }

    public Map<K, V> toMutableMap() {
        java.util.TreeMap<K, V> treeMap = new java.util.TreeMap<K, V>();
        for (P2<K, V> p2 : this) {
            treeMap.put(p2._1(), p2._2());
        }
        return treeMap;
    }

    public static <K, V> TreeMap<K, V> fromMutableMap(Ord<K> ord, Map<K, V> map) {
        TreeMap<K, V> treeMap = TreeMap.empty(ord);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            treeMap = treeMap.set(entry.getKey(), entry.getValue());
        }
        return treeMap;
    }

    public F<K, Option<V>> get() {
        return new F<K, Option<V>>(){

            @Override
            public Option<V> f(K k) {
                return TreeMap.this.get(k);
            }
        };
    }

    public P2<Boolean, TreeMap<K, V>> update(K k, F<V, V> f) {
        P2 p2 = this.tree.update(P.p(k, Option.none()), P2.map2_(Option.map().f(f)));
        return P.p(p2._1(), new TreeMap<K, V>(p2._2()));
    }

    public TreeMap<K, V> update(K k, F<V, V> f, V v) {
        P2<Boolean, TreeMap<K, V>> p2 = this.update(k, f);
        return p2._1() != false ? p2._2() : this.set(k, v);
    }

    public P3<Set<V>, Option<V>, Set<V>> split(K k) {
        F f = Option.fromSome().o(P2.__2()).mapSet(this.tree.ord().comap(P.p2().f(k).o(Option.some_())));
        return this.tree.split(P.p(k, Option.none())).map1(f).map3(f).map2(Option.join().o(P2.__2().mapOption()));
    }

    public <W> TreeMap<K, W> map(F<V, W> f) {
        F f2 = P2.map2_(f.mapOption());
        F f3 = Function.flip(P.p2()).f(Option.none());
        Ord ord = this.tree.ord().comap(f3);
        return new TreeMap<K, V>(this.tree.map(TreeMap.ord(ord), f2));
    }
}

