/*
 * Decompiled with CFR 0.152.
 */
package fj.data.fingertrees;

import fj.F;
import fj.Function;
import fj.P2;
import fj.data.List;
import fj.data.fingertrees.Digit;
import fj.data.fingertrees.Empty;
import fj.data.fingertrees.FingerTree;
import fj.data.fingertrees.Four;
import fj.data.fingertrees.MakeTree;
import fj.data.fingertrees.Measured;
import fj.data.fingertrees.Node;
import fj.data.fingertrees.One;
import fj.data.fingertrees.Single;
import fj.data.fingertrees.Three;
import fj.data.fingertrees.Two;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Deep<V, A>
extends FingerTree<V, A> {
    private final V v;
    private final Digit<V, A> prefix;
    private final FingerTree<V, Node<V, A>> middle;
    private final Digit<V, A> suffix;

    Deep(Measured<V, A> measured, V v, Digit<V, A> digit, FingerTree<V, Node<V, A>> fingerTree, Digit<V, A> digit2) {
        super(measured);
        this.v = v;
        this.prefix = digit;
        this.middle = fingerTree;
        this.suffix = digit2;
    }

    public Digit<V, A> prefix() {
        return this.prefix;
    }

    public FingerTree<V, Node<V, A>> middle() {
        return this.middle;
    }

    public Digit<V, A> suffix() {
        return this.suffix;
    }

    @Override
    public <B> B foldRight(F<A, F<B, B>> f, B b) {
        return this.prefix.foldRight(f, this.middle.foldRight(Function.flip(Node.foldRight_(f)), this.suffix.foldRight(f, b)));
    }

    @Override
    public A reduceRight(F<A, F<A, A>> f) {
        return this.prefix.foldRight(f, this.middle.foldRight(Function.flip(Node.foldRight_(f)), this.suffix.reduceRight(f)));
    }

    @Override
    public <B> B foldLeft(F<B, F<A, B>> f, B b) {
        return this.suffix.foldLeft(f, this.middle.foldLeft(Node.foldLeft_(f), this.prefix.foldLeft(f, b)));
    }

    @Override
    public A reduceLeft(F<A, F<A, A>> f) {
        return this.suffix.foldLeft(f, this.middle.foldLeft(Node.foldLeft_(f), this.prefix.reduceLeft(f)));
    }

    @Override
    public <B> FingerTree<V, B> map(F<A, B> f, Measured<V, B> measured) {
        return new Deep<V, B>(measured, this.v, this.prefix.map(f, measured), this.middle.map(Node.liftM(f, measured), measured.nodeMeasured()), this.suffix.map(f, measured));
    }

    @Override
    public V measure() {
        return this.v;
    }

    @Override
    public <B> B match(F<Empty<V, A>, B> f, F<Single<V, A>, B> f2, F<Deep<V, A>, B> f3) {
        return f3.f(this);
    }

    @Override
    public FingerTree<V, A> cons(final A a) {
        final Measured measured = this.measured();
        final Object v = measured.sum(measured.measure(a), this.v);
        final MakeTree makeTree = Deep.mkTree(measured);
        return (FingerTree)this.prefix.match(new F<One<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(One<V, A> one) {
                return new Deep<Object, Object>(measured, v, makeTree.two(a, one.value()), Deep.this.middle, Deep.this.suffix);
            }
        }, new F<Two<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(Two<V, A> two) {
                return new Deep<Object, Object>(measured, v, makeTree.three(a, two.values()._1(), two.values()._2()), Deep.this.middle, Deep.this.suffix);
            }
        }, new F<Three<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(Three<V, A> three) {
                return new Deep<Object, Object>(measured, v, makeTree.four(a, three.values()._1(), three.values()._2(), three.values()._3()), Deep.this.middle, Deep.this.suffix);
            }
        }, new F<Four<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(Four<V, A> four) {
                return new Deep<Object, Object>(measured, v, makeTree.two(a, four.values()._1()), Deep.this.middle.cons(makeTree.node3(four.values()._2(), four.values()._3(), four.values()._4())), Deep.this.suffix);
            }
        });
    }

    @Override
    public FingerTree<V, A> snoc(final A a) {
        final Measured measured = this.measured();
        final Object v = measured.sum(measured.measure(a), this.v);
        final MakeTree makeTree = Deep.mkTree(measured);
        return (FingerTree)this.suffix.match(new F<One<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(One<V, A> one) {
                return new Deep<Object, Object>(measured, v, Deep.this.prefix, Deep.this.middle, makeTree.two(one.value(), a));
            }
        }, new F<Two<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(Two<V, A> two) {
                return new Deep<Object, Object>(measured, v, Deep.this.prefix, Deep.this.middle, makeTree.three(two.values()._1(), two.values()._2(), a));
            }
        }, new F<Three<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(Three<V, A> three) {
                return new Deep<Object, Object>(measured, v, Deep.this.prefix, Deep.this.middle, makeTree.four(three.values()._1(), three.values()._2(), three.values()._3(), a));
            }
        }, new F<Four<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(Four<V, A> four) {
                return new Deep<Object, Object>(measured, v, Deep.this.prefix, Deep.this.middle.snoc(makeTree.node3(four.values()._1(), four.values()._2(), four.values()._3())), makeTree.two(four.values()._4(), a));
            }
        });
    }

    @Override
    public FingerTree<V, A> append(final FingerTree<V, A> fingerTree) {
        final Measured measured = this.measured();
        return fingerTree.match(Function.constant(fingerTree), new F<Single<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(Single<V, A> single) {
                return fingerTree.snoc(single.value());
            }
        }, new F<Deep<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(Deep<V, A> deep) {
                return new Deep(measured, measured.sum(Deep.this.measure(), deep.measure()), Deep.this.prefix, Deep.addDigits0(measured, Deep.this.middle, Deep.this.suffix, deep.prefix, deep.middle), deep.suffix);
            }
        });
    }

    @Override
    public P2<Integer, A> lookup(F<V, Integer> f, int n) {
        int n2 = f.f(this.prefix.measure());
        int n3 = f.f(this.middle.measure());
        if (n < n2) {
            return null;
        }
        if (n < n3) {
            return null;
        }
        return null;
    }

    private static <V, A> FingerTree<V, Node<V, A>> addDigits0(final Measured<V, A> measured, final FingerTree<V, Node<V, A>> fingerTree, Digit<V, A> digit, final Digit<V, A> digit2, final FingerTree<V, Node<V, A>> fingerTree2) {
        final MakeTree<V, A> makeTree = Deep.mkTree(measured);
        return (FingerTree)digit.match(new F<One<V, A>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(final One<V, A> one) {
                return (FingerTree)digit2.match(new F<One<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(One<V, A> one2) {
                        return Deep.append1(measured, fingerTree, makeTree.node2(one.value(), one2.value()), fingerTree2);
                    }
                }, new F<Two<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Two<V, A> two) {
                        V2 v2 = two.values();
                        return Deep.append1(measured, fingerTree, makeTree.node3(one.value(), v2._1(), v2._2()), fingerTree2);
                    }
                }, new F<Three<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Three<V, A> three) {
                        V3 v3 = three.values();
                        return Deep.append2(measured, fingerTree, makeTree.node2(one.value(), v3._1()), makeTree.node2(v3._2(), v3._3()), fingerTree2);
                    }
                }, new F<Four<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Four<V, A> four) {
                        V4 v4 = four.values();
                        return Deep.append2(measured, fingerTree, makeTree.node3(one.value(), v4._1(), v4._2()), makeTree.node2(v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Two<V, A>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(Two<V, A> two) {
                final V2 v2 = two.values();
                return (FingerTree)digit2.match(new F<One<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(One<V, A> one) {
                        return Deep.append1(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), one.value()), fingerTree2);
                    }
                }, new F<Two<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Two<V, A> two) {
                        V2 v22 = two.values();
                        return Deep.append2(measured, fingerTree, makeTree.node2(v2._1(), v2._2()), makeTree.node2(v22._1(), v22._2()), fingerTree2);
                    }
                }, new F<Three<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Three<V, A> three) {
                        V3 v3 = three.values();
                        return Deep.append2(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), v3._1()), makeTree.node2(v3._2(), v3._3()), fingerTree2);
                    }
                }, new F<Four<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Four<V, A> four) {
                        V4 v4 = four.values();
                        return Deep.append2(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), v4._1()), makeTree.node3(v4._2(), v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Three<V, A>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(Three<V, A> three) {
                final V3 v3 = three.values();
                return (FingerTree)digit2.match(new F<One<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(One<V, A> one) {
                        return Deep.append2(measured, fingerTree, makeTree.node2(v3._1(), v3._2()), makeTree.node2(v3._3(), one.value()), fingerTree2);
                    }
                }, new F<Two<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Two<V, A> two) {
                        V2 v2 = two.values();
                        return Deep.append2(measured, fingerTree, makeTree.node3(v3), makeTree.node2(v2), fingerTree2);
                    }
                }, new F<Three<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Three<V, A> three) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(v3), makeTree.node3(three.values()), fingerTree2);
                    }
                }, new F<Four<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Four<V, A> four) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v3), makeTree.node2(four.values()._1(), four.values()._2()), makeTree.node2(four.values()._3(), four.values()._4()), fingerTree2);
                    }
                });
            }
        }, new F<Four<V, A>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(Four<V, A> four) {
                final V4 v4 = four.values();
                return (FingerTree)digit2.match(new F<One<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(One<V, A> one) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node2(v4._4(), one.value()), fingerTree2);
                    }
                }, new F<Two<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Two<V, A> two) {
                        V2 v2 = two.values();
                        return Deep.append2(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), v2._1(), v2._2()), fingerTree2);
                    }
                }, new F<Three<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Three<V, A> three) {
                        V3 v3 = three.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node2(v4._4(), v3._1()), makeTree.node2(v3._2(), v3._3()), fingerTree2);
                    }
                }, new F<Four<V, A>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Four<V, A> four) {
                        V4 v42 = four.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), v42._1(), v42._2()), makeTree.node2(v42._3(), v42._4()), fingerTree2);
                    }
                });
            }
        });
    }

    private static <V, A> FingerTree<V, Node<V, A>> append1(final Measured<V, A> measured, final FingerTree<V, Node<V, A>> fingerTree, final Node<V, A> node, final FingerTree<V, Node<V, A>> fingerTree2) {
        return (FingerTree)fingerTree.match(new F<Empty<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(Empty<V, Node<V, A>> empty) {
                return fingerTree2.cons(node);
            }
        }, new F<Single<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(Single<V, Node<V, A>> single) {
                return fingerTree2.cons(node).cons(single.value());
            }
        }, new F<Deep<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(final Deep<V, Node<V, A>> deep) {
                return (FingerTree)fingerTree2.match(new F<Empty<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Empty<V, Node<V, A>> empty) {
                        return fingerTree.snoc(node);
                    }
                }, new F<Single<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Single<V, Node<V, A>> single) {
                        return fingerTree.snoc(node).snoc(single.value());
                    }
                }, new F<Deep<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Deep<V, Node<V, A>> deep2) {
                        Measured measured = measured.nodeMeasured();
                        return new Deep(measured, measured.sum(measured.sum(deep.v, measured.measure(node)), deep2.v), deep.prefix, Deep.addDigits1(measured, deep.middle, deep.suffix, node, deep2.prefix, deep2.middle), deep2.suffix);
                    }
                });
            }
        });
    }

    private static <V, A> FingerTree<V, Node<V, Node<V, A>>> addDigits1(final Measured<V, Node<V, A>> measured, final FingerTree<V, Node<V, Node<V, A>>> fingerTree, Digit<V, Node<V, A>> digit, final Node<V, A> node, final Digit<V, Node<V, A>> digit2, final FingerTree<V, Node<V, Node<V, A>>> fingerTree2) {
        final MakeTree<V, Node<V, A>> makeTree = Deep.mkTree(measured);
        return (FingerTree)digit.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(final One<V, Node<V, A>> one) {
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one2) {
                        return Deep.append1(measured, fingerTree, makeTree.node3(one.value(), node, one2.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        return Deep.append2(measured, fingerTree, makeTree.node2(one.value(), node), makeTree.node2(two.values()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        V3 v3 = three.values();
                        return Deep.append2(measured, fingerTree, makeTree.node3(one.value(), node, v3._1()), makeTree.node2(v3._2(), v3._3()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v4 = four.values();
                        return Deep.append2(measured, fingerTree, makeTree.node3(one.value(), node, v4._1()), makeTree.node3(v4._2(), v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                final V2 v2 = two.values();
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one) {
                        return Deep.append2(measured, fingerTree, makeTree.node2(v2), makeTree.node2(node, one.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node2(two.values()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node3(three.values()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v4 = four.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node2(v4._1(), v4._2()), makeTree.node2(v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                final V3 v3 = three.values();
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(v3), makeTree.node2(node, one.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        V2 v2 = two.values();
                        return Deep.append2(measured, fingerTree, makeTree.node3(v3), makeTree.node3(node, v2._1(), v2._2()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        V3 v32 = three.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v3), makeTree.node2(node, v32._1()), makeTree.node2(v32._2(), v32._3()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v4 = four.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v3), makeTree.node3(node, v4._1(), v4._2()), makeTree.node2(v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                final V4 v4 = four.values();
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, one.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node2(v4._4(), node), makeTree.node2(two.values()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        V3 v3 = three.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, v3._1()), makeTree.node2(v3._2(), v3._3()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v42 = four.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, v42._1()), makeTree.node3(v42._2(), v42._3(), v42._4()), fingerTree2);
                    }
                });
            }
        });
    }

    private static <V, A> FingerTree<V, Node<V, A>> append2(final Measured<V, A> measured, FingerTree<V, Node<V, A>> fingerTree, final Node<V, A> node, final Node<V, A> node2, final FingerTree<V, Node<V, A>> fingerTree2) {
        return (FingerTree)fingerTree.match(new F<Empty<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(Empty<V, Node<V, A>> empty) {
                return fingerTree2.cons(node2).cons(node);
            }
        }, new F<Single<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(Single<V, Node<V, A>> single) {
                return fingerTree2.cons(node2).cons(node).cons(single.value());
            }
        }, new F<Deep<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(final Deep<V, Node<V, A>> deep) {
                return (FingerTree)fingerTree2.match(new F<Empty<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Empty<V, Node<V, A>> empty) {
                        return deep.snoc(node).snoc(node2);
                    }
                }, new F<Single<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Single<V, Node<V, A>> single) {
                        return deep.snoc(node).snoc(node2).snoc(single.value());
                    }
                }, new F<Deep<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Deep<V, Node<V, A>> deep2) {
                        return new Deep(measured.nodeMeasured(), measured.sum(measured.sum(measured.sum(deep.measure(), node.measure()), node2.measure()), deep2.measure()), deep.prefix, Deep.addDigits2(measured.nodeMeasured(), deep.middle, deep.suffix, node, node2, deep2.prefix, deep2.middle), deep2.suffix);
                    }
                });
            }
        });
    }

    private static <V, A> FingerTree<V, Node<V, Node<V, A>>> addDigits2(final Measured<V, Node<V, A>> measured, final FingerTree<V, Node<V, Node<V, A>>> fingerTree, Digit<V, Node<V, A>> digit, final Node<V, A> node, final Node<V, A> node2, final Digit<V, Node<V, A>> digit2, final FingerTree<V, Node<V, Node<V, A>>> fingerTree2) {
        final MakeTree<V, Node<V, A>> makeTree = Deep.mkTree(measured);
        return (FingerTree)digit.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(final One<V, Node<V, A>> one) {
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one2) {
                        return Deep.append2(measured, fingerTree, makeTree.node2(one.value(), node), makeTree.node2(node2, one2.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(one.value(), node, node2), makeTree.node2(two.values()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(one.value(), node, node2), makeTree.node3(three.values()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v4 = four.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(one.value(), node, node2), makeTree.node2(v4._1(), v4._2()), makeTree.node2(v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                final V2 v2 = two.values();
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node2(node2, one.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        V2 v22 = two.values();
                        return Deep.append2(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node3(node2, v22._1(), v22._2()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        V3 v3 = three.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node2(node2, v3._1()), makeTree.node2(v3._2(), v3._3()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v4 = four.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node3(node2, v4._1(), v4._2()), makeTree.node2(v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                final V3 v3 = three.values();
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(v3), makeTree.node3(node, node2, one.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v3), makeTree.node2(node, node2), makeTree.node2(two.values()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        V3 v32 = three.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v3), makeTree.node3(node, node2, v32._1()), makeTree.node2(v32._2(), v32._3()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v4 = four.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v3), makeTree.node3(node, node2, v4._1()), makeTree.node3(v4._2(), v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                final V4 v4 = four.values();
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node2(v4._4(), node), makeTree.node2(node2, one.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, node2), makeTree.node2(two.values()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, node2), makeTree.node3(three.values()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v42 = four.values();
                        return Deep.append4(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, node2), makeTree.node2(v42._1(), v42._2()), makeTree.node2(v42._3(), v42._4()), fingerTree2);
                    }
                });
            }
        });
    }

    private static <V, A> FingerTree<V, Node<V, A>> append3(Measured<V, A> measured, FingerTree<V, Node<V, A>> fingerTree, final Node<V, A> node, final Node<V, A> node2, final Node<V, A> node3, final FingerTree<V, Node<V, A>> fingerTree2) {
        final Measured<V, Node<V, A>> measured2 = measured.nodeMeasured();
        return (FingerTree)fingerTree.match(new F<Empty<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(Empty<V, Node<V, A>> empty) {
                return fingerTree2.cons(node3).cons(node2).cons(node);
            }
        }, new F<Single<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(Single<V, Node<V, A>> single) {
                return fingerTree2.cons(node3).cons(node2).cons(node).cons(single.value());
            }
        }, new F<Deep<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(final Deep<V, Node<V, A>> deep) {
                return (FingerTree)fingerTree2.match(new F<Empty<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Empty<V, Node<V, A>> empty) {
                        return deep.snoc(node).snoc(node2).snoc(node3);
                    }
                }, new F<Single<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Single<V, Node<V, A>> single) {
                        return deep.snoc(node).snoc(node2).snoc(node3).snoc(single.value());
                    }
                }, new F<Deep<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Deep<V, Node<V, A>> deep2) {
                        return new Deep(measured2, measured2.monoid().sumLeft(List.list(deep.v, node.measure(), node2.measure(), node3.measure(), deep2.v)), deep.prefix, Deep.addDigits3(measured2, deep.middle, deep.suffix, node, node2, node3, deep2.prefix, deep2.middle), deep2.suffix);
                    }
                });
            }
        });
    }

    private static <V, A> FingerTree<V, Node<V, Node<V, A>>> addDigits3(final Measured<V, Node<V, A>> measured, final FingerTree<V, Node<V, Node<V, A>>> fingerTree, Digit<V, Node<V, A>> digit, final Node<V, A> node, final Node<V, A> node2, final Node<V, A> node3, final Digit<V, Node<V, A>> digit2, final FingerTree<V, Node<V, Node<V, A>>> fingerTree2) {
        final MakeTree<V, Node<V, A>> makeTree = Deep.mkTree(measured);
        return (FingerTree)digit.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(final One<V, Node<V, A>> one) {
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one2) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(one.value(), node, node2), makeTree.node2(node3, one2.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        V2 v2 = two.values();
                        return Deep.append2(measured, fingerTree, makeTree.node3(one.value(), node, node2), makeTree.node3(node3, v2._1(), v2._2()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        V3 v3 = three.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(one.value(), node, node2), makeTree.node2(node3, v3._1()), makeTree.node2(v3._2(), v3._3()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v4 = four.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(one.value(), node, node2), makeTree.node3(node3, v4._1(), v4._2()), makeTree.node2(v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                final V2 v2 = two.values();
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node3(node2, node3, one.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node2(node2, node3), makeTree.node2(two.values()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        V3 v3 = three.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node3(node2, node3, v3._1()), makeTree.node2(v3._2(), v3._3()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v4 = four.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node3(node2, node3, v4._1()), makeTree.node3(v4._2(), v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(final Three<V, Node<V, A>> three) {
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(three.values()), makeTree.node2(node, node2), makeTree.node2(node3, one.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(three.values()), makeTree.node3(node, node2, node3), makeTree.node2(two.values()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three2) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(three.values()), makeTree.node3(node, node2, node3), makeTree.node3(three2.values()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v4 = four.values();
                        return Deep.append4(measured, fingerTree, makeTree.node3(three.values()), makeTree.node3(node, node2, node3), makeTree.node2(v4._1(), v4._2()), makeTree.node2(v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                final V4 v4 = four.values();
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, node2), makeTree.node2(node3, one.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        V2 v2 = two.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, node2), makeTree.node3(node3, v2._1(), v2._2()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        V3 v3 = three.values();
                        return Deep.append4(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, node2), makeTree.node2(node3, v3._1()), makeTree.node2(v3._2(), v3._3()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v42 = four.values();
                        return Deep.append4(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, node2), makeTree.node3(node3, v42._1(), v42._2()), makeTree.node2(v42._3(), v42._4()), fingerTree2);
                    }
                });
            }
        });
    }

    private static <V, A> FingerTree<V, Node<V, A>> append4(final Measured<V, A> measured, final FingerTree<V, Node<V, A>> fingerTree, final Node<V, A> node, final Node<V, A> node2, final Node<V, A> node3, final Node<V, A> node4, final FingerTree<V, Node<V, A>> fingerTree2) {
        final Measured<V, Node<V, A>> measured2 = measured.nodeMeasured();
        return (FingerTree)fingerTree.match(new F<Empty<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(Empty<V, Node<V, A>> empty) {
                return fingerTree2.cons(node4).cons(node3).cons(node2).cons(node);
            }
        }, new F<Single<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(Single<V, Node<V, A>> single) {
                return fingerTree2.cons(node4).cons(node3).cons(node2).cons(node).cons(single.value());
            }
        }, new F<Deep<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

            @Override
            public FingerTree<V, Node<V, A>> f(final Deep<V, Node<V, A>> deep) {
                return (FingerTree)fingerTree2.match(new F<Empty<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Empty<V, Node<V, A>> empty) {
                        return fingerTree.snoc(node).snoc(node2).snoc(node3).snoc(node4);
                    }
                }, new F<Single<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Single<V, Node<V, A>> single) {
                        return fingerTree.snoc(node).snoc(node2).snoc(node3).snoc(node4).snoc(single.value());
                    }
                }, new F<Deep<V, Node<V, A>>, FingerTree<V, Node<V, A>>>(){

                    @Override
                    public FingerTree<V, Node<V, A>> f(Deep<V, Node<V, A>> deep2) {
                        return new Deep(measured2, measured.monoid().sumLeft(List.list(deep.v, node.measure(), node2.measure(), node3.measure(), node4.measure(), deep2.v)), deep.prefix, Deep.addDigits4(measured2, deep.middle, deep.suffix, node, node2, node3, node4, deep2.prefix, deep2.middle), deep2.suffix);
                    }
                });
            }
        });
    }

    private static <V, A> FingerTree<V, Node<V, Node<V, A>>> addDigits4(final Measured<V, Node<V, A>> measured, final FingerTree<V, Node<V, Node<V, A>>> fingerTree, Digit<V, Node<V, A>> digit, final Node<V, A> node, final Node<V, A> node2, final Node<V, A> node3, final Node<V, A> node4, final Digit<V, Node<V, A>> digit2, final FingerTree<V, Node<V, Node<V, A>>> fingerTree2) {
        final MakeTree<V, Node<V, A>> makeTree = Deep.mkTree(measured);
        return (FingerTree)digit.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(final One<V, Node<V, A>> one) {
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one2) {
                        return Deep.append2(measured, fingerTree, makeTree.node3(one.value(), node, node2), makeTree.node3(node3, node4, one2.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(one.value(), node, node2), makeTree.node2(node3, node4), makeTree.node2(two.values()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        V3 v3 = three.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(one.value(), node, node2), makeTree.node3(node3, node4, v3._1()), makeTree.node2(v3._2(), v3._3()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v4 = four.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(one.value(), node, node2), makeTree.node3(node3, node4, v4._1()), makeTree.node3(v4._2(), v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                final V2 v2 = two.values();
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node2(node2, node3), makeTree.node2(node4, one.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node3(node2, node3, node4), makeTree.node2(two.values()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node3(node2, node3, node4), makeTree.node3(three.values()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v4 = four.values();
                        return Deep.append4(measured, fingerTree, makeTree.node3(v2._1(), v2._2(), node), makeTree.node3(node2, node3, node4), makeTree.node2(v4._1(), v4._2()), makeTree.node2(v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                final V3 v3 = three.values();
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v3), makeTree.node3(node, node2, node3), makeTree.node2(node4, one.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        V2 v2 = two.values();
                        return Deep.append3(measured, fingerTree, makeTree.node3(v3), makeTree.node3(node, node2, node3), makeTree.node3(node4, v2._1(), v2._2()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        V3 v32 = three.values();
                        return Deep.append4(measured, fingerTree, makeTree.node3(v3), makeTree.node3(node, node2, node3), makeTree.node2(node4, v32._1()), makeTree.node2(v32._2(), v32._3()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v4 = four.values();
                        return Deep.append4(measured, fingerTree, makeTree.node3(v3), makeTree.node3(node, node2, node3), makeTree.node3(node4, v4._1(), v4._2()), makeTree.node2(v4._3(), v4._4()), fingerTree2);
                    }
                });
            }
        }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

            @Override
            public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                final V4 v4 = four.values();
                return (FingerTree)digit2.match(new F<One<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(One<V, Node<V, A>> one) {
                        return Deep.append3(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, node2), makeTree.node3(node3, node4, one.value()), fingerTree2);
                    }
                }, new F<Two<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Two<V, Node<V, A>> two) {
                        return Deep.append4(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, node2), makeTree.node2(node3, node4), makeTree.node2(two.values()), fingerTree2);
                    }
                }, new F<Three<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Three<V, Node<V, A>> three) {
                        V3 v3 = three.values();
                        return Deep.append4(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, node2), makeTree.node3(node3, node4, v3._1()), makeTree.node2(v3._2(), v3._3()), fingerTree2);
                    }
                }, new F<Four<V, Node<V, A>>, FingerTree<V, Node<V, Node<V, A>>>>(){

                    @Override
                    public FingerTree<V, Node<V, Node<V, A>>> f(Four<V, Node<V, A>> four) {
                        V4 v42 = four.values();
                        return Deep.append4(measured, fingerTree, makeTree.node3(v4._1(), v4._2(), v4._3()), makeTree.node3(v4._4(), node, node2), makeTree.node3(node3, node4, v42._1()), makeTree.node3(v42._2(), v42._3(), v42._4()), fingerTree2);
                    }
                });
            }
        });
    }
}

