/*
 * Decompiled with CFR 0.152.
 */
package fj.data.fingertrees;

import fj.data.fingertrees.Deep;
import fj.data.fingertrees.Digit;
import fj.data.fingertrees.Empty;
import fj.data.fingertrees.FingerTree;
import fj.data.fingertrees.Four;
import fj.data.fingertrees.Measured;
import fj.data.fingertrees.Node;
import fj.data.fingertrees.Node2;
import fj.data.fingertrees.Node3;
import fj.data.fingertrees.One;
import fj.data.fingertrees.Single;
import fj.data.fingertrees.Three;
import fj.data.fingertrees.Two;
import fj.data.vector.V;
import fj.data.vector.V2;
import fj.data.vector.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MakeTree<V, A> {
    private final Measured<V, A> m;

    MakeTree(Measured<V, A> measured) {
        this.m = measured;
    }

    public FingerTree<V, A> empty() {
        return new Empty<V, A>(this.m);
    }

    public FingerTree<V, A> single(A a) {
        return new Single<V, A>(this.m, a);
    }

    public FingerTree<V, A> deep(Digit<V, A> digit, FingerTree<V, Node<V, A>> fingerTree, Digit<V, A> digit2) {
        return this.deep(this.m.sum(digit.measure(), this.m.sum(fingerTree.measure(), digit2.measure())), digit, fingerTree, digit2);
    }

    public FingerTree<V, A> deep(V v, Digit<V, A> digit, FingerTree<V, Node<V, A>> fingerTree, Digit<V, A> digit2) {
        return new Deep<V, A>(this.m, v, digit, fingerTree, digit2);
    }

    public One<V, A> one(A a) {
        return new One<V, A>(this.m, a);
    }

    public Two<V, A> two(A a, A a2) {
        return new Two<V, A>(this.m, V.v(a, a2));
    }

    public Three<V, A> three(A a, A a2, A a3) {
        return new Three<V, A>(this.m, V.v(a, a2, a3));
    }

    public Four<V, A> four(A a, A a2, A a3, A a4) {
        return new Four<V, A>(this.m, V.v(a, a2, a3, a4));
    }

    public Node2<V, A> node2(A a, A a2) {
        return new Node2<V, A>(this.m, V.v(a, a2));
    }

    public Node3<V, A> node3(A a, A a2, A a3) {
        return new Node3<V, A>(this.m, V.v(a, a2, a3));
    }

    public Node2<V, A> node2(V2<A> v2) {
        return new Node2<V, A>(this.m, v2);
    }

    public Node3<V, A> node3(V3<A> v3) {
        return new Node3<V, A>(this.m, v3);
    }
}

