/*
 * Decompiled with CFR 0.152.
 */
package fj.parser;

import fj.Digit;
import fj.F;
import fj.P;
import fj.P1;
import fj.Semigroup;
import fj.Unit;
import fj.data.List;
import fj.data.Stream;
import fj.data.Validation;
import fj.parser.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Parser<I, A, E> {
    private final F<I, Validation<E, Result<I, A>>> f;

    private Parser(F<I, Validation<E, Result<I, A>>> f) {
        this.f = f;
    }

    public Validation<E, Result<I, A>> parse(I i) {
        return this.f.f(i);
    }

    public <Z> Parser<Z, A, E> xmap(final F<I, Z> f, final F<Z, I> f2) {
        return Parser.parser(new F<Z, Validation<E, Result<Z, A>>>(){

            @Override
            public Validation<E, Result<Z, A>> f(Z z) {
                return Parser.this.parse(f2.f(z)).map(new F<Result<I, A>, Result<Z, A>>(){

                    @Override
                    public Result<Z, A> f(Result<I, A> result) {
                        return result.mapRest(f);
                    }
                });
            }
        });
    }

    public <B> Parser<I, B, E> map(final F<A, B> f) {
        return Parser.parser(new F<I, Validation<E, Result<I, B>>>(){

            @Override
            public Validation<E, Result<I, B>> f(I i) {
                return Parser.this.parse(i).map(new F<Result<I, A>, Result<I, B>>(){

                    @Override
                    public Result<I, B> f(Result<I, A> result) {
                        return result.mapValue(f);
                    }
                });
            }
        });
    }

    public Parser<I, A, E> filter(final F<A, Boolean> f, final E e) {
        return Parser.parser(new F<I, Validation<E, Result<I, A>>>(){

            @Override
            public Validation<E, Result<I, A>> f(I i) {
                return Parser.this.parse(i).bind(new F<Result<I, A>, Validation<E, Result<I, A>>>(){

                    @Override
                    public Validation<E, Result<I, A>> f(Result<I, A> result) {
                        Object a = result.value();
                        return (Boolean)f.f(a) != false ? Validation.success(Result.result(result.rest(), a)) : Validation.fail(e);
                    }
                });
            }
        });
    }

    public <B> Parser<I, B, E> bind(final F<A, Parser<I, B, E>> f) {
        return Parser.parser(new F<I, Validation<E, Result<I, B>>>(){

            @Override
            public Validation<E, Result<I, B>> f(I i) {
                return Parser.this.parse(i).bind(new F<Result<I, A>, Validation<E, Result<I, B>>>(){

                    @Override
                    public Validation<E, Result<I, B>> f(Result<I, A> result) {
                        return ((Parser)f.f(result.value())).parse(result.rest());
                    }
                });
            }
        });
    }

    public <B, C> Parser<I, C, E> bind(Parser<I, B, E> parser, F<A, F<B, C>> f) {
        return parser.apply(this.map(f));
    }

    public <B, C, D> Parser<I, D, E> bind(Parser<I, B, E> parser, Parser<I, C, E> parser2, F<A, F<B, F<C, D>>> f) {
        return parser2.apply(this.bind(parser, f));
    }

    public <B, C, D, E$> Parser<I, E$, E> bind(Parser<I, B, E> parser, Parser<I, C, E> parser2, Parser<I, D, E> parser3, F<A, F<B, F<C, F<D, E$>>>> f) {
        return parser3.apply(this.bind(parser, parser2, f));
    }

    public <B, C, D, E$, F$> Parser<I, F$, E> bind(Parser<I, B, E> parser, Parser<I, C, E> parser2, Parser<I, D, E> parser3, Parser<I, E$, E> parser4, F<A, F<B, F<C, F<D, F<E$, F$>>>>> f) {
        return parser4.apply(this.bind(parser, parser2, parser3, f));
    }

    public <B, C, D, E$, F$, G> Parser<I, G, E> bind(Parser<I, B, E> parser, Parser<I, C, E> parser2, Parser<I, D, E> parser3, Parser<I, E$, E> parser4, Parser<I, F$, E> parser5, F<A, F<B, F<C, F<D, F<E$, F<F$, G>>>>>> f) {
        return parser5.apply(this.bind(parser, parser2, parser3, parser4, f));
    }

    public <B, C, D, E$, F$, G, H> Parser<I, H, E> bind(Parser<I, B, E> parser, Parser<I, C, E> parser2, Parser<I, D, E> parser3, Parser<I, E$, E> parser4, Parser<I, F$, E> parser5, Parser<I, G, E> parser6, F<A, F<B, F<C, F<D, F<E$, F<F$, F<G, H>>>>>>> f) {
        return parser6.apply(this.bind(parser, parser2, parser3, parser4, parser5, f));
    }

    public <B, C, D, E$, F$, G, H, I$> Parser<I, I$, E> bind(Parser<I, B, E> parser, Parser<I, C, E> parser2, Parser<I, D, E> parser3, Parser<I, E$, E> parser4, Parser<I, F$, E> parser5, Parser<I, G, E> parser6, Parser<I, H, E> parser7, F<A, F<B, F<C, F<D, F<E$, F<F$, F<G, F<H, I$>>>>>>>> f) {
        return parser7.apply(this.bind(parser, parser2, parser3, parser4, parser5, parser6, f));
    }

    public <B> Parser<I, B, E> sequence(final Parser<I, B, E> parser) {
        return this.bind(new F<A, Parser<I, B, E>>(){

            @Override
            public Parser<I, B, E> f(A a) {
                return parser;
            }
        });
    }

    public <B> Parser<I, B, E> apply(Parser<I, F<A, B>, E> parser) {
        return parser.bind(new F<F<A, B>, Parser<I, B, E>>(){

            @Override
            public Parser<I, B, E> f(F<A, B> f) {
                return Parser.this.map(f);
            }
        });
    }

    public Parser<I, A, E> or(final P1<Parser<I, A, E>> p1) {
        return Parser.parser(new F<I, Validation<E, Result<I, A>>>(){

            @Override
            public Validation<E, Result<I, A>> f(I i) {
                return Parser.this.parse(i).f().sequence(((Parser)p1._1()).parse(i));
            }
        });
    }

    public Parser<I, A, E> or(Parser<I, A, E> parser) {
        return this.or(P.p(parser));
    }

    public Parser<I, A, E> or(final P1<Parser<I, A, E>> p1, final Semigroup<E> semigroup) {
        return Parser.parser(new F<I, Validation<E, Result<I, A>>>(){

            @Override
            public Validation<E, Result<I, A>> f(final I i) {
                return Parser.this.parse(i).f().bind(new F<E, Validation<E, Result<I, A>>>(){

                    @Override
                    public Validation<E, Result<I, A>> f(E e) {
                        return ((Parser)p1._1()).parse(i).f().map(semigroup.sum(e));
                    }
                });
            }
        });
    }

    public Parser<I, A, E> or(Parser<I, A, E> parser, Semigroup<E> semigroup) {
        return this.or(P.p(parser), semigroup);
    }

    public Parser<I, Unit, E> not(final P1<E> p1) {
        return Parser.parser(new F<I, Validation<E, Result<I, Unit>>>(){

            @Override
            public Validation<E, Result<I, Unit>> f(I i) {
                return Parser.this.parse(i).isFail() ? Validation.success(Result.result(i, Unit.unit())) : Validation.fail(p1._1());
            }
        });
    }

    public Parser<I, Unit, E> not(E e) {
        return this.not((E)P.p(e));
    }

    public Parser<I, Stream<A>, E> repeat() {
        return this.repeat1().or(new P1<Parser<I, Stream<A>, E>>(){

            @Override
            public Parser<I, Stream<A>, E> _1() {
                return Parser.value(Stream.nil());
            }
        });
    }

    public Parser<I, Stream<A>, E> repeat1() {
        return this.bind(new F<A, Parser<I, Stream<A>, E>>(){

            @Override
            public Parser<I, Stream<A>, E> f(final A a) {
                return Parser.this.repeat().map(new F<Stream<A>, Stream<A>>(){

                    @Override
                    public Stream<A> f(Stream<A> stream) {
                        return stream.cons(a);
                    }
                });
            }
        });
    }

    public <K> Parser<I, A, K> mapError(final F<E, K> f) {
        return Parser.parser(new F<I, Validation<K, Result<I, A>>>(){

            @Override
            public Validation<K, Result<I, A>> f(I i) {
                return ((Validation)Parser.this.f.f(i)).f().map(f);
            }
        });
    }

    public static <I, A, E> Parser<I, A, E> parser(F<I, Validation<E, Result<I, A>>> f) {
        return new Parser<I, A, E>(f);
    }

    public static <I, A, E> Parser<I, A, E> value(final A a) {
        return Parser.parser(new F<I, Validation<E, Result<I, A>>>(){

            @Override
            public Validation<E, Result<I, A>> f(I i) {
                return Validation.success(Result.result(i, a));
            }
        });
    }

    public static <I, A, E> Parser<I, A, E> fail(final E e) {
        return Parser.parser(new F<I, Validation<E, Result<I, A>>>(){

            @Override
            public Validation<E, Result<I, A>> f(I i) {
                return Validation.fail(e);
            }
        });
    }

    public static <I, A, E> Parser<I, List<A>, E> sequence(final List<Parser<I, A, E>> list) {
        return list.isEmpty() ? Parser.value(List.nil()) : list.head().bind(new F<A, Parser<I, List<A>, E>>(){

            @Override
            public Parser<I, List<A>, E> f(A a) {
                return Parser.sequence(list.tail()).map(List.cons_(a));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CharsParser {
        private CharsParser() {
        }

        public static <E> Parser<Stream<Character>, Character, E> character(P1<E> p1) {
            return StreamParser.element(p1);
        }

        public static <E> Parser<Stream<Character>, Character, E> character(E e) {
            return CharsParser.character(P.p(e));
        }

        public static <E> Parser<Stream<Character>, Character, E> character(P1<E> p1, F<Character, E> f, final char c) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c2) {
                    return c2.charValue() == c;
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> character(E e, F<Character, E> f, char c) {
            return CharsParser.character(P.p(e), f, c);
        }

        public static <E> Parser<Stream<Character>, Stream<Character>, E> characters(P1<E> p1, int n) {
            return n <= 0 ? Parser.value(Stream.nil()) : CharsParser.character(p1).bind(CharsParser.characters(p1, n - 1), Stream.cons_());
        }

        public static <E> Parser<Stream<Character>, Stream<Character>, E> characters(E e, int n) {
            return CharsParser.characters(P.p(e), n);
        }

        public static <E> Parser<Stream<Character>, Stream<Character>, E> characters(P1<E> p1, F<Character, E> f, Stream<Character> stream) {
            return stream.isEmpty() ? Parser.value(Stream.nil()) : CharsParser.character(p1, f, stream.head().charValue()).bind(CharsParser.characters(p1, f, stream.tail()._1()), Stream.cons_());
        }

        public static <E> Parser<Stream<Character>, Stream<Character>, E> characters(E e, F<Character, E> f, Stream<Character> stream) {
            return CharsParser.characters(P.p(e), f, stream);
        }

        public static <E> Parser<Stream<Character>, String, E> string(P1<E> p1, F<Character, E> f, String string) {
            return CharsParser.characters(p1, f, List.fromString(string).toStream()).map(new F<Stream<Character>, String>(){

                @Override
                public String f(Stream<Character> stream) {
                    return List.asString(stream.toList());
                }
            });
        }

        public static <E> Parser<Stream<Character>, String, E> string(E e, F<Character, E> f, String string) {
            return CharsParser.string(P.p(e), f, string);
        }

        public static <E> Parser<Stream<Character>, Digit, E> digit(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isDigit(c.charValue());
                }
            }).map(new F<Character, Digit>(){

                @Override
                public Digit f(Character c) {
                    return Digit.fromChar(c.charValue()).some();
                }
            });
        }

        public static <E> Parser<Stream<Character>, Digit, E> digit(E e, F<Character, E> f) {
            return CharsParser.digit(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> lower(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isLowerCase(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> lower(E e, F<Character, E> f) {
            return CharsParser.lower(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> upper(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isUpperCase(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> upper(E e, F<Character, E> f) {
            return CharsParser.upper(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> defined(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isDefined(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> defined(E e, F<Character, E> f) {
            return CharsParser.defined(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> highSurrogate(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isHighSurrogate(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> highSurrogate(E e, F<Character, E> f) {
            return CharsParser.highSurrogate(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> identifierIgnorable(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isIdentifierIgnorable(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> identifierIgnorable(E e, F<Character, E> f) {
            return CharsParser.identifierIgnorable(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> isoControl(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isISOControl(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> isoControl(E e, F<Character, E> f) {
            return CharsParser.isoControl(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> javaIdentifierPart(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isJavaIdentifierPart(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> javaIdentifierPart(E e, F<Character, E> f) {
            return CharsParser.javaIdentifierPart(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> javaIdentifierStart(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isJavaIdentifierStart(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> javaIdentifierStart(E e, F<Character, E> f) {
            return CharsParser.javaIdentifierStart(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> alpha(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isLetter(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> alpha(E e, F<Character, E> f) {
            return CharsParser.alpha(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> alphaNum(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isLetterOrDigit(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> alphaNum(E e, F<Character, E> f) {
            return CharsParser.alphaNum(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> lowSurrogate(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isLowSurrogate(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> lowSurrogate(E e, F<Character, E> f) {
            return CharsParser.lowSurrogate(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> mirrored(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isMirrored(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> mirrored(E e, F<Character, E> f) {
            return CharsParser.mirrored(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> space(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isSpaceChar(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> space(E e, F<Character, E> f) {
            return CharsParser.space(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> titleCase(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isTitleCase(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> titleCase(E e, F<Character, E> f) {
            return CharsParser.titleCase(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> unicodeIdentiferPart(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isUnicodeIdentifierPart(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> unicodeIdentiferPart(E e, F<Character, E> f) {
            return CharsParser.unicodeIdentiferPart(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> unicodeIdentiferStart(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isUnicodeIdentifierStart(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> unicodeIdentiferStart(E e, F<Character, E> f) {
            return CharsParser.unicodeIdentiferStart(P.p(e), f);
        }

        public static <E> Parser<Stream<Character>, Character, E> whitespace(P1<E> p1, F<Character, E> f) {
            return StreamParser.satisfy(p1, f, new F<Character, Boolean>(){

                @Override
                public Boolean f(Character c) {
                    return Character.isWhitespace(c.charValue());
                }
            });
        }

        public static <E> Parser<Stream<Character>, Character, E> whitespace(E e, F<Character, E> f) {
            return CharsParser.whitespace(P.p(e), f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StreamParser {
        private StreamParser() {
        }

        public static <I, E> Parser<Stream<I>, I, E> element(final P1<E> p1) {
            return Parser.parser(new F<Stream<I>, Validation<E, Result<Stream<I>, I>>>(){

                @Override
                public Validation<E, Result<Stream<I>, I>> f(Stream<I> stream) {
                    return stream.isEmpty() ? Validation.fail(p1._1()) : Validation.success(Result.result(stream.tail()._1(), stream.head()));
                }
            });
        }

        public static <I, E> Parser<Stream<I>, I, E> element(E e) {
            return StreamParser.element(P.p(e));
        }

        public static <I, E> Parser<Stream<I>, I, E> satisfy(P1<E> p1, final F<I, E> f, final F<I, Boolean> f2) {
            return StreamParser.element(p1).bind(new F<I, Parser<Stream<I>, I, E>>(){

                @Override
                public Parser<Stream<I>, I, E> f(I i) {
                    return (Boolean)f2.f(i) != false ? Parser.value(i) : Parser.fail(f.f(i));
                }
            });
        }

        public static <I, E> Parser<Stream<I>, I, E> satisfy(E e, F<I, E> f, F<I, Boolean> f2) {
            return StreamParser.satisfy(P.p(e), f, f2);
        }
    }
}

