/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.java;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.vcard4j.java.DomIterator;
import net.sf.vcard4j.java.Type;
import net.sf.vcard4j.java.VCard;
import net.sf.vcard4j.util.XpathUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddressBook {
    private Element addressBook;
    protected Map mapping = new HashMap();

    protected Element getElement() {
        return this.addressBook;
    }

    private AddressBook() {
    }

    public AddressBook(Element addressBook) {
        if (addressBook == null) {
            throw new NullPointerException("Address book is null");
        }
        if (!addressBook.getNodeName().equals("addressBook")) {
            throw new IllegalArgumentException("Not an address book: " + addressBook.getNodeName());
        }
        this.addressBook = addressBook;
    }

    public AddressBook(Document addressBook) {
        this.addressBook = (Element)XpathUtil.getNode(addressBook, "/addressBook");
    }

    public Type addVCard(String typeName) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeVCard(VCard vcard) {
        this.mapping.remove(vcard.getElement());
        this.addressBook.removeChild(vcard.getElement());
    }

    public Iterator getVCards() {
        return new VCardIterator(XpathUtil.getNodeArray(this.addressBook, "vcard"), this.mapping);
    }

    protected class VCardIterator
    extends DomIterator {
        protected VCardIterator(Node[] nodes, Map mapping) {
            super(nodes, mapping);
        }

        @Override
        protected Object newWrapper(Element vcard) {
            return new VCard(vcard);
        }
    }
}

