/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.java;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import net.sf.vcard4j.java.Type;
import net.sf.vcard4j.util.XpathUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class ListType
extends Type {
    public ListType(Element type) {
        super(type);
    }

    protected Object get(Constructor c, int index) {
        try {
            return c.newInstance(XpathUtil.getValue(this.getElement(), "value/listItem[" + (index + 1) + "]/text/text()"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected int size() {
        return XpathUtil.getNodeArray(this.getElement(), "value/listItem").length;
    }

    protected void add(Object value) {
        Document document = this.getElement().getOwnerDocument();
        Node valueNode = XpathUtil.getNode(this.getElement(), "value");
        Element listItem = document.createElement("listItem");
        Element textNode = document.createElement("text");
        Text textString = document.createTextNode(value.toString());
        textNode.appendChild(textString);
        listItem.appendChild(textNode);
        valueNode.appendChild(listItem);
    }

    protected Iterator iterator(Constructor c) {
        Iterator it = XpathUtil.getNodeIterator(this.getElement(), "value/listItem");
        return new LTIterator(it, c);
    }

    protected class LTIterator
    implements Iterator {
        Constructor constructor;
        Iterator iterator;
        Node node = null;

        protected LTIterator(Iterator it, Constructor c) {
            this.iterator = it;
            this.constructor = c;
        }

        @Override
        public void remove() {
            this.node.getParentNode().removeChild(this.node);
            this.node = null;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.node = (Node)this.iterator.next();
            try {
                return this.constructor.newInstance(XpathUtil.getValue(this.node, "text/text()"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

